/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.versioning;

import java.io.IOException;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.catalina.connector.Response;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.web.tomcat6.versioning.ContextFinder;
import org.ow2.jonas.web.tomcat6.versioning.VersionedPathBean;

public class FilteredOutputStream
extends OutputBuffer {
    private Response response;

    public FilteredOutputStream(Response response) {
        this.response = response;
    }

    public FilteredOutputStream(Response response, int size) {
        super(size);
        this.response = response;
    }

    public void write(String s, int off, int cnt) throws IOException {
        if (s == null) {
            super.write(s, off, cnt);
            return;
        }
        VersionedPathBean vpb = this.findVersionedPathBean(this.response.getContentType());
        if (vpb != null) {
            int originalOffset = off;
            int originalCount = cnt;
            int originalLength = originalOffset + originalCount;
            for (int i = originalOffset; i < originalLength; ++i) {
                if (vpb.getVersionedPath().charAt(0) != s.charAt(i)) continue;
                boolean isVersionedPath = true;
                for (int j = i + 1; j < Math.min(i + vpb.getVersionedPath().length(), originalLength); ++j) {
                    if (vpb.getVersionedPath().charAt(j - i) == s.charAt(j)) continue;
                    isVersionedPath = false;
                    break;
                }
                if (!isVersionedPath) continue;
                super.write(s, off, i - off);
                super.write(vpb.getUserPath());
                i += vpb.getVersionedPath().length();
                if ("/".equals(vpb.getUserPath())) {
                    while (i < originalLength && s.charAt(i) == '/') {
                        ++i;
                    }
                }
                off = i;
                cnt = originalCount - i;
            }
        }
        super.write(s, off, cnt);
    }

    public void write(char[] buf, int off, int cnt) throws IOException {
        if (buf == null) {
            super.write(buf, off, cnt);
            return;
        }
        VersionedPathBean vpb = this.findVersionedPathBean(this.response.getContentType());
        if (vpb != null) {
            int originalOffset = off;
            int originalCount = cnt;
            int originalLength = originalOffset + originalCount;
            for (int i = originalOffset; i < originalLength; ++i) {
                if (vpb.getVersionedPath().charAt(0) != buf[i]) continue;
                boolean isVersionedPath = true;
                for (int j = i + 1; j < Math.min(i + vpb.getVersionedPath().length(), originalLength); ++j) {
                    if (vpb.getVersionedPath().charAt(j - i) == buf[j]) continue;
                    isVersionedPath = false;
                    break;
                }
                if (!isVersionedPath) continue;
                super.write(buf, off, i - off);
                super.write(vpb.getUserPath());
                i += vpb.getVersionedPath().length();
                if ("/".equals(vpb.getUserPath())) {
                    while (i < originalLength && buf[i] == '/') {
                        ++i;
                    }
                }
                off = i;
                cnt = originalCount - i;
            }
        }
        super.write(buf, off, cnt);
    }

    private VersionedPathBean findVersionedPathBean(String contentType) {
        if (contentType != null && ContextFinder.getParent() != null) {
            String[] filteredContentTypes;
            VersioningService versioning = ContextFinder.getParent().getVersioningService();
            VersionedPathBean vpb = this.response.getVersionedPathBean();
            if (vpb != null && vpb.getUserPath() != null && vpb.getVersionedPath() != null && versioning != null && versioning.isVersioningEnabled() && (filteredContentTypes = versioning.getFilteredContentTypesArray()) != null && filteredContentTypes.length > 0) {
                for (String filteredContentType : filteredContentTypes) {
                    if (!contentType.startsWith(filteredContentType)) continue;
                    return vpb;
                }
            }
        }
        return null;
    }
}

