/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.launch;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class Shortcut
implements ILaunchShortcut {
    public Shortcut() {
        System.out.println("Constructor Launch Shortcut");
    }

    protected String getLaunchConfigurationTypeId() {
        return "aQute.bnd.launch";
    }

    public void launch(ISelection selection, String mode) {
        IStructuredSelection is = (IStructuredSelection)selection;
        if (is.getFirstElement() != null) {
            Object selected = is.getFirstElement();
            IJavaElement element = null;
            if (selected instanceof IJavaElement) {
                element = (IJavaElement)selected;
            } else if (selected instanceof IAdaptable) {
                element = (IJavaElement)((IAdaptable)selected).getAdapter(IJavaElement.class);
            }
            if (element != null) {
                this.launch(element.getJavaProject(), mode);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IJavaProject jproject;
        IEditorInput input = editor.getEditorInput();
        IJavaElement je = (IJavaElement)input.getAdapter(IJavaElement.class);
        if (je != null && (jproject = je.getJavaProject()) != null) {
            this.launch(jproject, mode);
        }
    }

    void launch(IJavaProject project, String mode) {
        try {
            ILaunchConfiguration config = this.find(project);
            if (config == null) {
                config = this.createConfiguration(project);
            }
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("aQute.bnd.launch");
    }

    ILaunchConfiguration find(IJavaProject project) throws CoreException {
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getConfigurationType());
        int i = 0;
        while (i < configs.length) {
            ILaunchConfiguration config = configs[i];
            if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(project.getElementName())) {
                candidateConfigs.add(config);
            }
            ++i;
        }
        if (candidateConfigs.size() == 0) {
            return null;
        }
        return (ILaunchConfiguration)candidateConfigs.get(candidateConfigs.size() - 1);
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ILaunchConfiguration createConfiguration(IJavaProject type) throws Exception {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfigurationType configType = this.getConfigurationType();
        wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getElementName());
        config = wc.doSave();
        return config;
    }
}

