/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.popup.actions.repo;

import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.osgi.Jar;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoDialog
extends Dialog {
    private Text bsn;
    private Text version;
    private Label lblRepository;
    private Combo repositories;
    private Jar jar;
    private List<RepositoryPlugin> repos;
    private Button wrap;

    public RepoDialog(Shell parentShell, Jar jar, List<RepositoryPlugin> repos) {
        super(parentShell);
        this.setShellStyle(2144);
        this.jar = jar;
        this.repos = repos;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout(null);
        this.lblRepository = new Label(container, 0);
        this.lblRepository.setBounds(8, 8, 160, 24);
        this.lblRepository.setText("Repository");
        this.repositories = new Combo(container, 8);
        this.repositories.setBounds(168, 3, 272, 30);
        this.bsn = new Text(container, 2048);
        this.bsn.setBounds(168, 35, 272, 28);
        this.version = new Text(container, 2048);
        this.version.setBounds(168, 67, 272, 28);
        Label lblBundleSymbolicName = new Label(container, 0);
        lblBundleSymbolicName.setBounds(8, 40, 160, 24);
        lblBundleSymbolicName.setText("Bundle Symbolic Name");
        Label lblVersion = new Label(container, 0);
        lblVersion.setBounds(8, 72, 160, 24);
        lblVersion.setText("Bundle Version");
        this.wrap = new Button(container, 0);
        this.wrap.setBounds(338, 105, 102, 28);
        this.wrap.setText("Wrap");
        this.setup();
        return container;
    }

    private void setup() {
        try {
            String bsn = null;
            String version = null;
            Manifest manifest = this.jar.getManifest();
            if (manifest == null) {
                bsn = this.jar.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
                if (bsn != null) {
                    this.bsn.setText(bsn);
                }
                if ((version = this.jar.getManifest().getMainAttributes().getValue("Bundle-Version")) != null) {
                    this.version.setText(version);
                }
            }
            Iterator<RepositoryPlugin> i = this.repos.iterator();
            while (i.hasNext()) {
                RepositoryPlugin plugin = i.next();
                if (plugin.canWrite()) {
                    this.repositories.add(plugin.getName());
                    continue;
                }
                i.remove();
            }
            this.repositories.select(0);
            this.wrap.setEnabled(bsn != null);
            this.bsn.setEnabled(bsn != null);
            this.version.setEnabled(bsn != null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public RepositoryPlugin getRepository() {
        int n = this.repositories.getSelectionIndex();
        return this.repos.get(n);
    }
}

