/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.jaxp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.validation.Schema;
import org.eclipse.persistence.platform.xml.DefaultErrorHandler;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXPParser
implements XMLParser {
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler = new DefaultErrorHandler();

    public JAXPParser() {
        this.setNamespaceAware(true);
        this.setWhitespacePreserving(false);
    }

    public void setNamespaceAware(boolean isNamespaceAware) {
        this.documentBuilderFactory.setNamespaceAware(isNamespaceAware);
    }

    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(!isWhitespacePreserving);
    }

    public int getValidationMode() {
        if (!this.documentBuilderFactory.isValidating()) {
            return 0;
        }
        try {
            if (null == this.documentBuilderFactory.getAttribute(SCHEMA_LANGUAGE)) {
                return 2;
            }
        }
        catch (IllegalArgumentException e) {
            return 2;
        }
        return 3;
    }

    public void setValidationMode(int validationMode) {
        switch (validationMode) {
            case 0: {
                this.documentBuilderFactory.setValidating(false);
                return;
            }
            case 2: {
                this.documentBuilderFactory.setValidating(true);
                return;
            }
            case 3: {
                try {
                    this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
                    this.documentBuilderFactory.setValidating(true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setXMLSchema(URL url) throws XMLPlatformException {
        if (null == url) {
            return;
        }
        try {
            this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            this.documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, url.toString());
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            XMLPlatformException.xmlPlatformErrorResolvingXMLSchema(url, e);
        }
    }

    public void setXMLSchema(Schema schema) throws XMLPlatformException {
        this.documentBuilderFactory.setSchema(schema);
    }

    public Schema getXMLSchema() throws XMLPlatformException {
        return this.documentBuilderFactory.getSchema();
    }

    public void setXMLSchemas(Object[] schemas) throws XMLPlatformException {
        if (null == schemas || schemas.length == 0) {
            return;
        }
        try {
            this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            this.documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, schemas);
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            XMLPlatformException.xmlPlatformErrorResolvingXMLSchemas(schemas, e);
        }
    }

    public Document parse(InputSource inputSource) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(inputSource);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }

    public Document parse(File file) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(file);
        }
        catch (SAXParseException e) {
            throw XMLPlatformException.xmlPlatformSAXParseException(e);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformFileNotFoundException(file, e);
        }
    }

    public Document parse(InputStream inputStream) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(inputStream);
        }
        catch (SAXParseException e) {
            throw XMLPlatformException.xmlPlatformSAXParseException(e);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }

    public Document parse(Reader reader) throws XMLPlatformException {
        InputSource inputSource = new InputSource(reader);
        return this.parse(inputSource);
    }

    public Document parse(Source source) throws XMLPlatformException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            SAXResult saxResult = new SAXResult();
            SAXDocumentBuilder builder = new SAXDocumentBuilder();
            saxResult.setHandler(builder);
            transformer.transform(source, saxResult);
            return builder.getDocument();
        }
        catch (TransformerException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }

    public Document parse(URL url) throws XMLPlatformException {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        boolean hasThrownException = false;
        try {
            Document document = this.parse(inputStream);
            return document;
        }
        catch (RuntimeException e) {
            hasThrownException = true;
            throw e;
        }
        finally {
            block11: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (hasThrownException) break block11;
                    throw XMLPlatformException.xmlPlatformParseException(e);
                }
            }
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(this.entityResolver);
            documentBuilder.setErrorHandler(this.errorHandler);
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }
}

