/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.PorterStemmer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class PorterStemFilter
extends TokenFilter {
    private PorterStemmer stemmer = new PorterStemmer();

    public PorterStemFilter(TokenStream in) {
        super(in);
    }

    public final Token next(Token result) throws IOException {
        if ((result = this.input.next(result)) != null) {
            if (this.stemmer.stem(result.termBuffer(), 0, result.termLength)) {
                result.setTermBuffer(this.stemmer.getResultBuffer(), 0, this.stemmer.getResultLength());
            }
            return result;
        }
        return null;
    }
}

