/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxrpc.base;

import java.io.InputStream;
import java.util.Properties;
import org.ow2.jonas.ws.jaxrpc.WSException;
import org.ow2.jonas.ws.jaxrpc.factory.JServiceFactory;

public class ClientJServiceFactoryFinder {
    private static Properties props;
    private static final String JONAS_SERVICE_FACTORY = "jonas.service.ws.factory.class";
    private static String factoryClassName;

    private ClientJServiceFactoryFinder() {
    }

    public static JServiceFactory getJOnASServiceFactory() throws WSException {
        JServiceFactory factory = null;
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        if (props == null) {
            props = new Properties();
            try {
                InputStream is = current.getResourceAsStream("jonas-client.properties");
                if (is != null) {
                    props.load(is);
                    factoryClassName = props.getProperty(JONAS_SERVICE_FACTORY);
                } else {
                    System.err.println("Cannot load jonas-client.properties from ClassLoader");
                }
            }
            catch (Exception e) {
                String err = "Error when trying to get jonas property 'jonas.service.ws.factory.class' from jonas-client.properties";
                throw new WSException(err, e);
            }
        }
        if (factoryClassName == null) {
            String err = "jonas property 'jonas.service.ws.factory.class' must be set! in jonas-client.properties";
            throw new WSException(err);
        }
        try {
            factory = (JServiceFactory)current.loadClass(factoryClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            String err = "ClassNotFound '" + factoryClassName + "' in JOnAS ClassLoader";
            throw new WSException(err);
        }
        catch (InstantiationException ie) {
            String err = "Instantiation error for new '" + factoryClassName + "'";
            throw new WSException(err);
        }
        catch (IllegalAccessException ie) {
            String err = "Illegal Access for new '" + factoryClassName + "'";
            throw new WSException(err);
        }
        return factory;
    }

    static {
        factoryClassName = null;
    }
}

