/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing;

import java.io.Serializable;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.ProducerConsumerQueue;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierConsumerEntityProducer
implements Runnable {
    private static final Logger log = LoggerFactory.make();
    private final ProducerConsumerQueue<List<Serializable>> source;
    private final ProducerConsumerQueue<Object> destination;
    private final SessionFactory sessionFactory;
    private final CacheMode cacheMode;
    private final Class<?> type;
    private final MassIndexerProgressMonitor monitor;

    public IdentifierConsumerEntityProducer(ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities, ProducerConsumerQueue<Object> fromEntityToAddwork, MassIndexerProgressMonitor monitor, SessionFactory sessionFactory, CacheMode cacheMode, Class<?> type) {
        this.source = fromIdentifierListToEntities;
        this.destination = fromEntityToAddwork;
        this.monitor = monitor;
        this.sessionFactory = sessionFactory;
        this.cacheMode = cacheMode;
        this.type = type;
        log.trace("created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.trace("started");
        org.hibernate.classic.Session session = this.sessionFactory.openSession();
        session.setFlushMode(FlushMode.MANUAL);
        session.setCacheMode(this.cacheMode);
        session.setDefaultReadOnly(true);
        try {
            Transaction transaction = session.beginTransaction();
            this.loadAllFromQueue(session);
            transaction.commit();
        }
        finally {
            session.close();
        }
        log.trace("finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllFromQueue(Session session) {
        try {
            List<Serializable> take;
            do {
                if ((take = this.source.take()) == null) continue;
                List<Serializable> listIds = take;
                log.trace("received list of ids {}", listIds);
                this.loadList(listIds, session);
            } while (take != null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.destination.producerStopping();
        }
    }

    private void loadList(List<Serializable> listIds, Session session) throws InterruptedException {
        Criteria criteria = session.createCriteria(this.type).setCacheMode(this.cacheMode).setLockMode(LockMode.NONE).setCacheable(false).setFlushMode(FlushMode.MANUAL).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY).add(Restrictions.in("id", listIds));
        List list = criteria.list();
        this.monitor.entitiesLoaded(list.size());
        session.clear();
        for (Object obj : list) {
            this.destination.put(obj);
        }
    }
}

