/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.eclipselink.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.jpa.Archive;
import org.ow2.easybeans.osgi.eclipselink.deployment.BundleArchive;
import org.ow2.easybeans.osgi.eclipselink.deployment.EasyBeansDirectoryArchive;
import org.ow2.easybeans.osgi.eclipselink.deployment.EasyBeansJarFileArchive;

public class EasyBeansArchiveFactoryImpl
extends ArchiveFactoryImpl {
    public Archive createArchive(URL url) throws URISyntaxException, IOException {
        Logger.global.entering("EasyBeansArchiveFactoryImpl", "createArchive", new Object[]{url});
        String protocol = url.getProtocol();
        if ("bundle".equals(protocol) || "bundleentry".equals(protocol)) {
            return new BundleArchive(url);
        }
        if ("file".equals(protocol)) {
            File f;
            URI uri = Helper.toURI(url);
            try {
                f = new File(uri);
            }
            catch (IllegalArgumentException e) {
                f = new File(url.getPath());
            }
            if (f.isDirectory()) {
                return new EasyBeansDirectoryArchive(f);
            }
            return new EasyBeansJarFileArchive(new JarFile(f));
        }
        return super.createArchive(url);
    }
}

