/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.rpc;

import java.io.IOException;
import java.io.Serializable;
import org.ow2.easybeans.rpc.api.EJBRemoteRequest;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.easybeans.util.marshalling.Serialization;

public class EJBRemoteRequestImpl
implements EJBRemoteRequest {
    private static final long serialVersionUID = -3588466669344863787L;
    private String methodName = null;
    private Long methodHash;
    private byte[] byteArgs;
    private transient Object[] args = null;
    private String containerId = null;
    private String factoryName = null;
    private Long beanId = null;
    private String invokedBusinessInterfaceName = null;

    public EJBRemoteRequestImpl(String methodName, Long methodHash, Object[] args, String containerId, String factoryName, Long beanId, String invokedBusinessInterfaceName) throws RPCException {
        this.methodHash = methodHash;
        this.methodName = methodName;
        try {
            this.byteArgs = Serialization.storeObject((Serializable)args);
        }
        catch (IOException e) {
            throw new RPCException("Cannot serialize the arguments of the request.", (Throwable)e);
        }
        this.args = args;
        this.containerId = containerId;
        this.factoryName = factoryName;
        this.beanId = beanId;
        this.invokedBusinessInterfaceName = invokedBusinessInterfaceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Long getMethodHash() {
        return this.methodHash;
    }

    public Object[] getMethodArgs() throws IllegalStateException {
        try {
            this.args = (Object[])Serialization.loadObject(this.byteArgs);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot get arguments of the request", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot get arguments of the request", e);
        }
        return this.args;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getFactory() {
        return this.factoryName;
    }

    public Long getBeanId() {
        return this.beanId;
    }

    public String getInvokedBusinessInterfaceName() {
        return this.invokedBusinessInterfaceName;
    }
}

