/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.Protocol;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ConnectorUtils {
    private static Log logger = LogFactory.getLog(ConnectorUtils.class);

    private ConnectorUtils() {
    }

    public static JMXConnector getConnector(JMXServiceURL url, String username, String password) throws IOException, SecurityException {
        JMXConnector connector = null;
        HashMap<String, Object> env = new HashMap<String, Object>();
        String initCtxClass = null;
        String providerUrl = null;
        try {
            String urlPath = url.getURLPath();
            String protocol = ConnectorUtils.getProtocolFromJmxConnectorUrl(urlPath);
            Protocol p = ConfigurationRepository.getProtocol((String)protocol);
            initCtxClass = p.getInitialContextFactoryClassName();
            providerUrl = ConnectorUtils.getProviderUrlFromJmxConnectorUrl(urlPath);
        }
        catch (Exception e) {
            logger.debug((Object)("Unable to get the InitialContext from the protocol '" + url.getProtocol() + "'"), new Object[0]);
            return null;
        }
        if (initCtxClass != null) {
            env.put("java.naming.factory.initial", initCtxClass);
            env.put("java.naming.provider.url", providerUrl);
            logger.debug((Object)("Setting the InitialContext to " + initCtxClass), new Object[0]);
        }
        if (username != null && password != null) {
            String[] creds = new String[]{username, password};
            env.put("jmx.remote.credentials", creds);
        }
        try {
            final JMXServiceURL myUrl = url;
            final HashMap<String, Object> myEnv = env;
            IExecution<JMXConnector> exec = new IExecution<JMXConnector>(){

                public JMXConnector execute() throws Exception {
                    return JMXConnectorFactory.connect(myUrl, myEnv);
                }
            };
            ClassLoader cl = ConnectorUtils.class.getClassLoader();
            ExecutionResult res = new RunnableHelper().execute(cl, (IExecution)exec);
            if (res.hasException()) {
                throw res.getException();
            }
            connector = (JMXConnector)res.getResult();
        }
        catch (IOException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("JMXConnectorFactory error: " + e), new Object[0]);
        }
        return connector;
    }

    public static JMXConnector getConnector(String urlString, String username, String password) throws IOException, SecurityException, MalformedURLException {
        JMXServiceURL url = null;
        try {
            url = new JMXServiceURL(urlString);
            return ConnectorUtils.getConnector(url, username, password);
        }
        catch (MalformedURLException me) {
            logger.debug((Object)("Malformed URL:" + urlString), new Object[0]);
            throw me;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static String getProtocolFromJmxConnectorUrl(String url) {
        int proIndMax;
        int proIndMin = url.indexOf("/jndi/") + "/jndi/".length();
        String protocol = url.substring(proIndMin, proIndMax = url.indexOf("://"));
        if (protocol.equals("rmi")) {
            String subUrl = url.substring(proIndMax + "://".length());
            int subProIndMin = subUrl.indexOf("/") + "/".length();
            int subProIndMax = subUrl.indexOf("connector_");
            protocol = subUrl.substring(subProIndMin, subProIndMax);
        }
        return protocol;
    }

    public static String getProviderUrlFromJmxConnectorUrl(String url) {
        int proIndMin = url.indexOf("/jndi/") + "/jndi/".length();
        String protocol = ConnectorUtils.getProtocolFromJmxConnectorUrl(url);
        int urlIndMax = url.indexOf("/" + protocol + "connector");
        return url.substring(proIndMin, urlIndMax);
    }
}

