/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.ReferenceHashSet;
import org.apache.openjpa.util.UnsupportedException;

public class InformixDictionary
extends DBDictionary {
    public static final String VENDOR_IBM = "ibm";
    public boolean lockModeEnabled = false;
    public int lockWaitSeconds = 30;
    public boolean swapSchemaAndCatalog = true;
    protected boolean useJCC = false;
    private final Collection _seenConnections = new ReferenceHashSet(2);
    private static final Localizer _loc = Localizer.forPackage(InformixDictionary.class);

    public InformixDictionary() {
        this.platform = "Informix";
        this.validationSQL = "SELECT FIRST 1 CURRENT TIMESTAMP FROM informix.systables";
        this.supportsAutoAssign = true;
        this.autoAssignTypeName = "serial";
        this.lastGeneratedKeyQuery = "SELECT FIRST 1 DBINFO('sqlca.sqlerrd1') FROM informix.systables";
        this.supportsDeferredConstraints = false;
        this.constraintNameMode = "after";
        this.useGetStringForClobs = true;
        this.longVarcharTypeName = "TEXT";
        this.clobTypeName = "TEXT";
        this.smallintTypeName = "INT8";
        this.tinyintTypeName = "INT8";
        this.floatTypeName = "FLOAT";
        this.bitTypeName = "BOOLEAN";
        this.blobTypeName = "BYTE";
        this.doubleTypeName = "NUMERIC(32,20)";
        this.dateTypeName = "DATE";
        this.timeTypeName = "DATETIME HOUR TO SECOND";
        this.timestampTypeName = "DATETIME YEAR TO FRACTION(3)";
        this.doubleTypeName = "NUMERIC(32,20)";
        this.floatTypeName = "REAL";
        this.bigintTypeName = "NUMERIC(32,0)";
        this.doubleTypeName = "DOUBLE PRECISION";
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("BYTE", "DOUBLE PRECISION", "INTERVAL", "SMALLFLOAT", "TEXT", "INT8"));
        this.supportsLockingWithDistinctClause = false;
        this.supportsLockingWithMultipleTables = false;
        this.supportsLockingWithOrderClause = false;
        this.supportsSchemaForGetColumns = false;
        this.supportsSchemaForGetTables = false;
        this.allowsAliasInBulkClause = false;
        this.crossJoinClause = "JOIN";
        this.requiresConditionForCrossJoin = true;
        this.concatenateFunction = "CONCAT({0},{1})";
        this.nextSequenceQuery = "SELECT {0}.NEXTVAL FROM SYSTABLES WHERE TABID=1";
        this.supportsCorrelatedSubselect = false;
        this.swapSchemaAndCatalog = false;
        this.supportsNullDeleteAction = false;
        this.supportsDefaultDeleteAction = false;
        this.trimSchemaName = true;
    }

    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        DatabaseMetaData meta = conn.getMetaData();
        String driverName = meta.getDriverName();
        if (driverName != null) {
            if (driverName.equals("IBM DB2 JDBC Universal Driver Architecture")) {
                this.driverVendor = VENDOR_IBM;
                this.useJCC = true;
                this.setIdentifierCase(meta);
            } else if (driverName.equals("IBM Informix JDBC Driver for IBM Informix Dynamic Server")) {
                this.setIdentifierCase(meta);
                this.driverVendor = VENDOR_IBM;
            } else {
                this.driverVendor = "Informix".equalsIgnoreCase(driverName) ? "datadirect" : "other";
            }
        } else {
            this.driverVendor = "other";
        }
        if (this.isJDBC3) {
            conn.setHoldability(1);
            if (this.log.isTraceEnabled()) {
                this.log.trace(_loc.get("connection-defaults", new Object[]{conn.getAutoCommit(), conn.getHoldability(), conn.getTransactionIsolation()}));
            }
        }
    }

    private void setIdentifierCase(DatabaseMetaData meta) {
        block5: {
            try {
                if (meta.storesLowerCaseIdentifiers()) {
                    this.schemaCase = "lower";
                } else if (meta.storesMixedCaseIdentifiers()) {
                    this.schemaCase = "preserve";
                }
            }
            catch (SQLException e) {
                this.getLog().warn("cannot-determine-identifier-base-case");
                if (!this.getLog().isTraceEnabled()) break block5;
                this.getLog().trace(e.toString(), e);
            }
        }
    }

    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        return this.getColumns(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), DBIdentifier.newColumn(columnName), conn);
    }

    public Column[] getColumns(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, DBIdentifier columnName, Connection conn) throws SQLException {
        Column[] cols = super.getColumns(meta, catalog, schemaName, tableName, columnName, conn);
        for (int i = 0; cols != null && i < cols.length; ++i) {
            if (cols[i].getType() != -1) continue;
            cols[i].setType(2005);
        }
        return cols;
    }

    public Column newColumn(ResultSet colMeta) throws SQLException {
        Column col = super.newColumn(colMeta);
        if (this.swapSchemaAndCatalog) {
            col.setSchemaIdentifier(this.fromDBName(colMeta.getString("TABLE_CAT"), DBIdentifier.DBIdentifierType.CATALOG));
        }
        return col;
    }

    public PrimaryKey newPrimaryKey(ResultSet pkMeta) throws SQLException {
        PrimaryKey pk = super.newPrimaryKey(pkMeta);
        if (this.swapSchemaAndCatalog) {
            pk.setSchemaIdentifier(this.fromDBName(pkMeta.getString("TABLE_CAT"), DBIdentifier.DBIdentifierType.CATALOG));
        }
        return pk;
    }

    public Index newIndex(ResultSet idxMeta) throws SQLException {
        Index idx = super.newIndex(idxMeta);
        if (this.swapSchemaAndCatalog) {
            idx.setSchemaIdentifier(this.fromDBName(idxMeta.getString("TABLE_CAT"), DBIdentifier.DBIdentifierType.CATALOG));
        }
        return idx;
    }

    public void setBoolean(PreparedStatement stmnt, int idx, boolean val, Column col) throws SQLException {
        stmnt.setString(idx, val ? "t" : "f");
    }

    public String[] getCreateTableSQL(Table table) {
        String[] create = super.getCreateTableSQL(table);
        create[0] = create[0] + " LOCK MODE ROW";
        return create;
    }

    public String[] getAddPrimaryKeySQL(PrimaryKey pk) {
        String pksql = this.getPrimaryKeyConstraintSQL(pk);
        if (pksql == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(pk.getTable(), false) + " ADD CONSTRAINT " + pksql};
    }

    public String[] getAddForeignKeySQL(ForeignKey fk) {
        String fksql = this.getForeignKeyConstraintSQL(fk);
        if (fksql == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(fk.getTable(), false) + " ADD CONSTRAINT " + fksql};
    }

    public boolean supportsRandomAccessResultSet(Select sel, boolean forUpdate) {
        return !forUpdate && !sel.isLob() && super.supportsRandomAccessResultSet(sel, forUpdate);
    }

    public Connection decorate(Connection conn) throws SQLException {
        conn = super.decorate(conn);
        if (this.isJDBC3 && conn.getHoldability() != 1) {
            conn.setHoldability(1);
            if (this.log.isTraceEnabled()) {
                this.log.trace(_loc.get("connection-defaults", new Object[]{conn.getAutoCommit(), conn.getHoldability(), conn.getTransactionIsolation()}));
            }
        }
        if (this._seenConnections.add(conn)) {
            String sql2;
            if (this.lockModeEnabled) {
                sql2 = "SET LOCK MODE TO WAIT";
                if (this.lockWaitSeconds > 0) {
                    sql2 = sql2 + " " + this.lockWaitSeconds;
                }
                this.execute(sql2, conn, true);
            }
            sql2 = "SET ENVIRONMENT RETAINUPDATELOCKS 'ALL'";
            this.execute(sql2, conn, false);
        }
        if ("datadirect".equalsIgnoreCase(this.driverVendor)) {
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String sql2, Connection conn, boolean throwExc) {
        Statement stmnt = null;
        try {
            stmnt = conn.createStatement();
            stmnt.executeUpdate(sql2);
        }
        catch (SQLException se) {
            if (throwExc) {
                throw SQLExceptions.getStore(se, this);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace(_loc.get("can-not-execute", sql2));
            }
        }
        finally {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        throw new UnsupportedException(_loc.get("function-not-supported", this.getClass(), "LOCATE"));
    }

    public boolean needsToCreateIndex(Index idx, Table table) {
        PrimaryKey pk = table.getPrimaryKey();
        return pk == null || !idx.columnsMatch(pk.getColumns());
    }

    public boolean useJCC() {
        return this.useJCC;
    }

    public String getSchemaCase() {
        return this.schemaCase;
    }

    public boolean isFatalException(int subtype, SQLException ex) {
        if (subtype == 1 && ex.getErrorCode() == -154 || subtype == 6 && ex.getErrorCode() == -213) {
            return false;
        }
        return super.isFatalException(subtype, ex);
    }
}

