/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeEventProducer;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStartEndEventProducer
implements CorbaTypeEventProducer {
    protected int state;
    protected final int[] states = new int[]{1, 0, 2};
    protected CorbaTypeEventProducer currentEventProducer;
    protected QName name;
    protected Iterator<CorbaObjectHandler> iterator;
    protected Iterator<CorbaTypeEventProducer> producers;
    protected ServiceInfo serviceInfo;
    protected ORB orb;

    @Override
    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    @Override
    public QName getName() {
        QName ret = this.name;
        if (this.currentEventProducer != null) {
            ret = this.currentEventProducer.getName();
        }
        return ret;
    }

    @Override
    public String getText() {
        return this.currentEventProducer.getText();
    }

    @Override
    public boolean hasNext() {
        return this.state < this.states.length;
    }

    @Override
    public int next() {
        int event = this.states[this.state];
        if (event != 0) {
            ++this.state;
        } else if (this.currentEventProducer != null && this.currentEventProducer.hasNext()) {
            event = this.currentEventProducer.next();
        } else if (this.iterator != null && this.iterator.hasNext()) {
            CorbaObjectHandler obj = this.iterator.next();
            this.currentEventProducer = CorbaHandlerUtils.getTypeEventProducer(obj, this.serviceInfo, this.orb);
            event = this.currentEventProducer.next();
        } else if (this.producers != null && this.producers.hasNext()) {
            this.currentEventProducer = this.producers.next();
            event = this.currentEventProducer.next();
        } else {
            event = this.states[++this.state];
            ++this.state;
            this.currentEventProducer = null;
        }
        return event;
    }

    @Override
    public List<Attribute> getAttributes() {
        List<Attribute> attributes = null;
        if (this.currentEventProducer != null) {
            attributes = this.currentEventProducer.getAttributes();
        }
        return attributes;
    }

    @Override
    public List<Namespace> getNamespaces() {
        List<Namespace> namespaces = null;
        if (this.currentEventProducer != null) {
            namespaces = this.currentEventProducer.getNamespaces();
        }
        return namespaces;
    }

    protected Iterator<CorbaObjectHandler> getNestedTypes() {
        return this.iterator;
    }
}

