/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentCreateReply;
import fr.dyade.aaa.agent.AgentCreateRequest;
import fr.dyade.aaa.agent.AgentDeleteRequest;
import fr.dyade.aaa.agent.AgentException;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.DeleteAck;
import fr.dyade.aaa.agent.ExceptionNotification;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.LoadClassLock;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.objectweb.util.monolog.api.BasicLevel;

final class AgentFactory
extends Agent {
    private static final long serialVersionUID = 1L;

    AgentFactory(AgentId factoryId) {
        super("AgentFactory#" + AgentServer.getServerId(), true, factoryId);
    }

    protected String getLogTopic() {
        return "fr.dyade.aaa.agent.Agent.AgentFactory.#" + AgentServer.getServerId();
    }

    protected void agentInitialize(boolean firstTime) throws Exception {
        super.agentInitialize(firstTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void react(AgentId from, Notification not) throws Exception {
        block19: {
            if (not instanceof AgentCreateRequest) {
                AgentCreateRequest cnot = (AgentCreateRequest)not;
                try {
                    Agent ag;
                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(cnot.agentState, 0, cnot.agentState.length));
                    Object object = LoadClassLock.lock;
                    synchronized (object) {
                        ag = (Agent)ois.readObject();
                    }
                    try {
                        ois.close();
                    }
                    catch (IOException exc) {
                        // empty catch block
                    }
                    AgentServer.engine.createAgent(cnot.deploy, ag);
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)("AgentFactory" + this.id + ", create Agent" + ag.id + " [" + ag.name + "]"));
                    }
                    if (cnot.reply != null) {
                        AgentCreateReply reply = new AgentCreateReply(ag.getId());
                        reply.setContext(cnot.getContext());
                        this.sendTo(cnot.reply, (Notification)reply);
                    }
                }
                catch (Throwable error) {
                    cnot.agentState = null;
                    this.logmon.log(BasicLevel.ERROR, (Object)("AgentFactory" + this.id + ", can't create Agent" + cnot.deploy), error);
                    ExceptionNotification excNot = new ExceptionNotification(this.getId(), cnot, new AgentException(error));
                    excNot.setContext(cnot.getContext());
                    if (cnot.reply != null) {
                        this.sendTo(cnot.reply, (Notification)excNot);
                        break block19;
                    }
                    this.sendTo(from, (Notification)excNot);
                }
            } else {
                if (not instanceof AgentDeleteRequest) {
                    try {
                        AgentServer.engine.deleteAgent(from);
                        if (((AgentDeleteRequest)not).reply != null) {
                            this.sendTo(((AgentDeleteRequest)not).reply, (Notification)new DeleteAck(from, ((AgentDeleteRequest)not).extraInformation));
                        }
                        break block19;
                    }
                    catch (Exception exc) {
                        if (((AgentDeleteRequest)not).reply != null) {
                            this.sendTo(((AgentDeleteRequest)not).reply, (Notification)new DeleteAck(from, exc));
                        }
                        break block19;
                    }
                }
                try {
                    super.react(from, not);
                }
                catch (Exception exc) {
                    this.sendTo(from, (Notification)new ExceptionNotification(this.getId(), not, exc));
                }
            }
        }
    }
}

