/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageSoftRef;
import fr.dyade.aaa.common.Debug;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class MessageSoftList {
    private Logger logmon;
    private Message ack;
    private SortedSet msgToSendlist;
    private SortedSet msgSentlist;
    private final boolean persistent;

    public MessageSoftList(String name, boolean persistent) {
        this.logmon = Debug.getLogger(this.getClass().getName() + '.' + name);
        this.ack = null;
        if (persistent) {
            this.msgToSendlist = new TreeSet<MessageSoftRef>(new MessageSoftComparator());
            this.msgSentlist = new TreeSet<MessageSoftRef>(new MessageSoftComparator());
        } else {
            this.msgToSendlist = new TreeSet<Message>(new MessageComparator());
            this.msgSentlist = new TreeSet<Message>(new MessageComparator());
        }
        this.persistent = persistent;
    }

    public synchronized void addMessage(Message msg) {
        if (this.persistent) {
            this.msgToSendlist.add(new MessageSoftRef(msg));
        } else {
            this.msgToSendlist.add(msg);
        }
    }

    public synchronized Message getAck() {
        return this.ack;
    }

    public synchronized Message getFirst() {
        Message msg;
        while ((msg = this.selectFirst()) == null && this.msgToSendlist.size() > 0) {
        }
        return msg;
    }

    private Message selectFirst() {
        Message msg = null;
        if (this.persistent) {
            if (this.ack != null) {
                msg = this.ack;
                this.ack = null;
            } else if (this.msgToSendlist.size() > 0) {
                MessageSoftRef msgRef = (MessageSoftRef)this.msgToSendlist.first();
                msg = msgRef.getMessage();
                if (msg == null) {
                    msg = msgRef.loadMessage();
                }
                if (msg.not.expiration > 0L && msg.not.expiration < System.currentTimeMillis()) {
                    this.msgToSendlist.remove(msgRef);
                    this.removeExpired(msg);
                    msg = null;
                }
            }
        } else if (this.ack != null) {
            msg = this.ack;
            this.ack = null;
        } else if (this.msgToSendlist.size() > 0) {
            msg = (Message)this.msgToSendlist.first();
            if (msg.not.expiration > 0L && msg.not.expiration < System.currentTimeMillis()) {
                this.msgToSendlist.remove(msg);
                this.removeExpired(msg);
                msg = null;
            }
        }
        return msg;
    }

    private void removeExpired(Message msg) {
        block7: {
            try {
                AgentServer.getTransaction().begin();
                ExpiredNot expiredNot = null;
                if (msg.not.deadNotificationAgentId != null) {
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)("forward expired notification " + msg.from + ", " + msg.not + " to " + msg.not.deadNotificationAgentId));
                    }
                    expiredNot = new ExpiredNot(msg.not, msg.from, msg.to);
                } else if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)("removes expired notification " + msg.from + ", " + msg.not));
                }
                if (expiredNot != null) {
                    Channel.post(Message.alloc(AgentId.localId, msg.not.deadNotificationAgentId, expiredNot));
                    Channel.validate();
                }
                msg.delete();
                msg.free();
                AgentServer.getTransaction().commit(true);
            }
            catch (Exception exc) {
                if (!this.logmon.isLoggable(BasicLevel.WARN)) break block7;
                this.logmon.log(BasicLevel.WARN, (Object)("exception in removeExpired msg#" + msg.getStamp()), (Throwable)exc);
            }
        }
    }

    public synchronized void deleteMessagesUpTo(int stamp) throws IOException {
        if (this.persistent) {
            MessageSoftRef msgRef = null;
            Iterator iter = this.msgSentlist.iterator();
            int removedCount = 0;
            AgentServer.getTransaction().begin();
            while (iter.hasNext() && (msgRef = (MessageSoftRef)iter.next()).getStamp() <= stamp) {
                iter.remove();
                msgRef.delete();
                ++removedCount;
            }
            AgentServer.getTransaction().commit(true);
            if (removedCount == 0) {
                throw new NoSuchElementException();
            }
        } else {
            Message msg;
            Iterator iter = this.msgSentlist.iterator();
            while (iter.hasNext() && (msg = (Message)iter.next()).getStamp() <= stamp) {
                iter.remove();
            }
        }
    }

    public synchronized void setAck(Message ack) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(", set ack (" + ack + ')'));
        }
        this.ack = ack;
    }

    public Iterator toSendIterator() {
        if (this.persistent) {
            return new MessageSoftIterator(this.msgToSendlist.iterator());
        }
        return this.msgToSendlist.iterator();
    }

    public synchronized String toString() {
        if (this.persistent) {
            return "ack#" + (this.ack == null ? "undef" : String.valueOf(this.ack.stamp)) + " + " + Arrays.toString(this.msgSentlist.toArray()) + Arrays.toString(this.msgToSendlist.toArray());
        }
        return "ack#" + (this.ack == null ? "undef" : String.valueOf(this.ack.stamp)) + " + [size=" + this.msgSentlist.size() + "][size=" + this.msgToSendlist.size() + "]";
    }

    public synchronized void reset() {
        this.msgToSendlist.addAll(this.msgSentlist);
        this.msgSentlist.clear();
    }

    public synchronized int toSendSize() {
        return this.msgToSendlist.size() + (this.ack == null ? 0 : 1);
    }

    public synchronized void setSent(Message msg) {
        if (this.persistent) {
            MessageSoftRef msgRef = (MessageSoftRef)this.msgToSendlist.first();
            if (msgRef.getStamp() != msg.getStamp()) {
                throw new IllegalArgumentException("Send order not respected !");
            }
            this.msgToSendlist.remove(msgRef);
            this.msgSentlist.add(msgRef);
        } else {
            Message first = (Message)this.msgToSendlist.first();
            if (first.stamp != msg.stamp) {
                throw new IllegalArgumentException("Send order not respected !");
            }
            this.msgToSendlist.remove(first);
            this.msgSentlist.add(first);
        }
    }

    public synchronized int sentSize() {
        return this.msgSentlist.size();
    }

    private static class MessageSoftIterator
    implements Iterator {
        private Iterator iterator;

        public MessageSoftIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            MessageSoftRef msgRef = (MessageSoftRef)this.iterator.next();
            Message msg = msgRef.getMessage();
            if (msg == null) {
                msg = msgRef.loadMessage();
            }
            return msg;
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MessageSoftComparator
    implements Comparator<MessageSoftRef> {
        MessageSoftComparator() {
        }

        @Override
        public int compare(MessageSoftRef o1, MessageSoftRef o2) {
            return o1.getStamp() - o2.getStamp();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MessageComparator
    implements Comparator<Message> {
        MessageComparator() {
        }

        @Override
        public int compare(Message o1, Message o2) {
            return o1.getStamp() - o2.getStamp();
        }
    }
}

