/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.BufferedMessageInputStream;
import fr.dyade.aaa.agent.BufferedMessageOutputStream;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.JGroups;
import fr.dyade.aaa.agent.JGroupsAckMsg;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageSoftList;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.StreamNetwork;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.common.Daemon;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Iterator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class SimpleNetwork
extends StreamNetwork {
    MessageSoftList sendList;
    private JGroups jgroups = null;
    NetServerIn netServerIn = null;
    NetServerOut netServerOut = null;

    public void setJGroups(JGroups jgroups) {
        this.jgroups = jgroups;
    }

    void ackMsg(JGroupsAckMsg ack) {
        try {
            AgentServer.getTransaction().begin();
            this.qout.remove(ack.getStamp());
            ack.delete();
            AgentServer.getTransaction().commit(true);
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ackMsg(...) done."));
            }
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + ", ackMsg unrecoverable exception"), (Throwable)exc);
        }
    }

    public void start() throws IOException {
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", starting"));
        try {
            if (this.sendList == null) {
                this.sendList = new MessageSoftList(this.getName(), AgentServer.getTransaction().isPersistent());
            }
            if (this.netServerIn == null) {
                this.netServerIn = new NetServerIn(this.getName(), this.logmon);
            }
            if (this.netServerOut == null) {
                this.netServerOut = new NetServerOut(this.getName(), this.logmon);
            }
            if (!this.netServerIn.isRunning()) {
                this.netServerIn.start();
            }
            if (!this.netServerOut.isRunning()) {
                this.netServerOut.start();
            }
        }
        catch (IOException exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't start"), (Throwable)exc);
            throw exc;
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", started"));
    }

    public void stop() {
        if (this.netServerIn != null) {
            this.netServerIn.stop();
        }
        if (this.netServerOut != null) {
            this.netServerOut.stop();
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stopped"));
    }

    public boolean isRunning() {
        return this.netServerIn != null && this.netServerIn.isRunning() && this.netServerOut != null && this.netServerOut.isRunning();
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(super.toString()).append("\n\t");
        if (this.netServerIn != null) {
            strbuf.append(this.netServerIn.toString()).append("\n\t");
        }
        if (this.netServerOut != null) {
            strbuf.append(this.netServerOut.toString()).append("\n\t");
        }
        return strbuf.toString();
    }

    final class NetworkInputStream
    extends BufferedMessageInputStream {
        int boot;

        NetworkInputStream() {
        }

        protected void readHeader() throws IOException {
            this.readFully(29);
            this.boot = this.readInt();
        }

        Message readMessage(InputStream is) throws Exception {
            this.in = is;
            Message msg = this.readMessage();
            SimpleNetwork.this.testBootTS(msg.getSource(), this.boot);
            return msg;
        }
    }

    final class NetworkOutputStream
    extends BufferedMessageOutputStream {
        NetworkOutputStream() throws IOException {
        }

        protected void writeHeader() {
            this.writeInt(SimpleNetwork.this.getBootTS());
        }

        void writeMessage(OutputStream os, Message msg, long currentTimeMillis) throws IOException {
            this.out = os;
            this.writeMessage(msg, currentTimeMillis);
        }
    }

    final class NetServerIn
    extends Daemon {
        ServerSocket listen;

        NetServerIn(String name, Logger logmon) throws IOException {
            super(name + ".NetServerIn");
            this.listen = null;
            this.listen = SimpleNetwork.this.createServerSocket();
            this.logmon = logmon;
            this.setThreadGroup(AgentServer.getThreadGroup());
        }

        protected void close() {
            try {
                this.listen.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listen = null;
        }

        protected void shutdown() {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket socket = null;
            InputStream is = null;
            OutputStream os = null;
            try {
                if (this.listen == null) {
                    this.listen = SimpleNetwork.this.createServerSocket();
                }
                NetworkInputStream nis = new NetworkInputStream();
                while (this.running) {
                    try {
                        this.canStop = true;
                        try {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting connection"));
                            }
                            socket = this.listen.accept();
                        }
                        catch (IOException exc) {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", interrupted"));
                            }
                            nis.clean();
                            try {
                                if (os != null) {
                                    os.close();
                                }
                            }
                            catch (Exception exc2) {
                                // empty catch block
                            }
                            os = null;
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (Exception exc3) {
                                // empty catch block
                            }
                            is = null;
                            try {
                                if (socket != null) {
                                    socket.close();
                                }
                            }
                            catch (Exception exc4) {
                                // empty catch block
                            }
                            socket = null;
                            continue;
                        }
                        this.canStop = false;
                        SimpleNetwork.this.setSocketOption(socket);
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connected"));
                        }
                        os = socket.getOutputStream();
                        is = socket.getInputStream();
                        Message msg = nis.readMessage(is);
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", msg received"));
                        }
                        SimpleNetwork.this.deliver(msg);
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send ack"));
                        }
                        os.write(0);
                        os.flush();
                    }
                    catch (Exception exc) {
                        this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", closed"), (Throwable)exc);
                    }
                    finally {
                        nis.clean();
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (Exception exc) {}
                        os = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception exc) {}
                        is = null;
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (Exception exc) {}
                        socket = null;
                    }
                }
            }
            catch (IOException exc) {
                this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", bad socket initialization"), (Throwable)exc);
            }
            finally {
                this.finish();
            }
        }
    }

    final class NetServerOut
    extends Daemon {
        NetworkOutputStream nos;

        NetServerOut(String name, Logger logmon) {
            super(name + ".NetServerOut");
            this.nos = null;
            this.logmon = logmon;
            this.setThreadGroup(AgentServer.getThreadGroup());
        }

        protected void close() {
        }

        protected void shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Message msg = null;
            HashSet<ServerDesc> servers = new HashSet<ServerDesc>();
            try {
                try {
                    this.nos = new NetworkOutputStream();
                }
                catch (IOException exc) {
                    this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + ", cannot start."));
                    this.finish();
                    return;
                }
                while (this.running) {
                    this.canStop = true;
                    try {
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting message"));
                        }
                        msg = SimpleNetwork.this.qout.get(SimpleNetwork.this.WDActivationPeriod);
                    }
                    catch (InterruptedException exc) {
                        if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", interrupted"));
                        continue;
                    }
                    this.canStop = false;
                    if (!this.running) {
                        break;
                    }
                    if (msg != null) {
                        SimpleNetwork.this.sendList.addMessage(msg);
                        SimpleNetwork.this.qout.pop();
                    }
                    long currentTimeMillis = System.currentTimeMillis();
                    ServerDesc server = null;
                    Iterator iterator = SimpleNetwork.this.sendList.toSendIterator();
                    while (iterator.hasNext()) {
                        msg = (Message)iterator.next();
                        short msgto = msg.getDest();
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", check msg#" + msg.getStamp() + " from " + msg.from + " to " + msg.to));
                        }
                        if (msg.not.expiration > 0L && msg.not.expiration < currentTimeMillis) {
                            AgentServer.getTransaction().begin();
                            if (msg.not.deadNotificationAgentId != null) {
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": forward expired notification " + msg.from + ", " + msg.not + " to " + msg.not.deadNotificationAgentId));
                                }
                                ExpiredNot expiredNot = new ExpiredNot(msg.not, msg.from, msg.to);
                                Channel.post(Message.alloc(AgentId.localId, msg.not.deadNotificationAgentId, expiredNot));
                                Channel.validate();
                            } else if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": removes expired notification " + msg.from + ", " + msg.not));
                            }
                            iterator.remove();
                            msg.delete();
                            msg.free();
                            AgentServer.getTransaction().commit(true);
                            continue;
                        }
                        try {
                            server = AgentServer.getServerDesc(msgto);
                        }
                        catch (UnknownServerException exc) {
                            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't send message: " + msg), (Throwable)exc);
                            AgentServer.getTransaction().begin();
                            iterator.remove();
                            msg.delete();
                            msg.free();
                            AgentServer.getTransaction().commit(true);
                            continue;
                        }
                        if (servers.contains(server)) continue;
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + server.active + ',' + server.retry + ',' + server.last + ',' + currentTimeMillis));
                        if (server.active || server.retry < SimpleNetwork.this.WDNbRetryLevel1 && server.last + SimpleNetwork.this.WDRetryPeriod1 < currentTimeMillis || server.retry < SimpleNetwork.this.WDNbRetryLevel2 && server.last + SimpleNetwork.this.WDRetryPeriod2 < currentTimeMillis || server.last + SimpleNetwork.this.WDRetryPeriod3 < currentTimeMillis) {
                            try {
                                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send msg#" + msg.getStamp()));
                                }
                                Socket socket = SimpleNetwork.this.createSocket(server);
                                server.active = true;
                                server.retry = 0;
                                server.last = currentTimeMillis;
                                SimpleNetwork.this.setSocketOption(socket);
                                this.send(socket, msg, currentTimeMillis);
                            }
                            catch (SocketException exc) {
                                if (this.logmon.isLoggable(BasicLevel.WARN)) {
                                    this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", let msg in watchdog list"), (Throwable)exc);
                                }
                                server.active = false;
                                ++server.retry;
                                server.last = currentTimeMillis;
                                servers.add(server);
                                continue;
                            }
                            catch (Exception exc) {
                                this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error"), (Throwable)exc);
                            }
                            AgentServer.getTransaction().begin();
                            iterator.remove();
                            msg.delete();
                            msg.free();
                            AgentServer.getTransaction().commit(true);
                            continue;
                        }
                        servers.add(server);
                    }
                    servers.clear();
                }
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + ", unrecoverable exception"), (Throwable)exc);
                AgentServer.stop(false);
            }
            finally {
                this.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(Socket socket, Message msg, long currentTimeMillis) throws IOException {
            InputStream is = null;
            OutputStream os = null;
            try {
                os = socket.getOutputStream();
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", write message"));
                }
                this.nos.writeMessage(os, msg, currentTimeMillis);
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", wait ack"));
                }
                if ((is = socket.getInputStream()).read() == -1) {
                    throw new ConnectException("Connection broken");
                }
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", receive ack"));
                }
            }
            finally {
                try {
                    os.close();
                }
                catch (Exception exc) {}
                try {
                    is.close();
                }
                catch (Exception exc) {}
                try {
                    socket.close();
                }
                catch (Exception exc) {}
            }
        }
    }
}

