/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.impl;

import fr.dyade.aaa.jndi2.impl.ContextCache;
import fr.dyade.aaa.jndi2.impl.ContextRecord;
import fr.dyade.aaa.jndi2.impl.ContextTable;
import fr.dyade.aaa.jndi2.impl.MissingContextException;
import fr.dyade.aaa.jndi2.impl.MissingRecordException;
import fr.dyade.aaa.jndi2.impl.NamingContext;
import fr.dyade.aaa.jndi2.impl.NamingContextId;
import fr.dyade.aaa.jndi2.impl.NamingContextInfo;
import fr.dyade.aaa.jndi2.impl.Record;
import fr.dyade.aaa.jndi2.impl.SimpleContextTable;
import fr.dyade.aaa.jndi2.impl.StorageManager;
import fr.dyade.aaa.jndi2.impl.Trace;
import fr.dyade.aaa.util.NullTransaction;
import fr.dyade.aaa.util.Transaction;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.objectweb.util.monolog.api.BasicLevel;

public class ContextManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ContextTable contextIdTable;
    private ContextTable contextNameTable;
    private NamingContextId rootContextId;
    private StorageManager storageManager;

    public ContextManager(Transaction transaction, Object serverId, Object rootOwnerId) {
        if (transaction instanceof NullTransaction) {
            this.contextNameTable = new SimpleContextTable();
            this.contextIdTable = new SimpleContextTable();
        } else {
            this.contextNameTable = new ContextCache();
            this.contextIdTable = new ContextCache();
        }
        this.rootContextId = new NamingContextId(rootOwnerId, 0L);
        this.storageManager = new StorageManager(transaction, serverId);
    }

    public void initialize() throws Exception {
        this.storageManager.initialize();
        Enumeration names = this.storageManager.getContextNames();
        while (names.hasMoreElements()) {
            CompositeName name = (CompositeName)names.nextElement();
            this.registerMBean(this.getNamingContextFromName(name), name);
        }
    }

    private void put(NamingContext nc) {
        this.contextIdTable.put(nc.getId(), nc);
    }

    private void put(CompositeName name, NamingContext nc) {
        this.contextNameTable.put(name, nc);
    }

    public NamingContext getNamingContext(NamingContextId ncid) throws NamingException {
        return this.getNamingContext(ncid, true);
    }

    public NamingContext getNamingContext(NamingContextId ncid, boolean cache) throws NamingException {
        NamingContext nc;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ContextManager.getNamingContext(" + ncid + ',' + cache + ')'));
        }
        if ((nc = this.contextIdTable.get(ncid)) != null) {
            return nc;
        }
        nc = this.storageManager.loadNamingContext(ncid);
        if (cache && nc != null) {
            this.put(nc);
        }
        return nc;
    }

    private NamingContext getNamingContextFromName(CompositeName name) throws NamingException {
        NamingContext nc;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ContextManager.getNamingContextFromName(" + name + ')'));
        }
        if ((nc = this.contextNameTable.get(name)) != null) {
            return nc;
        }
        NamingContextId ncid = this.storageManager.getIdFromName(name);
        if (ncid != null) {
            nc = this.getNamingContext(ncid);
            if (nc == null) {
                throw new NamingException("Missing context: name=" + name + ", id=" + ncid);
            }
            this.put(name, nc);
            return nc;
        }
        return null;
    }

    public NamingContext getNamingContext(CompositeName name) throws NamingException {
        NamingContext nc;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ContextManager.getNamingContext(" + name + ')'));
        }
        if ((nc = this.getNamingContextFromName(name)) != null) {
            return nc;
        }
        CompositeName parentName = name;
        NamingContext parentNc = null;
        int unresolvedIndex = 0;
        for (int i = 0; i < name.size(); ++i) {
            parentName = (CompositeName)parentName.clone();
            parentName.remove(parentName.size() - 1);
            parentNc = this.getNamingContextFromName(parentName);
            if (parentNc == null) continue;
            unresolvedIndex = name.size() - 1 - i;
            break;
        }
        if (parentNc == null) {
            throw new MissingContextException(this.rootContextId, name);
        }
        String unresolvedName = name.get(unresolvedIndex);
        Record record = parentNc.getRecord(unresolvedName);
        if (record == null) {
            NameNotFoundException nnfe = new NameNotFoundException();
            CompositeName resolvedName = new CompositeName();
            for (int j = 0; j < unresolvedIndex; ++j) {
                resolvedName.add(name.get(j));
            }
            nnfe.setResolvedName(resolvedName);
            throw new MissingRecordException(parentNc.getId(), parentNc.getOwnerId(), nnfe);
        }
        if (record instanceof ContextRecord) {
            ContextRecord ctxRecord = (ContextRecord)record;
            throw new MissingContextException(ctxRecord.getId(), name);
        }
        throw new NotContextException();
    }

    public void delete(NamingContextId ncid, CompositeName name) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ContextManager.delete(" + ncid + ',' + name + ')'));
        }
        this.contextIdTable.remove(ncid);
        this.contextNameTable.remove(name);
        this.storageManager.delete(ncid, name);
        this.unregisterMBean(name);
    }

    public NamingContextInfo[] copyNamingContexts(Object serverId) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ContextManager.getNamingContexts(" + serverId + ')'));
        }
        Vector<NamingContextInfo> contexts = new Vector<NamingContextInfo>();
        Enumeration nameEnum = this.storageManager.getContextNames();
        Enumeration idEnum = this.storageManager.getContextIds();
        while (idEnum.hasMoreElements()) {
            NamingContextId ncid = (NamingContextId)idEnum.nextElement();
            CompositeName name = (CompositeName)nameEnum.nextElement();
            NamingContext nc = this.getNamingContext(ncid, false);
            if (!nc.getOwnerId().equals(serverId)) continue;
            NamingContext ncCopy = (NamingContext)nc.clone();
            contexts.addElement(new NamingContextInfo(ncCopy, name));
        }
        Object[] res = new NamingContextInfo[contexts.size()];
        contexts.copyInto(res);
        return res;
    }

    public NamingContext newNamingContext(Object ownerId, NamingContextId ncid, CompositeName name) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ContextManager.newNamingContext(" + ownerId + ',' + ncid + ',' + name + ')'));
        }
        NamingContext nc = this.storageManager.newNamingContext(ownerId, ncid, name);
        this.put(nc);
        this.put(name, nc);
        this.registerMBean(nc, name);
        return nc;
    }

    public void addNamingContext(NamingContextInfo ncInfo) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ContextManager.addNamingContext(" + ncInfo + ')'));
        }
        NamingContext nc = ncInfo.getNamingContext();
        CompositeName name = ncInfo.getCompositeName();
        this.storageManager.addNamingContext(nc, name);
        this.put(nc);
        this.put(name, nc);
    }

    public NamingContext getRootNamingContext() throws NamingException {
        return this.getNamingContext(this.rootContextId);
    }

    public void storeNamingContext(NamingContext nc) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("ContextManager.storeNamingContext(" + nc + ')'));
        }
        this.storageManager.storeNamingContext(nc);
    }

    public NamingContextInfo[] changeOwner(CompositeName cn, Object formerOwnerId, Object newOwnerId) throws NamingException {
        Vector<NamingContextInfo> updatedContexts = new Vector<NamingContextInfo>();
        Enumeration idEnum = this.storageManager.getContextIds();
        Enumeration nameEnum = this.storageManager.getContextNames();
        while (idEnum.hasMoreElements()) {
            NamingContextId ncid = (NamingContextId)idEnum.nextElement();
            CompositeName name = (CompositeName)nameEnum.nextElement();
            NamingContext nc = this.getNamingContext(ncid, false);
            if (!nc.getOwnerId().equals(formerOwnerId) || !name.equals(cn) && cn != null) continue;
            nc.setOwnerId(newOwnerId);
            this.storageManager.storeNamingContext(nc);
            updatedContexts.addElement(new NamingContextInfo(nc, name));
            this.reloadMBean(nc);
        }
        Object[] res = new NamingContextInfo[updatedContexts.size()];
        updatedContexts.copyInto(res);
        return res;
    }

    public void resetNamingContext(NamingContext context) throws NamingException {
        this.storageManager.storeNamingContext(context);
        this.reloadMBean(context);
    }

    private void registerMBean(NamingContext context, CompositeName cn) {
        try {
            MXWrapper.registerMBean(context, "JNDI", "nc=/" + cn);
        }
        catch (Exception exc) {
            Trace.logger.log(BasicLevel.WARN, (Object)(context + " jmx failed"), (Throwable)exc);
        }
    }

    private void unregisterMBean(CompositeName cn) {
        try {
            MXWrapper.unregisterMBean("JNDI", "nc=/" + cn);
        }
        catch (Exception exc) {
            Trace.logger.log(BasicLevel.WARN, (Object)"jmx failed", (Throwable)exc);
        }
    }

    private void reloadMBean(NamingContext context) {
        CompositeName cn = context.getContextName();
        if (cn.size() > 0) {
            this.unregisterMBean(cn);
            this.registerMBean(context, cn);
        }
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        out.writeObject(this.contextIdTable);
        out.writeObject(this.contextNameTable);
        this.storageManager.writeBag(out);
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.contextIdTable = (ContextTable)in.readObject();
        this.contextNameTable = (ContextTable)in.readObject();
        this.storageManager.readBag(in);
    }
}

