/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.soap;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.jndi2.soap.SoapObjectHelper;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JndiSoapService {
    public static final Logger logger = Debug.getLogger(JndiSoapService.class.getName());
    private Context ctx;

    public void init(String jndiHost, int jndiPort) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
        env.put("java.naming.factory.host", jndiHost);
        env.put("java.naming.factory.port", "" + jndiPort);
        this.ctx = new InitialContext(env);
    }

    public void bind(String name, Hashtable map) throws NamingException {
        this.ctx.bind(name, SoapObjectHelper.soapDecode(map));
    }

    public void rebind(String name, Hashtable map) throws NamingException {
        this.ctx.rebind(name, SoapObjectHelper.soapDecode(map));
    }

    public Hashtable lookup(String name) throws NamingException {
        try {
            return SoapObjectHelper.soapCode(this.ctx.lookup(name));
        }
        catch (Throwable exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", exc);
            }
            throw new NamingException(exc.toString());
        }
    }

    public void unbind(String name) throws NamingException {
        this.ctx.unbind(name);
    }
}

