/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.common.LoadClassLock;
import fr.dyade.aaa.util.Transaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public abstract class AbstractTransaction
implements Transaction {
    protected int phase;
    protected ThreadLocal perThreadContext = null;
    protected static final byte[] OOS_STREAM_HEADER = new byte[]{-84, -19, 0, 5};

    public final int getPhase() {
        return this.phase;
    }

    public final String getPhaseInfo() {
        return PhaseInfo[this.phase];
    }

    protected abstract void setPhase(int var1) throws IOException;

    public final synchronized void begin() throws IOException {
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(2);
    }

    public final void create(Serializable obj, String name) throws IOException {
        this.save(obj, null, name, true);
    }

    public final void create(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, dirName, name, true);
    }

    public final void save(Serializable obj, String name) throws IOException {
        this.save(obj, null, name, false);
    }

    public final void save(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, dirName, name, false);
    }

    public final void save(Serializable obj, String dirName, String name, boolean first) throws IOException {
        Context ctx = (Context)this.perThreadContext.get();
        if (ctx.oos == null) {
            ctx.bos.reset();
            ctx.oos = new ObjectOutputStream(ctx.bos);
        } else {
            ctx.oos.reset();
            ctx.bos.reset();
            ctx.bos.write(OOS_STREAM_HEADER, 0, 4);
        }
        ctx.oos.writeObject(obj);
        ctx.oos.flush();
        this.saveInLog(ctx.bos.toByteArray(), dirName, name, ctx.log, false, first);
    }

    public final void createByteArray(byte[] buf, String name) throws IOException {
        this.saveByteArray(buf, null, name, true, true);
    }

    public final void createByteArray(byte[] buf, String dirName, String name) throws IOException {
        this.saveByteArray(buf, dirName, name, true, true);
    }

    public final void saveByteArray(byte[] buf, String name) throws IOException {
        this.saveByteArray(buf, null, name, true, false);
    }

    public final void saveByteArray(byte[] buf, String dirName, String name) throws IOException {
        this.saveByteArray(buf, dirName, name, true, false);
    }

    public final void saveByteArray(byte[] buf, String dirName, String name, boolean copy, boolean first) throws IOException {
        this.saveInLog(buf, dirName, name, ((Context)this.perThreadContext.get()).log, copy, first);
    }

    protected abstract void saveInLog(byte[] var1, String var2, String var3, Hashtable var4, boolean var5, boolean var6) throws IOException;

    public final Object load(String name) throws IOException, ClassNotFoundException {
        return this.load(null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object load(String dirName, String name) throws IOException, ClassNotFoundException {
        byte[] buf = this.loadByteArray(dirName, name);
        if (buf != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bis);
            try {
                Object object = LoadClassLock.lock;
                synchronized (object) {
                    Object object2 = ois.readObject();
                    return object2;
                }
            }
            finally {
                ois.close();
                bis.close();
            }
        }
        return null;
    }

    public final byte[] loadByteArray(String name) throws IOException {
        return this.loadByteArray(null, name);
    }

    public final void delete(String name) {
        this.delete(null, name);
    }

    public synchronized void release() throws IOException {
        if (this.phase != 2 && this.phase != 3 && this.phase != 4) {
            throw new IllegalStateException("Can not release transaction.");
        }
        this.setPhase(1);
        this.notify();
    }

    protected class Context {
        Hashtable log = new Hashtable(15);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
        ObjectOutputStream oos = null;

        Context() {
        }
    }
}

