/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import java.net.ConnectException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.TopicMBean;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.shared.admin.GetSubscriberIds;
import org.objectweb.joram.shared.admin.GetSubscriberIdsRep;
import org.objectweb.joram.shared.admin.Monitor_GetCluster;
import org.objectweb.joram.shared.admin.Monitor_GetClusterRep;
import org.objectweb.joram.shared.admin.Monitor_GetFather;
import org.objectweb.joram.shared.admin.Monitor_GetFatherRep;
import org.objectweb.joram.shared.admin.Monitor_GetNumberRep;
import org.objectweb.joram.shared.admin.Monitor_GetSubscriptions;
import org.objectweb.joram.shared.admin.SetCluster;
import org.objectweb.joram.shared.admin.SetFather;
import org.objectweb.joram.shared.admin.UnsetCluster;
import org.objectweb.joram.shared.admin.UnsetFather;

public class Topic
extends Destination
implements javax.jms.Topic,
TopicMBean {
    private static final long serialVersionUID = 1L;

    public Topic() {
        super((byte)1);
    }

    public Topic(String id) {
        super(id, (byte)1);
    }

    protected Topic(String id, byte type) {
        super(id, type);
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Topic");
        if (this.adminName != null) {
            strbuf.append('[').append(this.adminName).append(']');
        }
        strbuf.append(':').append(this.agentId);
        return strbuf.toString();
    }

    public String getTopicName() throws JMSException {
        return this.getName();
    }

    public static Topic createTopic(String agentId, String name) {
        Topic dest = new Topic();
        dest.agentId = agentId;
        dest.adminName = name;
        return dest;
    }

    public static Topic create(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        Topic topic = new Topic();
        Topic.doCreate(serverId, name, className, prop, topic, (byte)1);
        return topic;
    }

    public static Topic create(int serverId, String className, Properties prop) throws ConnectException, AdminException {
        return Topic.create(serverId, null, className, prop);
    }

    public static Topic create(int serverId, Properties prop) throws ConnectException, AdminException {
        return Topic.create(serverId, "org.objectweb.joram.mom.dest.Topic", prop);
    }

    public static Topic create(int serverId, String name) throws ConnectException, AdminException {
        return Topic.create(serverId, name, "org.objectweb.joram.mom.dest.Topic", null);
    }

    public static Topic create(String name) throws ConnectException, AdminException {
        return Topic.create(AdminModule.getLocalServerId(), name, "org.objectweb.joram.mom.dest.Topic", null);
    }

    public static Topic create(int serverId) throws ConnectException, AdminException {
        return Topic.create(serverId, null, "org.objectweb.joram.mom.dest.Topic", null);
    }

    public static Topic create() throws ConnectException, AdminException {
        return Topic.create(AdminModule.getLocalServerId());
    }

    public Topic getHierarchicalFather() throws ConnectException, AdminException {
        Monitor_GetFather request = new Monitor_GetFather(this.agentId);
        Monitor_GetFatherRep reply = (Monitor_GetFatherRep)this.doRequest(request);
        if (reply.getFatherId() == null) {
            return null;
        }
        return new Topic(reply.getFatherId());
    }

    public List getClusterFellows() throws ConnectException, AdminException {
        Monitor_GetCluster request = new Monitor_GetCluster(this.agentId);
        Monitor_GetClusterRep reply = (Monitor_GetClusterRep)this.doRequest(request);
        Vector topics = reply.getTopics();
        Vector<Topic> list = new Vector<Topic>();
        for (int i = 0; i < topics.size(); ++i) {
            list.add(new Topic((String)topics.get(i)));
        }
        return list;
    }

    public int getSubscriptions() throws ConnectException, AdminException {
        Monitor_GetSubscriptions request = new Monitor_GetSubscriptions(this.agentId);
        Monitor_GetNumberRep reply = (Monitor_GetNumberRep)this.doRequest(request);
        return reply.getNumber();
    }

    public String[] getSubscriberIds() throws AdminException, ConnectException {
        GetSubscriberIdsRep reply = (GetSubscriberIdsRep)this.doRequest(new GetSubscriberIds(this.agentId));
        return reply.getSubscriberIds();
    }

    public void addClusteredTopic(Topic addedTopic) throws ConnectException, AdminException {
        this.doRequest(new SetCluster(this.agentId, addedTopic.getName()));
    }

    public void removeFromCluster() throws ConnectException, AdminException {
        this.doRequest(new UnsetCluster(this.agentId));
    }

    public void setParent(Topic parent) throws ConnectException, AdminException {
        if (parent == null) {
            this.unsetParent();
        } else {
            this.doRequest(new SetFather(parent.getName(), this.agentId));
        }
    }

    public void unsetParent() throws ConnectException, AdminException {
        this.doRequest(new UnsetFather(this.agentId));
    }
}

