/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.soap;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Timer;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.BeanSerializer;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.shared.client.AbstractJmsMessage;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CnxCloseReply;
import org.objectweb.joram.shared.client.CnxCloseRequest;
import org.objectweb.joram.shared.client.CnxConnectReply;
import org.objectweb.joram.shared.client.CnxConnectRequest;
import org.objectweb.joram.shared.client.CnxStartRequest;
import org.objectweb.joram.shared.client.CnxStopRequest;
import org.objectweb.joram.shared.client.ConsumerAckRequest;
import org.objectweb.joram.shared.client.ConsumerCloseSubRequest;
import org.objectweb.joram.shared.client.ConsumerDenyRequest;
import org.objectweb.joram.shared.client.ConsumerReceiveRequest;
import org.objectweb.joram.shared.client.ConsumerSetListRequest;
import org.objectweb.joram.shared.client.ConsumerSubRequest;
import org.objectweb.joram.shared.client.ConsumerUnsetListRequest;
import org.objectweb.joram.shared.client.ConsumerUnsubRequest;
import org.objectweb.joram.shared.client.GetAdminTopicReply;
import org.objectweb.joram.shared.client.GetAdminTopicRequest;
import org.objectweb.joram.shared.client.QBrowseRequest;
import org.objectweb.joram.shared.client.ServerReply;
import org.objectweb.joram.shared.client.SessAckRequest;
import org.objectweb.joram.shared.client.SessCreateTDReply;
import org.objectweb.joram.shared.client.SessCreateTQRequest;
import org.objectweb.joram.shared.client.SessCreateTTRequest;
import org.objectweb.joram.shared.client.SessDenyRequest;
import org.objectweb.joram.shared.client.TempDestDeleteRequest;
import org.objectweb.joram.shared.security.Identity;

public class SoapRequestChannel
implements RequestChannel {
    private Identity identity;
    private FactoryParameters factParams;
    private URL serviceUrl = null;
    private Call sendCall;
    private Call receiveCall;
    private int cnxId;
    private boolean closing = false;

    public SoapRequestChannel(FactoryParameters params, Identity identity) throws JMSException {
        this.factParams = params;
        this.identity = identity;
    }

    public void setTimer(Timer timer) {
    }

    public void connect() throws Exception {
        this.connect(this.factParams, this.identity);
        SOAPMappingRegistry mappingReg = new SOAPMappingRegistry();
        BeanSerializer beanSer = new BeanSerializer();
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "AbstractJmsRequest"), AbstractJmsRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "CnxConnectRequest"), CnxConnectRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "CnxStartRequest"), CnxStartRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "CnxStopRequest"), CnxStopRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "CnxCloseRequest"), CnxCloseRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "ConsumerAckRequest"), ConsumerAckRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "ConsumerDenyRequest"), ConsumerDenyRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "ConsumerReceiveRequest"), ConsumerReceiveRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "ConsumerSetListRequest"), ConsumerSetListRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "ConsumerUnsetListRequest"), ConsumerUnsetListRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "ConsumerSubRequest"), ConsumerSubRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "ConsumerUnsubRequest"), ConsumerUnsubRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "ConsumerCloseSubRequest"), ConsumerCloseSubRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "QBrowseRequest"), QBrowseRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "SessAckRequest"), SessAckRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "SessDenyRequest"), SessDenyRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "SessCreateTQRequest"), SessCreateTQRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "SessCreateTTRequest"), SessCreateTTRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "TempDestDeleteRequest"), TempDestDeleteRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "GetAdminTopicRequest"), GetAdminTopicRequest.class, (Serializer)beanSer, (Deserializer)beanSer);
        this.sendCall = new Call();
        this.sendCall.setSOAPMappingRegistry(mappingReg);
        this.sendCall.setTargetObjectURI("urn:ProxyService");
        this.sendCall.setMethodName("send");
        this.sendCall.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        mappingReg = new SOAPMappingRegistry();
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "AbstractJmsReply"), AbstractJmsReply.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "CnxConnectReply"), CnxConnectReply.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "ServerReply"), ServerReply.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "SessCreateTDReply"), SessCreateTDReply.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "CnxCloseReply"), CnxCloseReply.class, (Serializer)beanSer, (Deserializer)beanSer);
        mappingReg.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:ProxyService", "GetAdminTopicReply"), GetAdminTopicReply.class, (Serializer)beanSer, (Deserializer)beanSer);
        this.receiveCall = new Call();
        this.receiveCall.setSOAPMappingRegistry(mappingReg);
        this.receiveCall.setTargetObjectURI("urn:ProxyService");
        this.receiveCall.setMethodName("getReply");
        this.receiveCall.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
    }

    public synchronized void send(AbstractJmsRequest request) throws Exception {
        Hashtable h = request.soapCode();
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("name", String.class, (Object)this.identity.getUserName(), null));
        params.add(new Parameter("cnxId", Integer.class, (Object)new Integer(this.cnxId), null));
        params.add(new Parameter("map", Hashtable.class, (Object)h, null));
        this.sendCall.setParams(params);
        try {
            Response resp = this.sendCall.invoke(this.serviceUrl, "");
            if (resp.generatedFault()) {
                throw new IllegalStateException("The SOAP service failed to process the call: " + resp.getFault().getFaultString());
            }
        }
        catch (SOAPException exc) {
            throw new IllegalStateException("The SOAP call failed: " + exc.getMessage());
        }
    }

    public void close() {
    }

    private void connect(FactoryParameters factParams, Identity identity) throws JMSException {
        block14: {
            String error;
            Hashtable h;
            long startTime = System.currentTimeMillis();
            long endTime = startTime + (long)(factParams.connectingTimer * 1000);
            if (this.closing) {
                endTime = startTime;
            }
            long nextSleep = 2000L;
            int attemptsC = 0;
            try {
                this.serviceUrl = new URL("http://" + factParams.getHost() + ":" + factParams.getPort() + "/soap/servlet/rpcrouter");
            }
            catch (MalformedURLException exc) {
                // empty catch block
            }
            Call checkCall = new Call();
            checkCall.setTargetObjectURI("urn:ProxyService");
            checkCall.setMethodName("setConnection");
            checkCall.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
            Vector<Parameter> params = new Vector<Parameter>();
            try {
                h = identity.soapCode();
            }
            catch (IOException e) {
                throw new JMSException("EXCEPTION:: connect identity.soapCode(): " + e.getMessage());
            }
            params.add(new Parameter("identityMap", Hashtable.class, (Object)h, null));
            params.addElement(new Parameter("timeout", Integer.class, (Object)new Integer(factParams.cnxPendingTimer), null));
            checkCall.setParams(params);
            while (true) {
                boolean tryAgain;
                block13: {
                    tryAgain = false;
                    ++attemptsC;
                    error = null;
                    try {
                        Response resp = checkCall.invoke(this.serviceUrl, "");
                        if (resp.generatedFault()) {
                            error = resp.getFault().getFaultString();
                            tryAgain = true;
                            break block13;
                        }
                        Integer result = (Integer)resp.getReturnValue().getValue();
                        if (result == -1) {
                            throw new JMSSecurityException("Can't open the connection with the server on host " + factParams.getHost() + " and port " + factParams.getPort() + ": invalid user identification.");
                        }
                        this.cnxId = result;
                        break block14;
                    }
                    catch (SOAPException exc) {
                        tryAgain = true;
                        error = exc.getMessage();
                    }
                }
                if (!tryAgain) continue;
                long currentTime = System.currentTimeMillis();
                if (currentTime >= endTime) break;
                if (currentTime + nextSleep > endTime) {
                    nextSleep = endTime - currentTime;
                }
                try {
                    Thread.sleep(nextSleep);
                }
                catch (InterruptedException intExc) {
                    // empty catch block
                }
                nextSleep *= 2L;
            }
            long attemptsT = (System.currentTimeMillis() - startTime) / 1000L;
            throw new IllegalStateException("Could not open the connection with server on host " + factParams.getHost() + " and port " + factParams.getPort() + " after " + attemptsC + " attempts during " + attemptsT + " secs: " + error);
        }
    }

    public AbstractJmsReply receive() throws Exception {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("name", String.class, (Object)this.identity.getUserName(), null));
        params.addElement(new Parameter("cnxId", Integer.TYPE, (Object)new Integer(this.cnxId), null));
        this.receiveCall.setParams(params);
        Response resp = null;
        AbstractJmsReply reply = null;
        try {
            resp = this.receiveCall.invoke(this.serviceUrl, "");
        }
        catch (SOAPException exc) {
            throw new IOException("The SOAP call failed: " + exc.getMessage());
        }
        if (resp.generatedFault()) {
            throw new IOException("The SOAP service failed to process the call: " + resp.getFault().getFaultString());
        }
        try {
            Hashtable h = (Hashtable)resp.getReturnValue().getValue();
            reply = (AbstractJmsReply)AbstractJmsMessage.soapDecode(h);
        }
        catch (Exception exc) {
            throw new IOException(exc.getMessage());
        }
        return reply;
    }

    public void closing() {
        this.closing = true;
    }
}

