/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.agent.UnknownNotificationException;
import fr.dyade.aaa.agent.WakeUpTask;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.Properties;
import org.objectweb.joram.mom.dest.AdminDestinationItf;
import org.objectweb.joram.mom.dest.DestinationImpl;
import org.objectweb.joram.mom.notifications.AbstractRequest;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.DestinationAdminRequestNot;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.Monit_FreeAccess;
import org.objectweb.joram.mom.notifications.Monit_GetDMQSettings;
import org.objectweb.joram.mom.notifications.Monit_GetReaders;
import org.objectweb.joram.mom.notifications.Monit_GetStat;
import org.objectweb.joram.mom.notifications.Monit_GetWriters;
import org.objectweb.joram.mom.notifications.RequestGroupNot;
import org.objectweb.joram.mom.notifications.SetDMQRequest;
import org.objectweb.joram.mom.notifications.SetRightRequest;
import org.objectweb.joram.mom.notifications.SpecialAdminRequest;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class Destination
extends Agent
implements AdminDestinationItf {
    public static Logger logger = Debug.getLogger(Destination.class.getName());
    protected DestinationImpl destImpl;
    protected transient WakeUpTask task;

    public Destination() {
    }

    protected Destination(String name, boolean fixed, int stamp) {
        super(name, fixed, stamp);
    }

    public final void init(AgentId adminId, Properties props) {
        this.destImpl = this.createsImpl(adminId, props);
        this.destImpl.setAgent(this);
    }

    public abstract DestinationImpl createsImpl(AgentId var1, Properties var2);

    public abstract byte getType();

    protected void agentInitialize(boolean firstTime) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("agentInitialize(" + firstTime + ')'));
        }
        super.agentInitialize(firstTime);
        this.destImpl.setAgent(this);
        this.destImpl.initialize(firstTime);
        if (this.destImpl.getPeriod() > -1L) {
            this.task = new WakeUpTask(this.getId(), WakeUpNot.class, this.destImpl.getPeriod());
        }
        try {
            MXWrapper.registerMBean(this.destImpl, this.getMBeanName());
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)(this + " jmx failed"), (Throwable)exc);
        }
    }

    public void agentFinalize(boolean lastTime) {
        block3: {
            if (this.task != null) {
                this.task.cancel();
            }
            try {
                MXWrapper.unregisterMBean(this.getMBeanName());
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)"Destination.agentFinalize", (Throwable)exc);
            }
        }
        super.agentFinalize(lastTime);
    }

    public String getMBeanName() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Joram#").append(AgentServer.getServerId());
        strbuf.append(':');
        strbuf.append("type=Destination,name=").append(this.getName());
        return strbuf.toString();
    }

    public void react(AgentId from, Notification not) throws Exception {
        block22: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Destination.react(" + from + ',' + not + ')'));
            }
            this.setNoSave();
            try {
                if (not instanceof SetRightRequest) {
                    this.destImpl.setRightRequest(from, (SetRightRequest)not);
                    break block22;
                }
                if (not instanceof SetDMQRequest) {
                    this.destImpl.setDMQRequest(from, (SetDMQRequest)not);
                    break block22;
                }
                if (not instanceof Monit_GetReaders) {
                    this.destImpl.monitGetReaders(from, (Monit_GetReaders)not);
                    break block22;
                }
                if (not instanceof Monit_GetWriters) {
                    this.destImpl.monitGetWriters(from, (Monit_GetWriters)not);
                    break block22;
                }
                if (not instanceof Monit_FreeAccess) {
                    this.destImpl.monitFreeAccess(from, (Monit_FreeAccess)not);
                    break block22;
                }
                if (not instanceof Monit_GetDMQSettings) {
                    this.destImpl.monitGetDMQSettings(from, (Monit_GetDMQSettings)not);
                    break block22;
                }
                if (not instanceof Monit_GetStat) {
                    this.destImpl.monitGetStat(from, (Monit_GetStat)not);
                    break block22;
                }
                if (not instanceof SpecialAdminRequest) {
                    this.destImpl.specialAdminRequest(from, (SpecialAdminRequest)not);
                    break block22;
                }
                if (not instanceof ClientMessages) {
                    this.destImpl.clientMessages(from, (ClientMessages)not);
                    break block22;
                }
                if (not instanceof UnknownAgent) {
                    this.destImpl.unknownAgent(from, (UnknownAgent)not);
                    break block22;
                }
                if (not instanceof RequestGroupNot) {
                    this.destImpl.requestGroupNot(from, (RequestGroupNot)not);
                    break block22;
                }
                if (not instanceof DeleteNot) {
                    this.destImpl.deleteNot(from, (DeleteNot)not);
                    if (this.destImpl.canBeDeleted()) {
                        super.react(from, not);
                    }
                    break block22;
                }
                if (not instanceof WakeUpNot) {
                    this.setNoSave();
                    if (this.task == null || ((WakeUpNot)not).update) {
                        this.setPeriod(this.destImpl.getPeriod());
                    }
                    if (this.destImpl.getPeriod() > 0L) {
                        this.destImpl.wakeUpNot((WakeUpNot)not);
                    }
                    break block22;
                }
                if (not instanceof DestinationAdminRequestNot) {
                    this.destImpl.destinationAdminRequestNot(from, (DestinationAdminRequestNot)not);
                    break block22;
                }
                throw new UnknownNotificationException(not.getClass().getName());
            }
            catch (MomException exc) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)(this + ".react()"), (Throwable)exc);
                }
                AbstractRequest req = (AbstractRequest)not;
                Channel.sendTo(from, new ExceptionReply(req, exc));
            }
            catch (UnknownNotificationException exc) {
                super.react(from, not);
            }
        }
    }

    public void setPeriod(long period) {
        if (this.task == null) {
            this.task = new WakeUpTask(this.getId(), WakeUpNot.class, period);
        } else {
            this.task.cancel();
            if (period > 0L) {
                this.task = new WakeUpTask(this.getId(), WakeUpNot.class, period);
            }
        }
    }

    protected void setNoSave() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": setNoSave()."));
        }
        super.setNoSave();
    }

    protected void setSave() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": setSave()."));
        }
        super.setSave();
    }
}

