/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.common.Debug;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.objectweb.joram.mom.dest.DestinationImpl;
import org.objectweb.joram.mom.dest.QueueImplMBean;
import org.objectweb.joram.mom.messages.MessageJMXWrapper;
import org.objectweb.joram.mom.notifications.AbortReceiveRequest;
import org.objectweb.joram.mom.notifications.AcknowledgeRequest;
import org.objectweb.joram.mom.notifications.AdminRequest;
import org.objectweb.joram.mom.notifications.BrowseReply;
import org.objectweb.joram.mom.notifications.BrowseRequest;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.DenyRequest;
import org.objectweb.joram.mom.notifications.DestinationAdminRequestNot;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.Monit_GetDMQSettings;
import org.objectweb.joram.mom.notifications.Monit_GetDMQSettingsRep;
import org.objectweb.joram.mom.notifications.Monit_GetNbMaxMsg;
import org.objectweb.joram.mom.notifications.Monit_GetNbMaxMsgRep;
import org.objectweb.joram.mom.notifications.Monit_GetNumberRep;
import org.objectweb.joram.mom.notifications.Monit_GetPendingMessages;
import org.objectweb.joram.mom.notifications.Monit_GetPendingRequests;
import org.objectweb.joram.mom.notifications.QueueMsgReply;
import org.objectweb.joram.mom.notifications.ReceiveRequest;
import org.objectweb.joram.mom.notifications.SetNbMaxMsgRequest;
import org.objectweb.joram.mom.notifications.SetRightRequest;
import org.objectweb.joram.mom.notifications.SetThreshRequest;
import org.objectweb.joram.mom.notifications.TopicMsgsReply;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.ClearQueue;
import org.objectweb.joram.shared.admin.DeleteQueueMessage;
import org.objectweb.joram.shared.admin.GetQueueMessage;
import org.objectweb.joram.shared.admin.GetQueueMessageIds;
import org.objectweb.joram.shared.admin.GetQueueMessageIdsRep;
import org.objectweb.joram.shared.admin.GetQueueMessageRep;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.DestinationException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class QueueImpl
extends DestinationImpl
implements QueueImplMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger(QueueImpl.class.getName());
    static AgentId defaultDMQId = null;
    private Integer threshold = null;
    static Integer defaultThreshold = null;
    private boolean samePriorities;
    private int priority;
    protected Hashtable consumers = new Hashtable();
    protected Hashtable contexts = new Hashtable();
    protected long arrivalsCounter = 0L;
    protected Vector requests = new Vector();
    protected transient boolean receiving = false;
    protected transient Vector messages;
    protected transient Hashtable deliveredMsgs;
    protected int nbMaxMsg = -1;
    transient StringBuffer msgTxPrefix = null;
    transient int msgTxPrefixLength = 0;

    public int getThreshold() {
        if (this.threshold == null) {
            return -1;
        }
        return this.threshold;
    }

    public static Integer getDefaultThreshold() {
        return defaultThreshold;
    }

    public static AgentId getDefaultDMQId() {
        return defaultDMQId;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold < 0 ? null : new Integer(threshold);
    }

    public void cleanWaitingRequest() {
        this.cleanWaitingRequest(System.currentTimeMillis());
    }

    protected void cleanWaitingRequest(long currentTime) {
        int index = 0;
        while (index < this.requests.size()) {
            if (!((ReceiveRequest)this.requests.get(index)).isValid(currentTime)) {
                this.requests.remove(index);
                continue;
            }
            ++index;
        }
    }

    public int getWaitingRequestCount() {
        if (this.requests != null) {
            this.cleanWaitingRequest(System.currentTimeMillis());
            return this.requests.size();
        }
        return 0;
    }

    public void cleanPendingMessage() {
        this.cleanPendingMessage(System.currentTimeMillis());
    }

    protected DMQManager cleanPendingMessage(long currentTime) {
        int index = 0;
        DMQManager dmqManager = null;
        org.objectweb.joram.mom.messages.Message message = null;
        while (index < this.messages.size()) {
            message = (org.objectweb.joram.mom.messages.Message)this.messages.get(index);
            if (!message.isValid(currentTime)) {
                this.messages.remove(index);
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, this.getId());
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                message.delete();
                dmqManager.addDeadMessage(message.getFullMessage(), (short)0);
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Removes expired message " + message.getIdentifier()), (Throwable)new Exception());
                continue;
            }
            ++index;
        }
        return dmqManager;
    }

    public int getPendingMessageCount() {
        if (this.messages != null) {
            return this.messages.size();
        }
        return 0;
    }

    public int getDeliveredMessageCount() {
        if (this.deliveredMsgs != null) {
            return this.deliveredMsgs.size();
        }
        return 0;
    }

    public int getNbMaxMsg() {
        return this.nbMaxMsg;
    }

    public void setNbMaxMsg(int nbMaxMsg) {
        this.setSave();
        this.nbMaxMsg = nbMaxMsg;
    }

    public QueueImpl(AgentId adminId, Properties prop) {
        super(adminId, prop);
    }

    public void initialize(boolean firstTime) {
        this.cleanWaitingRequest(System.currentTimeMillis());
        this.receiving = false;
        this.messages = new Vector();
        this.deliveredMsgs = new Hashtable();
        if (firstTime) {
            return;
        }
        Vector persistedMsgs = null;
        persistedMsgs = org.objectweb.joram.mom.messages.Message.loadAll(this.getMsgTxPrefix().toString());
        if (persistedMsgs != null) {
            while (!persistedMsgs.isEmpty()) {
                org.objectweb.joram.mom.messages.Message persistedMsg = (org.objectweb.joram.mom.messages.Message)persistedMsgs.remove(0);
                AgentId consId = (AgentId)this.consumers.get(persistedMsg.getIdentifier());
                if (consId == null) {
                    if (this.addMessage(persistedMsg)) continue;
                    persistedMsg.delete();
                    continue;
                }
                if (this.isLocal(consId)) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)(" -> deny " + persistedMsg.getIdentifier()));
                    }
                    this.consumers.remove(persistedMsg.getIdentifier());
                    this.contexts.remove(persistedMsg.getIdentifier());
                    if (this.addMessage(persistedMsg)) continue;
                    persistedMsg.delete();
                    continue;
                }
                this.deliveredMsgs.put(persistedMsg.getIdentifier(), persistedMsg);
            }
        }
    }

    public String toString() {
        return "QueueImpl:" + this.getId().toString();
    }

    public void wakeUpNot(WakeUpNot not) {
        long current = System.currentTimeMillis();
        this.cleanWaitingRequest(current);
        DMQManager dmqManager = this.cleanPendingMessage(current);
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
    }

    public void setThreshRequest(AgentId from, SetThreshRequest req) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        this.setSave();
        this.threshold = req.getThreshold();
        this.strbuf.append("Request [").append(req.getClass().getName()).append("], sent to Queue [").append(this.getId());
        this.strbuf.append("], successful [true]: threshold [").append(this.threshold).append("] set");
        String info = this.strbuf.toString();
        this.strbuf.setLength(0);
        this.forward(from, new org.objectweb.joram.mom.notifications.AdminReply(req, true, info));
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)info);
        }
    }

    public void setNbMaxMsgRequest(AgentId from, SetNbMaxMsgRequest req) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        this.nbMaxMsg = req.getNbMaxMsg();
        this.strbuf.append("Request [").append(req.getClass().getName()).append("], sent to Queue [").append(this.getId());
        this.strbuf.append("], successful [true]: nbMaxMsg [").append(this.nbMaxMsg).append("] set").toString();
        String info = this.strbuf.toString();
        this.strbuf.setLength(0);
        this.forward(from, new org.objectweb.joram.mom.notifications.AdminReply(req, true, info));
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)info);
        }
    }

    public void monitGetDMQSettings(AgentId from, Monit_GetDMQSettings not) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        String id = null;
        if (this.dmqId != null) {
            id = this.dmqId.toString();
        }
        this.forward(from, new Monit_GetDMQSettingsRep((AdminRequest)not, id, this.threshold));
    }

    public void monitGetPendingMessages(AgentId from, Monit_GetPendingMessages not) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        DMQManager dmqManager = this.cleanPendingMessage(System.currentTimeMillis());
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        this.forward(from, new Monit_GetNumberRep(not, this.messages.size()));
    }

    public void monitGetPendingRequests(AgentId from, Monit_GetPendingRequests not) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        this.forward(from, new Monit_GetNumberRep(not, this.getWaitingRequestCount()));
    }

    public void monitGetNbMaxMsg(AgentId from, Monit_GetNbMaxMsg not) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        this.forward(from, new Monit_GetNbMaxMsgRep(not, this.nbMaxMsg));
    }

    protected boolean isValidJMXAttribute(String attrName) {
        if ("Messages".equals(attrName)) {
            return false;
        }
        return super.isValidJMXAttribute(attrName);
    }

    public void receiveRequest(AgentId from, ReceiveRequest not) throws AccessException {
        if (!this.isReader(from)) {
            throw new AccessException("READ right not granted");
        }
        String[] toAck = not.getMessageIds();
        if (toAck != null) {
            for (int i = 0; i < toAck.length; ++i) {
                this.acknowledge(toAck[i]);
            }
        }
        long current = System.currentTimeMillis();
        this.cleanWaitingRequest(current);
        not.requester = from;
        not.setExpiration(current);
        if (not.isPersistent()) {
            this.setSave();
        }
        this.requests.add(not);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> requests count = " + this.requests.size()));
        }
        int reqIndex = this.requests.size() - 1;
        this.deliverMessages(reqIndex);
        if (this.requests.size() - 1 == reqIndex && not.getTimeOut() == -1L) {
            this.requests.remove(reqIndex);
            QueueMsgReply reply = new QueueMsgReply(not);
            if (this.isLocal(from)) {
                reply.setPersistent(false);
            }
            this.forward(from, reply);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Receive answered by a null.");
            }
        }
    }

    public void browseRequest(AgentId from, BrowseRequest not) throws AccessException {
        if (!this.isReader(from)) {
            throw new AccessException("READ right not granted");
        }
        BrowseReply rep = new BrowseReply(not);
        DMQManager dmqManager = this.cleanPendingMessage(System.currentTimeMillis());
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.get(i);
            if (!Selector.matches(message.getHeaderMessage(), not.getSelector())) continue;
            rep.addMessage(message.getFullMessage());
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        this.forward(from, rep);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Request answered.");
        }
    }

    public void acknowledgeRequest(AgentId from, AcknowledgeRequest not) {
        Enumeration ids = not.getIds();
        while (ids.hasMoreElements()) {
            String msgId = (String)ids.nextElement();
            this.acknowledge(msgId);
        }
    }

    private void acknowledge(String msgId) {
        org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)this.deliveredMsgs.remove(msgId);
        if (msg != null && msg.isPersistent()) {
            this.setSave();
        }
        this.consumers.remove(msgId);
        this.contexts.remove(msgId);
        if (msg != null) {
            msg.delete();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message " + msgId + " acknowledged."));
            }
        } else if (logger.isLoggable(BasicLevel.WARN)) {
            logger.log(BasicLevel.WARN, (Object)("Message " + msgId + " not found for acknowledgement."));
        }
    }

    public void denyRequest(AgentId from, DenyRequest not) {
        org.objectweb.joram.mom.messages.Message message;
        String msgId;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("QueueImpl.DenyRequest(" + from + ',' + not + ')'));
        }
        Enumeration ids = not.getIds();
        DMQManager dmqManager = null;
        if (!ids.hasMoreElements()) {
            Enumeration delIds = this.deliveredMsgs.keys();
            while (delIds.hasMoreElements()) {
                msgId = (String)delIds.nextElement();
                message = (org.objectweb.joram.mom.messages.Message)this.deliveredMsgs.get(msgId);
                AgentId consId = (AgentId)this.consumers.get(msgId);
                int consCtx = (Integer)this.contexts.get(msgId);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> deny msg " + msgId + "(consId = " + consId + ')'));
                }
                if (!consId.equals(from) || consCtx != not.getClientContext()) continue;
                this.setSave();
                this.consumers.remove(msgId);
                this.contexts.remove(msgId);
                this.deliveredMsgs.remove(msgId);
                message.setRedelivered();
                if (this.isUndeliverable(message)) {
                    message.delete();
                    if (dmqManager == null) {
                        dmqManager = new DMQManager(this.dmqId, this.getId());
                    }
                    ++this.nbMsgsSentToDMQSinceCreation;
                    dmqManager.addDeadMessage(message.getFullMessage(), (short)2);
                } else {
                    this.storeMessageHeader(message);
                }
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Message " + msgId + " denied."));
            }
        }
        ids = not.getIds();
        while (ids.hasMoreElements()) {
            msgId = (String)ids.nextElement();
            message = (org.objectweb.joram.mom.messages.Message)this.deliveredMsgs.remove(msgId);
            if (message == null) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break;
                logger.log(BasicLevel.ERROR, (Object)(" -> already denied message " + msgId));
                break;
            }
            message.setRedelivered();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> deny " + msgId));
            }
            this.setSave();
            this.consumers.remove(msgId);
            this.contexts.remove(msgId);
            if (this.isUndeliverable(message)) {
                message.delete();
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, this.getId());
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)2);
            } else {
                this.storeMessageHeader(message);
            }
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)("Message " + msgId + " denied."));
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        this.deliverMessages(0);
    }

    public void abortReceiveRequest(AgentId from, AbortReceiveRequest not) {
        for (int i = 0; i < this.requests.size(); ++i) {
            ReceiveRequest request = (ReceiveRequest)this.requests.get(i);
            if (!request.requester.equals(from) || request.getClientContext() != not.getClientContext() || request.getRequestId() != not.getAbortedRequestId()) continue;
            if (not.isPersistent()) {
                this.setSave();
            }
            this.requests.remove(i);
            break;
        }
    }

    public void destinationAdminRequestNot(AgentId from, DestinationAdminRequestNot not) {
        org.objectweb.joram.shared.admin.AdminRequest adminRequest = not.getRequest();
        if (adminRequest instanceof GetQueueMessageIds) {
            this.getQueueMessageIds((GetQueueMessageIds)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetQueueMessage) {
            this.getQueueMessage((GetQueueMessage)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof DeleteQueueMessage) {
            this.deleteQueueMessage((DeleteQueueMessage)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof ClearQueue) {
            this.clearQueue((ClearQueue)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        }
    }

    private void getQueueMessageIds(GetQueueMessageIds request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        String[] res = new String[this.messages.size()];
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)this.messages.elementAt(i);
            res[i] = msg.getIdentifier();
        }
        this.replyToTopic(new GetQueueMessageIdsRep(res), replyTo, requestMsgId, replyMsgId);
    }

    private void getQueueMessage(GetQueueMessage request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        org.objectweb.joram.mom.messages.Message message = null;
        for (int i = 0; i < this.messages.size() && !(message = (org.objectweb.joram.mom.messages.Message)this.messages.elementAt(i)).getIdentifier().equals(request.getMessageId()); ++i) {
            message = null;
        }
        if (message != null) {
            GetQueueMessageRep reply = null;
            reply = request.getFullMessage() ? new GetQueueMessageRep(message.getFullMessage()) : new GetQueueMessageRep(message.getHeaderMessage());
            this.replyToTopic(reply, replyTo, requestMsgId, replyMsgId);
        } else {
            this.replyToTopic(new AdminReply(false, "Unknown message " + request.getMessageId()), replyTo, requestMsgId, replyMsgId);
        }
    }

    private void deleteQueueMessage(DeleteQueueMessage request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.elementAt(i);
            if (!message.getIdentifier().equals(request.getMessageId())) continue;
            this.messages.removeElementAt(i);
            message.delete();
            DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
            ++this.nbMsgsSentToDMQSinceCreation;
            dmqManager.addDeadMessage(message.getFullMessage(), (short)3);
            dmqManager.sendToDMQ();
            break;
        }
        this.replyToTopic(new AdminReply(true, null), replyTo, requestMsgId, replyMsgId);
    }

    private void clearQueue(ClearQueue request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        if (this.messages.size() > 0) {
            DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
            for (int i = 0; i < this.messages.size(); ++i) {
                org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.elementAt(i);
                message.delete();
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)3);
            }
            dmqManager.sendToDMQ();
            this.messages.clear();
        }
        this.replyToTopic(new AdminReply(true, null), replyTo, requestMsgId, replyMsgId);
    }

    protected void doRightRequest(SetRightRequest not) {
        if (not.getRight() != -READ) {
            return;
        }
        SetRightRequest rightRequest = this.preProcess(not);
        if (rightRequest != null) {
            AgentId user = rightRequest.getClient();
            if (user == null) {
                for (int i = 0; i < this.requests.size(); ++i) {
                    ReceiveRequest request = (ReceiveRequest)this.requests.get(i);
                    if (this.isReader(request.requester)) continue;
                    AccessException exc = new AccessException("Free READ access removed");
                    ExceptionReply reply = new ExceptionReply(request, exc);
                    this.forward(request.requester, reply);
                    this.setSave();
                    this.requests.remove(i);
                    --i;
                }
            } else {
                for (int i = 0; i < this.requests.size(); ++i) {
                    ReceiveRequest request = (ReceiveRequest)this.requests.get(i);
                    if (!user.equals(request.requester)) continue;
                    AccessException exc = new AccessException("READ right removed");
                    ExceptionReply reply = new ExceptionReply(request, exc);
                    this.forward(request.requester, reply);
                    this.setSave();
                    this.requests.remove(i);
                    --i;
                }
            }
            this.postProcess(rightRequest);
        }
    }

    protected void doClientMessages(AgentId from, ClientMessages not) {
        this.receiving = true;
        ClientMessages clientMsgs = this.preProcess(from, not);
        if (clientMsgs != null) {
            Enumeration msgs = clientMsgs.getMessages().elements();
            while (msgs.hasMoreElements()) {
                org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgs.nextElement());
                ++this.arrivalsCounter;
                msg.order = msg.order;
                this.storeMessage(msg);
                this.setSave();
            }
        }
        this.deliverMessages(0);
        if (clientMsgs != null) {
            this.postProcess(clientMsgs);
        }
        this.receiving = false;
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        AgentId client = uA.agent;
        Notification not = uA.not;
        if (!(not instanceof QueueMsgReply)) {
            return;
        }
        DMQManager dmqManager = null;
        Enumeration e = this.deliveredMsgs.keys();
        while (e.hasMoreElements()) {
            String msgId = (String)e.nextElement();
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.deliveredMsgs.get(msgId);
            AgentId consId = (AgentId)this.consumers.get(msgId);
            if (!consId.equals(client)) continue;
            this.deliveredMsgs.remove(msgId);
            message.setRedelivered();
            this.setSave();
            this.consumers.remove(msgId);
            this.contexts.remove(msgId);
            if (this.isUndeliverable(message)) {
                message.delete();
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, this.getId());
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)2);
            } else {
                this.storeMessageHeader(message);
            }
            if (!logger.isLoggable(BasicLevel.WARN)) continue;
            logger.log(BasicLevel.WARN, (Object)("Message " + message.getIdentifier() + " denied."));
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        this.deliverMessages(0);
    }

    protected void doDeleteNot(DeleteNot not) {
        DestinationException exc = new DestinationException("Queue " + this.getId() + " is deleted.");
        this.cleanWaitingRequest(System.currentTimeMillis());
        for (int i = 0; i < this.requests.size(); ++i) {
            ReceiveRequest rec = (ReceiveRequest)this.requests.elementAt(i);
            ExceptionReply excRep = new ExceptionReply(rec, exc);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Requester " + rec.requester + " notified of the queue deletion."));
            }
            this.forward(rec.requester, excRep);
        }
        if (!this.messages.isEmpty()) {
            DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
            while (!this.messages.isEmpty()) {
                org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.remove(0);
                message.delete();
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)4);
            }
            dmqManager.sendToDMQ();
        }
        org.objectweb.joram.mom.messages.Message.deleteAll(this.getMsgTxPrefix().toString());
    }

    protected final StringBuffer getMsgTxPrefix() {
        if (this.msgTxPrefix == null) {
            this.msgTxPrefix = new StringBuffer(18).append('M').append(this.getId().toString()).append('_');
            this.msgTxPrefixLength = this.msgTxPrefix.length();
        }
        return this.msgTxPrefix;
    }

    protected final void setMsgTxName(org.objectweb.joram.mom.messages.Message msg) {
        if (msg.getTxName() == null) {
            msg.setTxName(this.getMsgTxPrefix().append(msg.order).toString());
            this.msgTxPrefix.setLength(this.msgTxPrefixLength);
        }
    }

    protected final synchronized void storeMessage(org.objectweb.joram.mom.messages.Message message) {
        if (this.addMessage(message)) {
            this.setMsgTxName(message);
            message.save();
            message.releaseFullMessage();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message " + message.getIdentifier() + " stored."));
            }
        }
    }

    protected final synchronized void storeMessageHeader(org.objectweb.joram.mom.messages.Message message) {
        if (this.addMessage(message)) {
            message.saveHeader();
            message.releaseFullMessage();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message " + message.getIdentifier() + " stored."));
            }
        }
    }

    protected final synchronized boolean addMessage(org.objectweb.joram.mom.messages.Message message) {
        if (this.nbMaxMsg > -1 && this.nbMaxMsg <= this.messages.size()) {
            DMQManager dmqManager = new DMQManager(this.dmqId, this.getId());
            ++this.nbMsgsSentToDMQSinceCreation;
            dmqManager.addDeadMessage(message.getFullMessage(), (short)5);
            dmqManager.sendToDMQ();
            return false;
        }
        if (this.messages.isEmpty()) {
            this.samePriorities = true;
            this.priority = message.getPriority();
        } else if (this.samePriorities && this.priority != message.getPriority()) {
            this.samePriorities = false;
        }
        if (this.samePriorities) {
            if (this.receiving) {
                this.messages.add(message);
            } else {
                long currentO;
                int i = 0;
                Enumeration e = this.messages.elements();
                while (e.hasMoreElements() && (currentO = ((org.objectweb.joram.mom.messages.Message)e.nextElement()).order) <= message.order) {
                    ++i;
                }
                this.messages.insertElementAt(message, i);
            }
        } else {
            int i = 0;
            Enumeration e = this.messages.elements();
            while (e.hasMoreElements()) {
                org.objectweb.joram.mom.messages.Message currentMsg = (org.objectweb.joram.mom.messages.Message)e.nextElement();
                int currentP = currentMsg.getPriority();
                long currentO = currentMsg.order;
                if (!this.receiving && currentP == message.getPriority() ? currentO > message.order : currentP < message.getPriority()) break;
                ++i;
            }
            this.messages.insertElementAt(message, i);
        }
        return true;
    }

    protected ClientMessages getClientMessages(int nb, String selector, boolean remove) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("QueueImpl.getClientMessages(" + nb + ',' + selector + ',' + remove + ')'));
        }
        ClientMessages cm = null;
        List lsMessages = this.getMessages(nb, selector, remove);
        if (lsMessages.size() > 0) {
            cm = new ClientMessages();
        }
        org.objectweb.joram.mom.messages.Message message2 = null;
        for (org.objectweb.joram.mom.messages.Message message2 : lsMessages) {
            cm.addMessage(message2.getFullMessage());
        }
        return cm;
    }

    private List getMessages(int nb, String selector, boolean remove) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("QueueImpl.getMessages(" + nb + ',' + selector + ',' + remove + ')'));
        }
        ArrayList<org.objectweb.joram.mom.messages.Message> lsMessages = new ArrayList<org.objectweb.joram.mom.messages.Message>();
        int j = 0;
        while ((lsMessages.size() < nb || nb == -1) && j < this.messages.size()) {
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.get(j);
            if (Selector.matches(message.getHeaderMessage(), selector) && this.checkDelivery(message.getHeaderMessage())) {
                message.incDeliveryCount();
                ++this.nbMsgsDeliverSinceCreation;
                this.messageDelivered(message.getIdentifier());
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Message " + message.getIdentifier()));
                }
                lsMessages.add(message);
                if (remove) {
                    this.messages.remove(message);
                    message.delete();
                    continue;
                }
                ++j;
                continue;
            }
            ++j;
        }
        return lsMessages;
    }

    private org.objectweb.joram.mom.messages.Message getMomMessage(String msgId) {
        org.objectweb.joram.mom.messages.Message msg = null;
        Enumeration e = this.messages.elements();
        while (e.hasMoreElements()) {
            msg = (org.objectweb.joram.mom.messages.Message)e.nextElement();
            if (!msgId.equals(msg.getIdentifier())) continue;
            return msg;
        }
        return msg;
    }

    protected org.objectweb.joram.mom.messages.Message getQueueMessage(String msgId, boolean remove) {
        org.objectweb.joram.mom.messages.Message message;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("QueueImpl.getMessage(" + msgId + ',' + remove + ')'));
        }
        if (this.checkDelivery((message = this.getMomMessage(msgId)).getHeaderMessage())) {
            message.incDeliveryCount();
            ++this.nbMsgsDeliverSinceCreation;
            this.messageDelivered(message.getIdentifier());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message " + msgId));
            }
            if (remove) {
                this.messages.remove(message);
                message.delete();
            }
        }
        return message;
    }

    public CompositeData getMessage(String msgId) throws Exception {
        org.objectweb.joram.mom.messages.Message msg = this.getQueueMessage(msgId, false);
        if (msg == null) {
            return null;
        }
        return MessageJMXWrapper.createCompositeDataSupport(msg);
    }

    public TabularData getMessages() throws Exception {
        return MessageJMXWrapper.createTabularDataSupport(this.messages);
    }

    protected void deliverMessages(int index) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("QueueImpl.deliverMessages(" + index + ')'));
        }
        ReceiveRequest notRec = null;
        List lsMessages = null;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> requests = " + this.requests + ')'));
        }
        long current = System.currentTimeMillis();
        this.cleanWaitingRequest(current);
        DMQManager dmqManager = this.cleanPendingMessage(current);
        while (!this.messages.isEmpty() && index < this.requests.size()) {
            notRec = (ReceiveRequest)this.requests.get(index);
            QueueMsgReply notMsg = new QueueMsgReply(notRec);
            lsMessages = this.getMessages(notRec.getMessageCount(), notRec.getSelector(), notRec.getAutoAck());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("QueueImpl.deliverMessages: notRec.getAutoAck() = " + notRec.getAutoAck() + ", lsMessages = " + lsMessages));
            }
            for (org.objectweb.joram.mom.messages.Message message : lsMessages) {
                notMsg.addMessage(message.getFullMessage());
                if (!notRec.getAutoAck()) {
                    this.consumers.put(message.getIdentifier(), notRec.requester);
                    this.contexts.put(message.getIdentifier(), new Integer(notRec.getClientContext()));
                    this.deliveredMsgs.put(message.getIdentifier(), message);
                    this.messages.remove(message);
                }
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Message " + message.getIdentifier() + " to " + notRec.requester + " as reply to " + notRec.getRequestId()));
            }
            if (this.isLocal(notRec.requester)) {
                notMsg.setPersistent(false);
            }
            if (notMsg.isPersistent() && !notRec.getAutoAck()) {
                this.setSave();
            }
            if (notMsg.getSize() > 0) {
                this.requests.remove(index);
                this.forward(notRec.requester, notMsg);
                continue;
            }
            ++index;
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
    }

    protected boolean checkDelivery(Message msg) {
        return true;
    }

    protected void messageDelivered(String msgId) {
    }

    protected void messageRemoved(String msgId) {
    }

    protected boolean isUndeliverable(org.objectweb.joram.mom.messages.Message message) {
        if (this.threshold != null) {
            return message.getDeliveryCount() >= this.threshold;
        }
        if (defaultThreshold != null) {
            return message.getDeliveryCount() >= defaultThreshold;
        }
        return false;
    }

    public void addClientMessages(ClientMessages clientMsgs) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.storeClientMessage(" + clientMsgs + ')'));
        }
        if (clientMsgs != null) {
            Enumeration msgs = clientMsgs.getMessages().elements();
            while (msgs.hasMoreElements()) {
                org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgs.nextElement());
                ++this.arrivalsCounter;
                msg.order = msg.order;
                this.storeMessage(msg);
            }
        }
        this.deliverMessages(0);
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.receiving = in.readBoolean();
        this.messages = (Vector)in.readObject();
        this.deliveredMsgs = (Hashtable)in.readObject();
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messages.elementAt(i);
            this.setMsgTxName(message);
            message.save();
        }
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.receiving);
        out.writeObject(this.messages);
        out.writeObject(this.deliveredMsgs);
    }

    public long getNbMsgsReceiveSinceCreation() {
        return this.nbMsgsSentToDMQSinceCreation + this.nbMsgsDeliverSinceCreation + (long)this.getPendingMessageCount();
    }

    protected void handleExpiredNot(AgentId from, ExpiredNot not) {
        Vector messages;
        Notification expiredNot = not.getExpiredNot();
        if (expiredNot instanceof ClientMessages) {
            messages = ((ClientMessages)expiredNot).getMessages();
        } else if (expiredNot instanceof TopicMsgsReply) {
            messages = ((TopicMsgsReply)expiredNot).getMessages();
        } else {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("Expired notification holds an unknown notification: " + expiredNot.getClass().getName()));
            }
            return;
        }
        DMQManager dmqManager = new DMQManager(this.getId(), null);
        Iterator iterator = messages.iterator();
        while (iterator.hasNext()) {
            dmqManager.addDeadMessage((Message)iterator.next(), (short)0);
        }
        dmqManager.sendToDMQ();
    }
}

