/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.internal.utils;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.ow2.jonas.discovery.base.DiscHelper;
import org.ow2.jonas.discovery.base.comm.DiscMessage;

public class DiscoveryHelper
extends DiscHelper {
    private static int DISC_GREETING = 2;
    private static int RECEIVE_BUFFER_SIZE = 1024;

    private void sendDiscoveryMessage(DiscMessage msg, DatagramSocket socket, InetAddress destAddress, int destPort) throws IOException {
        byte[] messageBytes = DiscoveryHelper.objectToBytes((Object)msg);
        DatagramPacket packet = new DatagramPacket(messageBytes, messageBytes.length, destAddress, destPort);
        this.sendPacket(socket, packet);
    }

    private DiscMessage receiveDiscoveryMessage(DatagramSocket socket) throws IOException, ClassNotFoundException, RuntimeException {
        DatagramPacket packet = new DatagramPacket(new byte[RECEIVE_BUFFER_SIZE], RECEIVE_BUFFER_SIZE);
        this.receivePacket(socket, packet);
        Object ret = null;
        try {
            ret = DiscoveryHelper.bytesToObject((byte[])packet.getData());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("The host has received other packet than DatagramSocket packet. That caused following exception: " + e);
        }
        catch (IOException e) {
            throw new IOException(" The host has received other packet than DatagramSocket packet. That caused following exception: " + e);
        }
        return (DiscMessage)ret;
    }

    private void sendPacket(DatagramSocket socket, DatagramPacket packet) throws IOException {
        socket.send(packet);
    }

    private void receivePacket(DatagramSocket socket, DatagramPacket packet) throws IOException {
        socket.receive(packet);
    }
}

