/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.lib;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.objectweb.jorm.api.JormConfigurator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.lib.Mapper;
import org.objectweb.jorm.mapper.rdb.adapter.RdbAdapterFactory;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;
import org.objectweb.jorm.mapper.rdb.lib.ConnectionSpecJDBC;
import org.objectweb.jorm.mapper.rdb.lib.PMapperRdb;

public class MapperJDBC
extends Mapper
implements PMapperRdb {
    private DataSource source = null;
    private RdbAdapter adapter;

    public MapperJDBC() throws PException {
    }

    public MapperJDBC(JormConfigurator jc) {
        super(jc);
    }

    public void closeConnection(Object conn) throws PException {
        try {
            ((Connection)conn).close();
        }
        catch (SQLException se) {
            throw new PException(se, "Problem while closing connection.");
        }
    }

    public Object getConnection() throws PException {
        if (this.source == null) {
            throw new PException("Cannot get an SQL connection: no datasource specified.");
        }
        try {
            return this.source.getConnection();
        }
        catch (SQLException se) {
            throw new PException(se, "Problem while allocating connection.");
        }
    }

    public Object getConnection(Object ctxt) throws PException {
        if (!(ctxt instanceof ConnectionSpecJDBC)) {
            throw new PException("Requires a JDBC connection specification.");
        }
        ConnectionSpecJDBC cs = (ConnectionSpecJDBC)ctxt;
        try {
            if (cs.user != null && cs.passwd != null) {
                return this.source.getConnection(cs.user, cs.passwd);
            }
            return this.source.getConnection();
        }
        catch (SQLException se) {
            throw new PException(se, "Problem while allocating connection with SPEC.");
        }
    }

    public Object getConnection(Object connectionContext, Object user) throws PException {
        return this.getConnection(connectionContext);
    }

    public void setConnectionFactory(Object cf) throws PException {
        if (cf == null) {
            return;
        }
        if (cf instanceof DataSource) {
            this.source = (DataSource)cf;
            return;
        }
        throw new PException("Requires a JDBC connection specification.");
    }

    public Object getConnectionFactory() {
        return this.source;
    }

    public void start() throws PException {
        String mn = this.getMapperName();
        if (mn == null || "rdb.automatic".equalsIgnoreCase(mn)) {
            try {
                this.adapter = RdbAdapterFactory.getTypeConverter(this.source);
            }
            catch (RdbAdapterException e) {
                throw new PException(e, "Impossible to find a RdbAdapter in automatic mode");
            }
            this.setMapperName("rdb." + this.adapter.getName());
        } else {
            int idx = mn.indexOf(46);
            mn = idx == -1 ? "jdbc" : mn.substring(idx + 1);
            try {
                this.adapter = RdbAdapterFactory.getTypeConverter(mn);
            }
            catch (RdbAdapterException e) {
                throw new PException(e, "Impossible to find a RdbAdapter for the specified mapper name: " + this.getMapperName());
            }
        }
        this.adapter.setLogger(this.logger);
        super.start();
    }

    public RdbAdapter getRdbAdapter() {
        return this.adapter;
    }
}

