/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.QueryNodeException;
import org.objectweb.medor.eval.api.EvaluationMetaData;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.eval.cache.lib.TupleCache;
import org.objectweb.medor.eval.cache.lib.WindowCachedTupleCollection;
import org.objectweb.medor.eval.lib.NestEvaluatedTC;
import org.objectweb.medor.eval.lib.ProjectEvaluatedTC;
import org.objectweb.medor.eval.lib.SelProjEvaluatedTC;
import org.objectweb.medor.eval.lib.UnnestEvaluatedTC;
import org.objectweb.medor.eval.prefetch.api.PrefetchBuffer;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.query.api.NestQueryNode;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.UnnestQueryNode;
import org.objectweb.medor.tuple.api.TupleCollection;

public class UnaryIteratifNodeEvaluator
implements NodeEvaluator {
    QueryNode query;
    NodeEvaluator subNodeEvaluator;
    long cacheSize;
    boolean open = false;
    PrefetchBuffer prefetchBuffer;
    EvaluationMetaData evaluationMetaData;

    public UnaryIteratifNodeEvaluator(QueryNode query, NodeEvaluator subNodeEvaluator, EvaluationMetaData evaluationMetaData) {
        this.query = query;
        this.subNodeEvaluator = subNodeEvaluator;
        this.evaluationMetaData = evaluationMetaData;
    }

    public boolean linkChildren() {
        this.open = true;
        return true;
    }

    public boolean unlinkChildren() {
        this.open = false;
        return true;
    }

    public TupleCollection fetchData(ParameterOperand[] parameters) throws MedorException {
        TupleCollection res = null;
        switch (this.query.getType()) {
            case 4: {
                res = new NestEvaluatedTC((NestQueryNode)this.query, this.subNodeEvaluator, parameters, this.evaluationMetaData);
                break;
            }
            case 5: {
                res = new ProjectEvaluatedTC(this.query, this.subNodeEvaluator, parameters, this.prefetchBuffer);
                break;
            }
            case 6: {
                if (this.query.getQueryFilter() == null) {
                    res = new ProjectEvaluatedTC(this.query, this.subNodeEvaluator, parameters, this.prefetchBuffer);
                    break;
                }
                res = new SelProjEvaluatedTC(this.query, this.subNodeEvaluator, parameters, this.prefetchBuffer);
                break;
            }
            case 8: {
                res = new UnnestEvaluatedTC((UnnestQueryNode)this.query, this.subNodeEvaluator, parameters);
                break;
            }
            default: {
                throw new QueryNodeException("Unreconized QueryNode: " + this.query);
            }
        }
        if (this.evaluationMetaData == null) {
            return res;
        }
        if (this.evaluationMetaData.isCache()) {
            return new WindowCachedTupleCollection(res, new TupleCache(this.cacheSize));
        }
        return res;
    }

    public void setPrefetchBuffer(PrefetchBuffer pb) throws MedorException {
        this.prefetchBuffer = pb;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public QueryNode getQueryNode() {
        return this.query;
    }

    public EvaluationMetaData getEvaluationMetaData() {
        return this.evaluationMetaData;
    }
}

