/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import org.apache.openjpa.lib.util.Localizer;

public class CompileTimeLogger {
    private static Localizer _loc = Localizer.forPackage(CompileTimeLogger.class);
    private static Level DEFAULT_LEVEL = Level.WARN;
    private int logLevel;
    private Messager messager;

    public CompileTimeLogger(ProcessingEnvironment env, String level) {
        this.messager = env.getMessager();
        if (level == null) {
            this.logLevel = DEFAULT_LEVEL.ordinal();
            return;
        }
        if ("trace".equalsIgnoreCase(level)) {
            this.logLevel = Level.TRACE.ordinal();
        } else if ("info".equalsIgnoreCase(level)) {
            this.logLevel = Level.INFO.ordinal();
        } else if ("warn".equalsIgnoreCase(level)) {
            this.logLevel = Level.WARN.ordinal();
        } else if ("error".equalsIgnoreCase(level)) {
            this.logLevel = Level.ERROR.ordinal();
        } else {
            this.logLevel = DEFAULT_LEVEL.ordinal();
            this.warn(_loc.get("mmg-bad-log", level, (Object)DEFAULT_LEVEL));
        }
    }

    public void info(Localizer.Message message) {
        this.log(Level.INFO, message, Diagnostic.Kind.NOTE);
    }

    public void trace(Localizer.Message message) {
        this.log(Level.TRACE, message, Diagnostic.Kind.NOTE);
    }

    public void warn(Localizer.Message message) {
        this.log(Level.WARN, message, Diagnostic.Kind.MANDATORY_WARNING);
    }

    public void error(Localizer.Message message) {
        this.error(message, null);
    }

    public void error(Localizer.Message message, Throwable t) {
        this.log(Level.ERROR, message, Diagnostic.Kind.ERROR);
        if (t != null) {
            t.printStackTrace();
        }
    }

    private void log(Level level, Localizer.Message message, Diagnostic.Kind kind) {
        if (this.logLevel <= level.ordinal()) {
            this.messager.printMessage(kind, message.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Level {
        TRACE,
        INFO,
        WARN,
        ERROR;

    }
}

