/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.scheduler;

import com.scalagent.scheduler.ScheduleEvent;
import com.scalagent.scheduler.ScheduleItem;
import com.scalagent.scheduler.ScheduleTask;
import fr.dyade.aaa.agent.Debug;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Scheduler
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static Logger logger = Debug.getLogger(Scheduler.class.getName());
    private transient ScheduleItem items = null;
    private transient Timer timer;
    private transient WakeUp wakeUp;

    public Scheduler(Timer timer) throws IOException {
        this.timer = timer;
    }

    public void restart(Timer timer) throws Exception {
        if (this.timer != null) {
            this.cancel();
        }
        this.timer = timer;
        this.checkItems();
    }

    public String toString() {
        return "Scheduler (items=" + this.items + ")";
    }

    public void scheduleEvent(ScheduleEvent event, ScheduleTask task) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Scheduler.scheduleEvent(" + event + ", " + task + ')'));
        }
        this.insertItem(event, task);
        if (this.items != null && this.items.event.equals(event)) {
            this.checkItems();
        }
    }

    private void insertItem(ScheduleEvent event, ScheduleTask task) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Scheduler.insertItem(" + event + ", " + task + ')'));
        }
        Date now = new Date();
        ScheduleItem newItem = new ScheduleItem(event, task);
        newItem.date = event.nextDate(now);
        if (newItem.date == null) {
            if (!event.outdatedRestart) {
                return;
            }
            newItem.date = now;
        }
        this.insertItem(newItem);
    }

    private void insertItem(ScheduleItem newItem) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Scheduler.insertItem(" + newItem + ')'));
        }
        if (newItem.date == null) {
            return;
        }
        if (this.items == null) {
            this.items = newItem;
        } else {
            ScheduleItem prev = null;
            ScheduleItem item = this.items;
            while (item != null && newItem.date.after(item.date)) {
                prev = item;
                item = item.next;
            }
            if (prev == null) {
                if (this.items != null) {
                    this.cancel();
                    newItem.next = this.items;
                    this.items.prev = newItem;
                }
                this.items = newItem;
            } else {
                newItem.next = prev.next;
                newItem.prev = prev;
                prev.next = newItem;
                if (newItem.next != null) {
                    newItem.next.prev = newItem;
                }
            }
        }
    }

    private void checkItems() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Scheduler.checkItems()");
        }
        Date now = new Date();
        ScheduleItem item = this.items;
        while (!(item == null || item.date != null && item.date.after(now))) {
            ScheduleItem nextItem = item.next;
            item.date = item.event.nextDate(now);
            if (item.date != null && !item.date.after(now)) {
                item.date = null;
            }
            if (item.date == null) {
                this.removeItem(item);
                item = nextItem;
                continue;
            }
            if (nextItem == null || !item.date.after(nextItem.date)) continue;
            this.removeItem(item);
            this.insertItem(item);
            item = nextItem;
        }
        if (this.items != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Scheduler.checkItems nextDate = " + this.items.date));
            }
            this.schedule(this.items.event, this.items.date.getTime() - now.getTime());
        }
    }

    private void removeItem(ScheduleItem item) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Scheduler.removeItem(item) event=" + item.event + ", task=" + item.task));
        }
        if (item.next != null) {
            item.next.prev = item.prev;
        }
        if (item.prev == null) {
            this.items = item.next;
        } else {
            item.prev.next = item.next;
        }
        item.next = null;
        item.prev = null;
    }

    private void schedule(ScheduleEvent event, long period) {
        block3: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Scheduler.schedule(" + event + ", " + period + ')'));
            }
            try {
                this.wakeUp = new WakeUp();
                this.timer.schedule((TimerTask)this.wakeUp, period);
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block3;
                logger.log(BasicLevel.ERROR, (Object)"Exception in schedule", (Throwable)exc);
            }
        }
    }

    private void cancel() {
        block4: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Scheduler.cancel() wakeUp = " + this.wakeUp));
            }
            try {
                if (this.wakeUp != null) {
                    this.wakeUp.cancel();
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block4;
                logger.log(BasicLevel.DEBUG, (Object)("Exception Scheduler.cancel wakeUp = " + this.wakeUp), (Throwable)exc);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ScheduleItem item = this.items;
        while (item != null) {
            out.writeObject(item.event);
            out.writeObject(item.task);
            item = item.next;
        }
        out.writeObject(null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ScheduleEvent event = (ScheduleEvent)in.readObject();
        while (event != null) {
            ScheduleTask task = (ScheduleTask)in.readObject();
            this.insertItem(event, task);
            event = (ScheduleEvent)in.readObject();
        }
    }

    public class WakeUp
    extends TimerTask
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void run() {
            block4: {
                try {
                    if (Scheduler.this.items != null) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("WakeUp.run items.event=" + ((Scheduler)Scheduler.this).items.event + ", items.task=" + ((Scheduler)Scheduler.this).items.task));
                        }
                        ((Scheduler)Scheduler.this).items.task.run();
                    }
                    Scheduler.this.checkItems();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block4;
                    logger.log(BasicLevel.WARN, (Object)"Exception :: WakeUp.run ", (Throwable)e);
                }
            }
        }
    }
}

