/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Notification;
import java.util.Timer;
import java.util.TimerTask;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class WakeUpTask
extends TimerTask {
    private AgentId destId;
    private Logger logger;
    private Class wakeUpNot;
    private boolean schedule = false;

    public WakeUpTask(AgentId id, Class wakeUpNotClass, long period) {
        this.destId = id;
        this.wakeUpNot = wakeUpNotClass;
        this.logger = Debug.getLogger(this.getClass().getName());
        this.schedule(period);
    }

    public void run() {
        try {
            Channel.sendTo(this.destId, (Notification)this.wakeUpNot.newInstance());
        }
        catch (Exception exc) {
            this.logger.log(BasicLevel.ERROR, (Object)("--- " + this), (Throwable)exc);
        }
    }

    public void schedule(long period) {
        block5: {
            if (AgentServer.isHAServer() && !AgentServer.isMasterHAServer()) {
                return;
            }
            if (period > 0L) {
                try {
                    Timer timer = AgentServer.getTimer();
                    if (!this.schedule) {
                        timer.schedule((TimerTask)this, period, period);
                        this.schedule = true;
                    }
                }
                catch (Exception exc) {
                    if (!this.logger.isLoggable(BasicLevel.WARN)) break block5;
                    this.logger.log(BasicLevel.WARN, (Object)("--- " + this), (Throwable)exc);
                }
            }
        }
    }
}

