/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api.metadata.structures;

import java.io.Serializable;

public final class JField
implements Serializable {
    private static final long serialVersionUID = 1872275434794410559L;
    private String name = null;
    private int access;
    private String descriptor = null;
    private String signature;
    private Object value;

    public JField(int access, String name, String descriptor, String signature, Object value) {
        this.access = access;
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        Object tmpValue = value;
        if (!(tmpValue == null || tmpValue instanceof Integer || tmpValue instanceof Float || tmpValue instanceof Long || tmpValue instanceof Double || tmpValue instanceof String)) {
            throw new IllegalArgumentException("value should represent a primitive type");
        }
        this.value = tmpValue;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof JField) {
            JField other = (JField)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (this.descriptor != null && !this.descriptor.equals(other.descriptor)) {
                return false;
            }
            return this.signature == null || this.signature.equals(other.signature);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Object getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1));
        sb.append("[name=");
        sb.append(this.name);
        sb.append(", access=");
        sb.append(this.access);
        if (this.descriptor != null) {
            sb.append(", descriptor=");
            sb.append(this.descriptor);
        }
        if (this.signature != null) {
            sb.append(", signature=");
            sb.append(this.signature);
        }
        if (this.value != null) {
            sb.append(", value=");
            sb.append(this.value);
        }
        sb.append("]");
        return sb.toString();
    }

    public int getAccess() {
        return this.access;
    }
}

