/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.io.ListenCallback;
import org.apache.catalina.tribes.io.ObjectReader;
import org.apache.catalina.tribes.transport.AbstractRxTask;
import org.apache.catalina.tribes.transport.ReceiverBase;
import org.apache.catalina.tribes.transport.RxTaskPool;
import org.apache.catalina.tribes.transport.nio.NioReplicationTask;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class NioReceiver
extends ReceiverBase
implements Runnable,
ChannelReceiver,
ListenCallback {
    protected static Log log = LogFactory.getLog(NioReceiver.class);
    protected StringManager sm = StringManager.getManager("org.apache.catalina.tribes.transport");
    private static final String info = "NioReceiver/1.0";
    private Selector selector = null;
    private ServerSocketChannel serverChannel = null;
    protected LinkedList events = new LinkedList();
    protected long lastCheck = System.currentTimeMillis();

    public String getInfo() {
        return info;
    }

    public void stop() {
        this.stopListening();
        super.stop();
    }

    public void start() throws IOException {
        super.start();
        try {
            this.setPool(new RxTaskPool(this.getMaxThreads(), this.getMinThreads(), this));
        }
        catch (Exception x) {
            log.fatal("ThreadPool can initilzed. Listener not started", x);
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            throw new IOException(x.getMessage());
        }
        try {
            this.getBind();
            this.bind();
            Thread t = new Thread((Runnable)this, "NioReceiver");
            t.setDaemon(true);
            t.start();
        }
        catch (Exception x) {
            log.fatal("Unable to start cluster receiver", x);
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            throw new IOException(x.getMessage());
        }
    }

    public AbstractRxTask createRxTask() {
        NioReplicationTask thread = new NioReplicationTask(this, this);
        thread.setUseBufferPool(this.getUseBufferPool());
        thread.setRxBufSize(this.getRxBufSize());
        thread.setOptions(this.getWorkerThreadOptions());
        return thread;
    }

    protected void bind() throws IOException {
        this.serverChannel = ServerSocketChannel.open();
        ServerSocket serverSocket = this.serverChannel.socket();
        this.selector = Selector.open();
        this.bind(serverSocket, this.getTcpListenPort(), this.getAutoBind());
        this.serverChannel.configureBlocking(false);
        this.serverChannel.register(this.selector, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Runnable event) {
        if (this.selector != null) {
            LinkedList linkedList = this.events;
            synchronized (linkedList) {
                this.events.add(event);
            }
            if (log.isTraceEnabled()) {
                log.trace("Adding event to selector:" + event);
            }
            if (this.isListening() && this.selector != null) {
                this.selector.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void events() {
        if (this.events.size() == 0) {
            return;
        }
        LinkedList linkedList = this.events;
        synchronized (linkedList) {
            Runnable r = null;
            while (this.events.size() > 0 && (r = (Runnable)this.events.removeFirst()) != null) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("Processing event in selector:" + r);
                    }
                    r.run();
                }
                catch (Exception x) {
                    log.error("", x);
                }
            }
            this.events.clear();
        }
    }

    public static void cancelledKey(SelectionKey key) {
        block6: {
            block5: {
                ObjectReader reader = (ObjectReader)key.attachment();
                if (reader != null) {
                    reader.setCancelled(true);
                    reader.finish();
                }
                key.cancel();
                key.attach(null);
                try {
                    ((SocketChannel)key.channel()).socket().close();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("", e);
                }
            }
            try {
                key.channel().close();
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("", e);
            }
        }
    }

    protected void socketTimeouts() {
        Set<SelectionKey> keys;
        long now = System.currentTimeMillis();
        if (now - this.lastCheck < this.getSelectorTimeout()) {
            return;
        }
        Selector tmpsel = this.selector;
        Set<SelectionKey> set = keys = this.isListening() && tmpsel != null ? tmpsel.keys() : null;
        if (keys == null) {
            return;
        }
        for (SelectionKey key : keys) {
            try {
                if (key.interestOps() != 0) continue;
                ObjectReader ka = (ObjectReader)key.attachment();
                if (ka != null) {
                    long delta = now - ka.getLastAccess();
                    if (delta <= (long)this.getTimeout() || ka.isAccessed()) continue;
                    log.warn("Channel key is registered, but has had no interest ops for the last " + this.getTimeout() + " ms. (cancelled:" + ka.isCancelled() + "):" + key + " last access:" + new Timestamp(ka.getLastAccess()));
                    ka.setLastAccess(now);
                    continue;
                }
                NioReceiver.cancelledKey(key);
            }
            catch (CancelledKeyException ckx) {
                NioReceiver.cancelledKey(key);
            }
        }
        this.lastCheck = System.currentTimeMillis();
    }

    protected void listen() throws Exception {
        if (this.doListen()) {
            log.warn("ServerSocketChannel already started");
            return;
        }
        this.setListen(true);
        while (this.doListen() && this.selector != null) {
            try {
                this.events();
                this.socketTimeouts();
                int n = this.selector.select(this.getTcpSelectorTimeout());
                if (n == 0) continue;
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    if (key.isAcceptable()) {
                        ServerSocketChannel server = (ServerSocketChannel)key.channel();
                        SocketChannel channel = server.accept();
                        channel.socket().setReceiveBufferSize(this.getRxBufSize());
                        channel.socket().setSendBufferSize(this.getTxBufSize());
                        channel.socket().setTcpNoDelay(this.getTcpNoDelay());
                        channel.socket().setKeepAlive(this.getSoKeepAlive());
                        channel.socket().setOOBInline(this.getOoBInline());
                        channel.socket().setReuseAddress(this.getSoReuseAddress());
                        channel.socket().setSoLinger(this.getSoLingerOn(), this.getSoLingerTime());
                        channel.socket().setTrafficClass(this.getSoTrafficClass());
                        channel.socket().setSoTimeout(this.getTimeout());
                        ObjectReader attach = new ObjectReader(channel);
                        this.registerChannel(this.selector, channel, 1, attach);
                    }
                    if (key.isReadable()) {
                        this.readDataFromSocket(key);
                    } else {
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    }
                    it.remove();
                }
            }
            catch (ClosedSelectorException cse) {
            }
            catch (CancelledKeyException nx) {
                log.warn("Replication client disconnected, error when polling key. Ignoring client.");
            }
            catch (Throwable x) {
                try {
                    log.error("Unable to process request in NioReceiver", x);
                }
                catch (Throwable tx) {
                    tx.printStackTrace();
                }
            }
        }
        this.serverChannel.close();
        if (this.selector != null) {
            this.selector.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopListening() {
        this.setListen(false);
        if (this.selector != null) {
            try {
                try {
                    this.selector.wakeup();
                    this.selector.close();
                }
                catch (Exception x) {
                    log.error("Unable to close cluster receiver selector.", x);
                    Object var3_2 = null;
                    this.selector = null;
                }
                Object var3_1 = null;
                this.selector = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.selector = null;
                throw throwable;
            }
        }
    }

    protected void registerChannel(Selector selector, SelectableChannel channel, int ops, Object attach) throws Exception {
        if (channel == null) {
            return;
        }
        channel.configureBlocking(false);
        channel.register(selector, ops, attach);
    }

    public void run() {
        try {
            this.listen();
        }
        catch (Exception x) {
            log.error("Unable to run replication listener.", x);
        }
    }

    protected void readDataFromSocket(SelectionKey key) throws Exception {
        NioReplicationTask task = (NioReplicationTask)this.getTaskPool().getRxTask();
        if (task == null) {
            if (log.isDebugEnabled()) {
                log.debug("No TcpReplicationThread available");
            }
        } else {
            task.serviceChannel(key);
            this.getExecutor().execute(task);
        }
    }
}

