/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.KeyValueToken;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValueTokenBuilder
implements AssertionBuilder {
    private static final String MS_NS = "http://schemas.microsoft.com/ws/2005/07/securitypolicy";
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP12Constants.KEYVALUE_TOKEN, new QName("http://schemas.microsoft.com/ws/2005/07/securitypolicy", "RsaToken"));

    @Override
    public PolicyAssertion build(Element element) {
        QName qname;
        Element child;
        Element polEl;
        SPConstants consts = MS_NS.equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        KeyValueToken token = new KeyValueToken(consts);
        token.setOptional(PolicyConstants.isOptional(element));
        String attribute = element.getAttributeNS(element.getNamespaceURI(), "IncludeToken");
        if (StringUtils.isEmpty(attribute)) {
            attribute = element.getAttributeNS(consts.getNamespace(), "IncludeToken");
        }
        if (StringUtils.isEmpty(attribute)) {
            attribute = element.getAttributeNS(SP11Constants.INSTANCE.getNamespace(), "IncludeToken");
        }
        if (!StringUtils.isEmpty(attribute)) {
            token.setInclusion(consts.getInclusionFromAttributeValue(attribute));
        }
        if ((polEl = PolicyConstants.findPolicyElement(element)) != null && (child = DOMUtils.getFirstElement(polEl)) != null && "RsaKeyValue".equals((qname = new QName(child.getNamespaceURI(), child.getLocalName())).getLocalPart())) {
            token.setForceRsaKeyValue(true);
        }
        return token;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    @Override
    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

