/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.ews.mapper;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.gen.GeneratorFactory;
import org.apache.axis.wsdl.gen.NoopGenerator;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.ContainedAttribute;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.axis.wsdl.toJava.JavaServiceWriter;
import org.apache.axis.wsdl.toJava.JavaTypeWriter;
import org.apache.ws.ews.mapper.J2eeBindingWriter;
import org.apache.ws.ews.mapper.J2eeEmitter;
import org.apache.ws.ews.mapper.jaxrpc.JaxRpcMapper;
import org.w3c.dom.Node;

public class J2eeGeneratorFactory
implements GeneratorFactory {
    protected J2eeEmitter emitter;
    protected SymbolTable symbolTable;
    private JaxRpcMapper mapper;
    private Writers messageWriters = new Writers();
    private Writers portTypeWriters = new Writers();
    protected Writers bindingWriters = new Writers();
    protected Writers serviceWriters = new Writers();
    protected Writers typeWriters = new Writers();
    private Writers defWriters = new Writers();
    BaseTypeMapping btm = null;
    static /* synthetic */ Class class$javax$wsdl$Definition;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$JavaDefinitionWriter;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$JavaDeployWriter;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$JavaUndeployWriter;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$Emitter;
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$SymbolTable;
    static /* synthetic */ Class class$javax$wsdl$Message;
    static /* synthetic */ Class class$javax$wsdl$PortType;
    static /* synthetic */ Class class$javax$wsdl$Binding;
    static /* synthetic */ Class class$javax$wsdl$Service;
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$TypeEntry;

    public J2eeGeneratorFactory() {
        this.addGenerators();
    }

    public J2eeGeneratorFactory(J2eeEmitter emitter) {
        this.emitter = emitter;
        this.addGenerators();
    }

    public void setEmitter(J2eeEmitter emitter) {
        this.emitter = emitter;
    }

    private void addGenerators() {
        this.addMessageGenerators();
        this.addPortTypeGenerators();
        this.addBindingGenerators();
        this.addServiceGenerators();
        this.addTypeGenerators();
        this.addDefinitionGenerators();
    }

    protected void addMessageGenerators() {
    }

    protected void addPortTypeGenerators() {
    }

    protected void addBindingGenerators() {
    }

    protected void addServiceGenerators() {
    }

    protected void addTypeGenerators() {
    }

    protected void addDefinitionGenerators() {
        this.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = J2eeGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$org$apache$axis$wsdl$toJava$JavaDefinitionWriter == null ? (class$org$apache$axis$wsdl$toJava$JavaDefinitionWriter = J2eeGeneratorFactory.class$("org.apache.axis.wsdl.toJava.JavaDefinitionWriter")) : class$org$apache$axis$wsdl$toJava$JavaDefinitionWriter);
        this.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = J2eeGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$org$apache$axis$wsdl$toJava$JavaDeployWriter == null ? (class$org$apache$axis$wsdl$toJava$JavaDeployWriter = J2eeGeneratorFactory.class$("org.apache.axis.wsdl.toJava.JavaDeployWriter")) : class$org$apache$axis$wsdl$toJava$JavaDeployWriter);
        this.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = J2eeGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$org$apache$axis$wsdl$toJava$JavaUndeployWriter == null ? (class$org$apache$axis$wsdl$toJava$JavaUndeployWriter = J2eeGeneratorFactory.class$("org.apache.axis.wsdl.toJava.JavaUndeployWriter")) : class$org$apache$axis$wsdl$toJava$JavaUndeployWriter);
    }

    public void generatorPass(Definition def, SymbolTable symbolTable) {
        this.mapper = this.emitter.getJaxRpcMapper();
        this.symbolTable = symbolTable;
        this.javifyNames(symbolTable);
        this.setFaultContext(symbolTable);
        this.resolveNameClashes(symbolTable);
        this.determineInterfaceNames(symbolTable);
        if (this.emitter.isAllWanted()) {
            this.setAllReferencesToTrue();
        } else {
            this.ignoreNonSOAPBindings(symbolTable);
        }
        this.constructSignatures(symbolTable);
        this.determineIfHoldersNeeded(symbolTable);
    }

    public Generator getGenerator(Message message, SymbolTable symbolTable) {
        MessageEntry mEntry = symbolTable.getMessageEntry(message.getQName());
        this.messageWriters.addStuff((Generator)new NoopGenerator(), (SymTabEntry)mEntry, symbolTable);
        return this.messageWriters;
    }

    public Generator getGenerator(PortType portType, SymbolTable symbolTable) {
        PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(portType.getQName());
        this.portTypeWriters.addStuff((Generator)new NoopGenerator(), (SymTabEntry)ptEntry, symbolTable);
        return this.portTypeWriters;
    }

    public Generator getGenerator(Binding binding, SymbolTable symbolTable) {
        J2eeBindingWriter writer = new J2eeBindingWriter(this.emitter, binding, symbolTable);
        BindingEntry bEntry = symbolTable.getBindingEntry(binding.getQName());
        this.bindingWriters.addStuff((Generator)writer, (SymTabEntry)bEntry, symbolTable);
        return this.bindingWriters;
    }

    public Generator getGenerator(Service service, SymbolTable symbolTable) {
        JavaServiceWriter writer = new JavaServiceWriter((Emitter)this.emitter, service, symbolTable);
        ServiceEntry sEntry = symbolTable.getServiceEntry(service.getQName());
        this.serviceWriters.addStuff((Generator)writer, (SymTabEntry)sEntry, symbolTable);
        return this.serviceWriters;
    }

    public Generator getGenerator(TypeEntry type, SymbolTable symbolTable) {
        JavaTypeWriter writer = new JavaTypeWriter((Emitter)this.emitter, type, symbolTable);
        this.typeWriters.addStuff((Generator)writer, (SymTabEntry)type, symbolTable);
        return this.typeWriters;
    }

    public Generator getGenerator(Definition definition, SymbolTable symbolTable) {
        this.defWriters.addStuff(null, definition, symbolTable);
        return this.defWriters;
    }

    public void addGenerator(Class wsdlClass, Class generator) {
        if ((class$javax$wsdl$Message == null ? (class$javax$wsdl$Message = J2eeGeneratorFactory.class$("javax.wsdl.Message")) : class$javax$wsdl$Message).isAssignableFrom(wsdlClass)) {
            this.messageWriters.addGenerator(generator);
        } else if ((class$javax$wsdl$PortType == null ? (class$javax$wsdl$PortType = J2eeGeneratorFactory.class$("javax.wsdl.PortType")) : class$javax$wsdl$PortType).isAssignableFrom(wsdlClass)) {
            this.portTypeWriters.addGenerator(generator);
        } else if ((class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = J2eeGeneratorFactory.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding).isAssignableFrom(wsdlClass)) {
            this.bindingWriters.addGenerator(generator);
        } else if ((class$javax$wsdl$Service == null ? (class$javax$wsdl$Service = J2eeGeneratorFactory.class$("javax.wsdl.Service")) : class$javax$wsdl$Service).isAssignableFrom(wsdlClass)) {
            this.serviceWriters.addGenerator(generator);
        } else if ((class$org$apache$axis$wsdl$symbolTable$TypeEntry == null ? (class$org$apache$axis$wsdl$symbolTable$TypeEntry = J2eeGeneratorFactory.class$("org.apache.axis.wsdl.symbolTable.TypeEntry")) : class$org$apache$axis$wsdl$symbolTable$TypeEntry).isAssignableFrom(wsdlClass)) {
            this.typeWriters.addGenerator(generator);
        } else if ((class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = J2eeGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition).isAssignableFrom(wsdlClass)) {
            this.defWriters.addGenerator(generator);
        }
    }

    protected void javifyNames(SymbolTable symbolTable) {
        int uniqueNum = 0;
        HashMap anonQNames = new HashMap();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry.getName() != null) continue;
                if (entry instanceof TypeEntry) {
                    uniqueNum = this.javifyTypeEntryName(symbolTable, (TypeEntry)entry, anonQNames, uniqueNum);
                    continue;
                }
                entry.setName(this.emitter.getJavaName(entry.getQName()));
            }
        }
    }

    protected int javifyTypeEntryName(SymbolTable symbolTable, TypeEntry entry, HashMap anonQNames, int uniqueNum) {
        TypeEntry base;
        TypeEntry tEntry = entry;
        String dims = tEntry.getDimensions();
        TypeEntry refType = tEntry.getRefType();
        while (refType != null) {
            tEntry = refType;
            dims = dims + tEntry.getDimensions();
            refType = tEntry.getRefType();
        }
        TypeEntry te = tEntry;
        while (te != null && (base = SchemaUtils.getBaseType((TypeEntry)te, (SymbolTable)symbolTable)) != null) {
            uniqueNum = this.javifyTypeEntryName(symbolTable, base, anonQNames, uniqueNum);
            if (org.apache.axis.wsdl.toJava.Utils.getEnumerationBaseAndValues((Node)te.getNode(), (SymbolTable)symbolTable) == null && SchemaUtils.getContainedAttributeTypes((Node)te.getNode(), (SymbolTable)symbolTable) == null) {
                if (base.isSimpleType()) {
                    te.setSimpleType(true);
                    te.setName(base.getName());
                    te.setRefType(base);
                }
                if (base.isBaseType()) {
                    te.setBaseType(true);
                    te.setName(base.getName());
                    te.setRefType(base);
                }
            }
            if (!te.isSimpleType()) break;
            te = base;
        }
        if (tEntry.getName() == null) {
            Vector attributes;
            String javaType;
            QName typeQName = tEntry.getQName();
            QName itemType = SchemaUtils.getListItemType((Node)tEntry.getNode());
            boolean isArray = false;
            if (itemType != null) {
                typeQName = itemType;
                isArray = true;
            }
            if (typeQName.getLocalPart().indexOf(">") >= 0) {
                String localName = typeQName.getLocalPart();
                symbolTable.getType(typeQName);
                if (anonQNames.get(typeQName) != null) {
                    localName = localName + "Type" + uniqueNum++;
                    typeQName = new QName(typeQName.getNamespaceURI(), localName);
                }
                anonQNames.put(typeQName, typeQName);
            }
            if ((javaType = this.mapper.getJavaType(typeQName)) == null) {
                javaType = this.emitter.getJavaName(typeQName);
            }
            if (isArray) {
                javaType = javaType + "[]";
            }
            tEntry.setName(javaType);
            Vector elements = tEntry.getContainedElements();
            if (elements != null) {
                for (int i = 0; i < elements.size(); ++i) {
                    ElementDecl elem = (ElementDecl)elements.get(i);
                    String varName = this.emitter.getJavaVariableName(typeQName, elem.getQName(), true);
                    elem.setName(varName);
                }
            }
            if ((attributes = tEntry.getContainedAttributes()) != null) {
                for (int i = 0; i < attributes.size(); ++i) {
                    ContainedAttribute attr = (ContainedAttribute)attributes.get(i);
                    String varName = this.emitter.getJavaVariableName(typeQName, attr.getQName(), false);
                    attr.setName(varName);
                }
            }
        }
        entry.setName(tEntry.getName() + dims);
        return uniqueNum;
    }

    private void setFaultContext(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)entry;
                HashMap allOpFaults = bEntry.getFaults();
                Iterator ops = allOpFaults.values().iterator();
                while (ops.hasNext()) {
                    ArrayList faults = (ArrayList)ops.next();
                    for (int j = 0; j < faults.size(); ++j) {
                        FaultInfo info = (FaultInfo)faults.get(j);
                        this.setFaultContext(info, symbolTable);
                    }
                }
            }
        }
    }

    private void setFaultContext(FaultInfo fault, SymbolTable symbolTable) {
        QName faultXmlType = null;
        Vector parts = new Vector();
        try {
            symbolTable.getParametersFromParts(parts, (Collection)fault.getMessage().getOrderedParts(null), false, fault.getName(), null);
        }
        catch (IOException e) {
            // empty catch block
        }
        String exceptionClassName = null;
        QName faultMessageQName = fault.getMessage().getQName();
        for (int j = 0; j < parts.size(); ++j) {
            Boolean isComplexFault;
            TypeEntry te = ((Parameter)parts.elementAt(j)).getType();
            TypeEntry elementTE = null;
            if (te instanceof Element) {
                elementTE = te;
                te = te.getRefType();
            }
            faultXmlType = te.getQName();
            if (te.getBaseType() != null || te.isSimpleType() || te.getDimensions().length() > 0 && te.getRefType().getBaseType() != null || (isComplexFault = (Boolean)te.getDynamicVar((Object)JavaGeneratorFactory.COMPLEX_TYPE_FAULT)) != null && isComplexFault.booleanValue()) continue;
            te.setDynamicVar((Object)JavaGeneratorFactory.COMPLEX_TYPE_FAULT, (Object)Boolean.TRUE);
            if (elementTE != null) {
                te.setDynamicVar((Object)JavaGeneratorFactory.COMPLEX_TYPE_FAULT, (Object)Boolean.TRUE);
            }
            HashSet derivedSet = Utils.getDerivedTypes((TypeEntry)te, (SymbolTable)symbolTable);
            Iterator derivedI = derivedSet.iterator();
            while (derivedI.hasNext()) {
                TypeEntry derivedTE = (TypeEntry)derivedI.next();
                derivedTE.setDynamicVar((Object)JavaGeneratorFactory.COMPLEX_TYPE_FAULT, (Object)Boolean.TRUE);
            }
            TypeEntry base = SchemaUtils.getComplexElementExtensionBase((Node)te.getNode(), (SymbolTable)symbolTable);
            while (base != null) {
                base.setDynamicVar((Object)JavaGeneratorFactory.COMPLEX_TYPE_FAULT, (Object)Boolean.TRUE);
                base = SchemaUtils.getComplexElementExtensionBase((Node)base.getNode(), (SymbolTable)symbolTable);
            }
        }
        MessageEntry me = symbolTable.getMessageEntry(faultMessageQName);
        if (me != null) {
            me.setDynamicVar((Object)JavaGeneratorFactory.EXCEPTION_DATA_TYPE, faultXmlType);
            if (exceptionClassName != null) {
                me.setDynamicVar((Object)JavaGeneratorFactory.COMPLEX_TYPE_FAULT, (Object)Boolean.TRUE);
            } else {
                exceptionClassName = this.mapper.getExceptionType(faultMessageQName);
                if (exceptionClassName == null) {
                    exceptionClassName = this.emitter.getJavaName(me.getQName());
                }
            }
            me.setDynamicVar((Object)JavaGeneratorFactory.EXCEPTION_CLASS_NAME, (Object)exceptionClassName);
        }
    }

    protected void determineInterfaceNames(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)entry;
                    PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(bEntry.getBinding().getPortType().getQName());
                    String seiName = this.mapper.getServiceEndpointInterfaceName(ptEntry.getQName(), bEntry.getQName());
                    if (seiName == null) {
                        seiName = ptEntry.getName();
                    }
                    bEntry.setDynamicVar((Object)JavaBindingWriter.INTERFACE_NAME, (Object)seiName);
                    continue;
                }
                if (!(entry instanceof ServiceEntry)) continue;
                ServiceEntry sEntry = (ServiceEntry)entry;
                String siName = this.mapper.getServiceInterfaceName(sEntry.getQName());
                if (siName == null) {
                    siName = sEntry.getName();
                }
                sEntry.setName(siName);
                Service service = sEntry.getService();
                Map portMap = service.getPorts();
                Iterator portIterator = portMap.values().iterator();
                while (portIterator.hasNext()) {
                    Port p = (Port)portIterator.next();
                    Binding binding = p.getBinding();
                    BindingEntry bEntry = symbolTable.getBindingEntry(binding.getQName());
                    if (bEntry.getBindingType() != 0) continue;
                    String portName = this.mapper.getPortName(p.getName());
                    if (portName == null) {
                        portName = p.getName();
                    }
                    p.setName(portName);
                }
            }
        }
    }

    protected void resolveNameClashes(SymbolTable symbolTable) {
        HashSet<Type> anonTypes = new HashSet<Type>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            SymTabEntry entry;
            Vector<TypeEntry> v = new Vector<TypeEntry>((Vector)it.next());
            int index = 0;
            while (index < v.size()) {
                if (v.elementAt(index) instanceof MessageEntry) {
                    v.removeElementAt(index);
                    continue;
                }
                ++index;
            }
            if (v.size() <= 1) continue;
            boolean resolve = true;
            if (v.size() == 2 && (v.elementAt(0) instanceof Element && v.elementAt(1) instanceof Type || v.elementAt(1) instanceof Element && v.elementAt(0) instanceof Type)) {
                Element e = null;
                e = v.elementAt(0) instanceof Element ? (Element)v.elementAt(0) : (Element)v.elementAt(1);
                BooleanHolder forElement = new BooleanHolder();
                QName eType = org.apache.axis.wsdl.toJava.Utils.getTypeQName((Node)e.getNode(), (BooleanHolder)forElement, (boolean)false);
                if (eType != null && eType.equals(e.getQName()) && !forElement.value) {
                    resolve = false;
                }
            }
            if (resolve) {
                resolve = false;
                String name = null;
                for (int i = 0; i < v.size() && !resolve; ++i) {
                    entry = (SymTabEntry)v.elementAt(i);
                    if (entry instanceof MessageEntry || entry instanceof BindingEntry) continue;
                    if (name == null) {
                        name = entry.getName();
                        continue;
                    }
                    if (!name.equals(entry.getName())) continue;
                    resolve = true;
                }
            }
            if (!resolve) continue;
            boolean firstType = true;
            for (int i = 0; i < v.size(); ++i) {
                BindingEntry bEntry;
                entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof Element) {
                    entry.setName(this.mangleName(entry.getName(), "_ElemType"));
                    QName anonQName = new QName(entry.getQName().getNamespaceURI(), ">" + entry.getQName().getLocalPart());
                    Type anonType = symbolTable.getType(anonQName);
                    if (anonType == null) continue;
                    anonType.setName(entry.getName());
                    anonTypes.add(anonType);
                    continue;
                }
                if (entry instanceof TypeEntry) {
                    if (firstType) {
                        firstType = false;
                        Iterator types = symbolTable.getTypeIndex().values().iterator();
                        while (types.hasNext()) {
                            TypeEntry type = (TypeEntry)types.next();
                            if (type == entry || type.getBaseType() != null || !this.sameJavaClass(entry.getName(), type.getName())) continue;
                            v.add(type);
                        }
                    }
                    if (anonTypes.contains(entry)) continue;
                    entry.setName(this.mangleName(entry.getName(), "_Type"));
                    continue;
                }
                if (entry instanceof PortTypeEntry) {
                    entry.setName(this.mangleName(entry.getName(), "_Port"));
                    continue;
                }
                if (entry instanceof ServiceEntry) {
                    entry.setName(this.mangleName(entry.getName(), "_Service"));
                    continue;
                }
                if (!(entry instanceof BindingEntry) || !(bEntry = (BindingEntry)entry).hasLiteral()) continue;
                entry.setName(this.mangleName(entry.getName(), "_Binding"));
            }
        }
    }

    private String mangleName(String name, String mangle) {
        int index = name.indexOf("[");
        if (index >= 0) {
            String pre = name.substring(0, index);
            String post = name.substring(index);
            return pre + mangle + post;
        }
        return name + mangle;
    }

    private boolean sameJavaClass(String one, String two) {
        int index1 = one.indexOf("[");
        int index2 = two.indexOf("[");
        if (index1 > 0) {
            one = one.substring(0, index1);
        }
        if (index2 > 0) {
            two = two.substring(0, index2);
        }
        return one.equals(two);
    }

    protected void setAllReferencesToTrue() {
        Iterator it = this.symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry && ((BindingEntry)entry).getBindingType() != 0) {
                    entry.setIsReferenced(false);
                    continue;
                }
                entry.setIsReferenced(true);
            }
        }
    }

    protected void ignoreNonSOAPBindings(SymbolTable symbolTable) {
        Vector<PortTypeEntry> unusedPortTypes = new Vector<PortTypeEntry>();
        Vector<PortTypeEntry> usedPortTypes = new Vector<PortTypeEntry>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)entry;
                Binding binding = bEntry.getBinding();
                PortType portType = binding.getPortType();
                PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(portType.getQName());
                if (bEntry.getBindingType() == 0) {
                    usedPortTypes.add(ptEntry);
                    if (!unusedPortTypes.contains(ptEntry)) continue;
                    unusedPortTypes.remove(ptEntry);
                    continue;
                }
                bEntry.setIsReferenced(false);
                if (usedPortTypes.contains(ptEntry)) continue;
                unusedPortTypes.add(ptEntry);
            }
        }
        for (int i = 0; i < unusedPortTypes.size(); ++i) {
            PortTypeEntry ptEntry = (PortTypeEntry)unusedPortTypes.get(i);
            ptEntry.setIsReferenced(false);
        }
    }

    protected void constructSignatures(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)entry;
                Binding binding = bEntry.getBinding();
                PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
                PortType portType = ptEntry.getPortType();
                Iterator operations = portType.getOperations().iterator();
                while (operations.hasNext()) {
                    Operation operation = (Operation)operations.next();
                    OperationType type = operation.getStyle();
                    String name = this.mapper.getJavaMethodName(bEntry.getQName(), bEntry.getBinding().getPortType().getQName(), operation.getName());
                    if (name == null) {
                        name = operation.getName();
                    }
                    operation.setName(name);
                    Parameters parameters = bEntry.getParameters(operation);
                    if (type == OperationType.SOLICIT_RESPONSE) {
                        parameters.signature = "    // " + Messages.getMessage((String)"invalidSolResp00", (String)name);
                        System.err.println(Messages.getMessage((String)"invalidSolResp00", (String)name));
                        continue;
                    }
                    if (type == OperationType.NOTIFICATION) {
                        parameters.signature = "    // " + Messages.getMessage((String)"invalidNotif00", (String)name);
                        System.err.println(Messages.getMessage((String)"invalidNotif00", (String)name));
                        continue;
                    }
                    if (parameters == null) continue;
                    String returnType = this.mapper.getJavaMethodReturnType(bEntry.getQName(), bEntry.getBinding().getPortType().getQName(), operation.getName());
                    if (returnType != null && parameters.returnParam != null) {
                        parameters.returnParam.getType().setName(returnType);
                    }
                    for (int j = 0; j < parameters.list.size(); ++j) {
                        Parameter p = (Parameter)parameters.list.get(j);
                        String paramType = this.mapper.getJavaMethodParamType(bEntry.getQName(), bEntry.getBinding().getPortType().getQName(), operation.getName(), j);
                        if (paramType == null) continue;
                        p.getType().setName(paramType);
                    }
                    parameters.signature = this.constructSignature(parameters, name);
                }
            }
        }
    }

    private String constructSignature(Parameters parms, String opName) {
        String name = org.apache.axis.wsdl.toJava.Utils.xmlNameToJava((String)opName);
        String ret = "void";
        if (parms != null && parms.returnParam != null) {
            ret = org.apache.axis.wsdl.toJava.Utils.getParameterTypeName((Parameter)parms.returnParam);
        }
        String signature = "    public " + ret + " " + name + "(";
        boolean needComma = false;
        for (int i = 0; parms != null && i < parms.list.size(); ++i) {
            Parameter p = (Parameter)parms.list.get(i);
            if (needComma) {
                signature = signature + ", ";
            } else {
                needComma = true;
            }
            String javifiedName = org.apache.axis.wsdl.toJava.Utils.xmlNameToJava((String)p.getName());
            signature = p.getMode() == 1 ? signature + org.apache.axis.wsdl.toJava.Utils.getParameterTypeName((Parameter)p) + " " + javifiedName : signature + org.apache.axis.wsdl.toJava.Utils.holder((Parameter)p, (Emitter)this.emitter) + " " + javifiedName;
        }
        signature = signature + ") throws java.rmi.RemoteException";
        if (parms != null && parms.faults != null) {
            Iterator i = parms.faults.values().iterator();
            while (i.hasNext()) {
                Fault fault = (Fault)i.next();
                String exceptionName = org.apache.axis.wsdl.toJava.Utils.getFullExceptionName((Message)fault.getMessage(), (SymbolTable)this.symbolTable);
                if (exceptionName == null) continue;
                signature = signature + ", " + exceptionName;
            }
        }
        return signature;
    }

    protected void determineIfHoldersNeeded(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                if (!(v.get(i) instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)v.get(i);
                Iterator operations = bEntry.getParameters().values().iterator();
                while (operations.hasNext()) {
                    Parameters parms = (Parameters)operations.next();
                    for (int j = 0; j < parms.list.size(); ++j) {
                        Type anonType;
                        QName anonQName;
                        Parameter p = (Parameter)parms.list.get(j);
                        if (p.getMode() == 1) continue;
                        TypeEntry typeEntry = p.getType();
                        typeEntry.setDynamicVar((Object)"Holder is needed", (Object)Boolean.TRUE);
                        if (!typeEntry.isSimpleType() && typeEntry.getRefType() != null) {
                            typeEntry.getRefType().setDynamicVar((Object)"Holder is needed", (Object)Boolean.TRUE);
                        }
                        if ((anonQName = SchemaUtils.getElementAnonQName((Node)p.getType().getNode())) == null || (anonType = symbolTable.getType(anonQName)) == null) continue;
                        anonType.setDynamicVar((Object)"Holder is needed", (Object)Boolean.TRUE);
                    }
                }
            }
        }
    }

    public void setBaseTypeMapping(BaseTypeMapping btm) {
        this.btm = btm;
    }

    public BaseTypeMapping getBaseTypeMapping() {
        if (this.btm == null) {
            this.btm = new BaseTypeMapping(){

                public String getBaseName(QName qNameIn) {
                    QName qName = new QName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                    Class cls = J2eeGeneratorFactory.this.emitter.getDefaultTypeMapping().getClassForQName(qName);
                    if (cls == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName((String)cls.getName());
                }
            };
        }
        return this.btm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class Writers
    implements Generator {
        Vector writers = new Vector();
        SymbolTable symbolTable = null;
        Generator baseWriter = null;
        SymTabEntry entry = null;
        Definition def = null;

        protected Writers() {
        }

        public void addGenerator(Class writer) {
            this.writers.add(writer);
        }

        public void addStuff(Generator baseWriter, SymTabEntry entry, SymbolTable symbolTable) {
            this.baseWriter = baseWriter;
            this.entry = entry;
            this.symbolTable = symbolTable;
        }

        public void addStuff(Generator baseWriter, Definition def, SymbolTable symbolTable) {
            this.baseWriter = baseWriter;
            this.def = def;
            this.symbolTable = symbolTable;
        }

        public void generate() throws IOException {
            if (this.baseWriter != null) {
                this.baseWriter.generate();
            }
            Class[] formalArgs = null;
            Object[] actualArgs = null;
            if (this.entry != null) {
                formalArgs = new Class[]{class$org$apache$axis$wsdl$toJava$Emitter == null ? (class$org$apache$axis$wsdl$toJava$Emitter = J2eeGeneratorFactory.class$("org.apache.axis.wsdl.toJava.Emitter")) : class$org$apache$axis$wsdl$toJava$Emitter, this.entry.getClass(), class$org$apache$axis$wsdl$symbolTable$SymbolTable == null ? (class$org$apache$axis$wsdl$symbolTable$SymbolTable = J2eeGeneratorFactory.class$("org.apache.axis.wsdl.symbolTable.SymbolTable")) : class$org$apache$axis$wsdl$symbolTable$SymbolTable};
                actualArgs = new Object[]{J2eeGeneratorFactory.this.emitter, this.entry, this.symbolTable};
            } else {
                formalArgs = new Class[]{class$org$apache$axis$wsdl$toJava$Emitter == null ? (class$org$apache$axis$wsdl$toJava$Emitter = J2eeGeneratorFactory.class$("org.apache.axis.wsdl.toJava.Emitter")) : class$org$apache$axis$wsdl$toJava$Emitter, class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = J2eeGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$org$apache$axis$wsdl$symbolTable$SymbolTable == null ? (class$org$apache$axis$wsdl$symbolTable$SymbolTable = J2eeGeneratorFactory.class$("org.apache.axis.wsdl.symbolTable.SymbolTable")) : class$org$apache$axis$wsdl$symbolTable$SymbolTable};
                actualArgs = new Object[]{J2eeGeneratorFactory.this.emitter, this.def, this.symbolTable};
            }
            for (int i = 0; i < this.writers.size(); ++i) {
                Class wClass = (Class)this.writers.get(i);
                Generator gen = null;
                try {
                    Constructor ctor = wClass.getConstructor(formalArgs);
                    gen = (Generator)ctor.newInstance(actualArgs);
                }
                catch (Throwable t) {
                    throw new IOException(Messages.getMessage((String)"exception01", (String)t.getMessage()));
                }
                gen.generate();
            }
        }
    }
}

