/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.bean.EasyBeansSB;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.container.AbsFactory;
import org.ow2.easybeans.container.info.SessionBeanInfo;
import org.ow2.easybeans.container.session.EasyBeansSessionContext;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.proxy.client.ClientRPCInvocationHandler;
import org.ow2.easybeans.rpc.EJBLocalRequestImpl;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBRemoteRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.basic.CreatePoolItemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionFactory<PoolType extends EasyBeansSB<PoolType>>
extends AbsFactory<PoolType> {
    private static final boolean RECREATE_DYNAMIC_PROXY = Boolean.getBoolean("easybeans.recreate.dynamic.proxy");
    private static Log logger = LogFactory.getLog(SessionFactory.class);
    private SessionBeanInfo sessionBeanInfo = null;
    private InheritableThreadLocal<String> invokedBusinessInterfaceNameThreadLocal = new InheritableThreadLocal();

    public SessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            try {
                this.getPool().stop();
            }
            catch (PoolException e) {
                logger.error((Object)"Problem when stopping the factory", new Object[]{e});
                Object var3_2 = null;
                super.stop();
            }
            Object var3_1 = null;
            super.stop();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.stop();
            throw throwable;
        }
    }

    public IBeanInfo getBeanInfo() {
        return this.sessionBeanInfo;
    }

    public SessionBeanInfo getSessionBeanInfo() {
        return this.sessionBeanInfo;
    }

    public void setSessionBeanInfo(SessionBeanInfo sessionBeanInfo) {
        this.sessionBeanInfo = sessionBeanInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolType createPoolItem() throws CreatePoolItemException {
        EasyBeansSB instance = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            try {
                instance = (EasyBeansSB)this.getBeanClass().newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)"Unable to create a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(WAITING_TIME_BEFORE_CREATION, "Cannot create a new instance", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"Unable to create a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(WAITING_TIME_BEFORE_CREATION, "Cannot create a new instance", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to create a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(WAITING_TIME_BEFORE_CREATION, "Cannot create a new instance", (Throwable)e);
            }
            Object var5_7 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable;
        }
        instance.setEasyBeansFactory((Factory)this);
        instance.setEasyBeansInvocationContextFactory(this.getInvocationContextFactory());
        EasyBeansSessionContext<SessionFactory> sessionContext = new EasyBeansSessionContext<SessionFactory>(this);
        instance.setEasyBeansContext(sessionContext);
        oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            try {
                this.injectResources(instance);
            }
            catch (PoolException e) {
                logger.error((Object)"Unable to inject resources in the instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(WAITING_TIME_BEFORE_CREATION, "Cannot inject resource in the instance", (Throwable)e);
            }
            this.postConstruct(instance);
            Object var7_11 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable;
        }
        return (PoolType)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EJBResponse rpcInvoke(EJBRemoteRequest request) {
        EJBResponse eJBResponse;
        EventBeanInvocationEnd eventBeanInvocationEnd;
        IAuditID previousID;
        block18: {
            EJBResponse eJBResponse2;
            block17: {
                Method calledMethod = this.getHashes().get(request.getMethodHash());
                if (calledMethod == null) {
                    logger.debug((Object)"Requested method {0} is not present on the bean class ''{1}''", new Object[]{request.getMethodName(), this.getBeanClass()});
                    return new JEJBResponse();
                }
                Object[] args = null;
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
                try {
                    args = request.getMethodArgs();
                    Object var6_5 = null;
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    throw throwable;
                }
                previousID = null;
                if (this.getCurrentInvocationID() != null) {
                    previousID = this.getCurrentInvocationID().newInvocation();
                }
                String methodEventProviderId = this.getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(calledMethod) + "@Remote";
                EZBEventBeanInvocationBegin eZBEventBeanInvocationBegin = this.getInvocationEventBegin(methodEventProviderId, args);
                long number = eZBEventBeanInvocationBegin.getInvocationNumber();
                this.getEventDispatcher().dispatch((IEvent)eZBEventBeanInvocationBegin);
                try {
                    try {
                        EJBResponse result;
                        block16: {
                            Object value;
                            EJBLocalRequestImpl localRequest = new EJBLocalRequestImpl(request.getMethodHash(), args, request.getBeanId(), request.getInvokedBusinessInterfaceName());
                            localRequest.setCalledFromRemoteRequest(true);
                            result = this.localCall(localRequest);
                            eventBeanInvocationEnd = new EventBeanInvocationEnd(methodEventProviderId, number, result);
                            if (RECREATE_DYNAMIC_PROXY && (value = result.getValue()) != null) {
                                try {
                                    InvocationHandler handler = Proxy.getInvocationHandler(value);
                                    if (!(handler instanceof ClientRPCInvocationHandler) || !((ClientRPCInvocationHandler)handler).isBusinessObjectMode()) break block16;
                                    result.setValue((Object)handler);
                                    eJBResponse2 = result;
                                }
                                catch (IllegalArgumentException e) {
                                    logger.debug((Object)"Not a proxy instance", new Object[]{e});
                                    break block16;
                                }
                                Object var16_20 = null;
                                break block17;
                            }
                        }
                        eJBResponse = result;
                        break block18;
                    }
                    catch (Exception ex) {
                        EventBeanInvocationError eventBeanInvocationError = new EventBeanInvocationError(methodEventProviderId, number, ex);
                        throw new RuntimeException(ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var16_22 = null;
                    if (this.getCurrentInvocationID() != null) {
                        this.getCurrentInvocationID().setAuditID(previousID);
                    }
                    this.getEventDispatcher().dispatch((IEvent)eZBEventBeanInvocationBegin);
                    throw throwable;
                }
            }
            if (this.getCurrentInvocationID() != null) {
                this.getCurrentInvocationID().setAuditID(previousID);
            }
            this.getEventDispatcher().dispatch((IEvent)eventBeanInvocationEnd);
            return eJBResponse2;
        }
        Object var16_21 = null;
        if (this.getCurrentInvocationID() != null) {
            this.getCurrentInvocationID().setAuditID(previousID);
        }
        this.getEventDispatcher().dispatch((IEvent)eventBeanInvocationEnd);
        return eJBResponse;
    }

    protected abstract PoolType getBean(Long var1) throws IllegalArgumentException;

    public abstract EJBResponse localCall(EJBLocalRequest var1);

    protected InheritableThreadLocal<String> getInvokedBusinessInterfaceNameThreadLocal() {
        return this.invokedBusinessInterfaceNameThreadLocal;
    }

    public void poolItemRemoved(PoolType instance) {
        super.remove(instance);
        instance.setEasyBeansRemoved(true);
    }
}

