/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.sunas;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.JavaLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.transaction.sunas.SunAS9TransactionController;

public class SunAS9ServerPlatform
extends ServerPlatformBase {
    public SunAS9ServerPlatform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
    }

    public Class getExternalTransactionControllerClass() {
        if (this.externalTransactionControllerClass == null) {
            this.externalTransactionControllerClass = SunAS9TransactionController.class;
        }
        return this.externalTransactionControllerClass;
    }

    public Connection unwrapConnection(final Connection connection) {
        Connection unwrappedConnection = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<Connection>(){

            @Override
            public Connection run() {
                return SunAS9ServerPlatform.this.unwrapGlassFishConnectionHelper(connection);
            }
        }) : this.unwrapGlassFishConnectionHelper(connection);
        if (unwrappedConnection == null) {
            unwrappedConnection = super.unwrapConnection(connection);
        }
        return unwrappedConnection;
    }

    private Connection unwrapGlassFishConnectionHelper(Connection connection) {
        Connection unwrappedConnection = null;
        try {
            Class<?> connectionWrapperClass = connection.getClass().getClassLoader().loadClass("com.sun.gjc.spi.base.ConnectionHolder");
            if (connectionWrapperClass.isInstance(connection)) {
                Method unwrapMethod = connectionWrapperClass.getDeclaredMethod("getConnection", new Class[0]);
                unwrappedConnection = (Connection)unwrapMethod.invoke((Object)connection, new Object[0]);
            }
        }
        catch (Exception e) {
            this.getDatabaseSession().getSessionLog().logThrowable(6, e);
        }
        return unwrappedConnection;
    }

    public SessionLog getServerLog() {
        return new JavaLog();
    }
}

