/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.util.date;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XsDateTimeFormat
extends Format {
    private static final long serialVersionUID = 3258131340871479609L;
    final boolean parseDate;
    final boolean parseTime;
    final boolean parseTimezone;

    XsDateTimeFormat(boolean pParseDate, boolean pParseTime) {
        this(pParseDate, pParseTime, true);
    }

    XsDateTimeFormat(boolean pParseDate, boolean pParseTime, boolean pParseTimezone) {
        this.parseDate = pParseDate;
        this.parseTime = pParseTime;
        this.parseTimezone = pParseTimezone;
    }

    public XsDateTimeFormat() {
        this(true, true, true);
    }

    public Object parseObject(String pString, ParsePosition pParsePosition) {
        if (pString == null) {
            throw new NullPointerException("The String argument must not be null.");
        }
        if (pParsePosition == null) {
            throw new NullPointerException("The ParsePosition argument must not be null.");
        }
        int offset = pParsePosition.getIndex();
        int idxSpc = pString.indexOf(32, offset);
        int idxCom = pString.indexOf(44, offset);
        if (idxCom != -1 && idxCom < idxSpc) {
            idxSpc = idxCom;
        }
        String newVal = null;
        newVal = idxSpc == -1 ? pString.substring(offset) : pString.substring(offset, idxSpc);
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            XMLGregorianCalendar cal = factory.newXMLGregorianCalendar(newVal);
            pParsePosition.setIndex(idxSpc);
            return cal.toGregorianCalendar();
        }
        catch (DatatypeConfigurationException e) {
            pParsePosition.setErrorIndex(offset);
            return null;
        }
    }

    private void append(StringBuffer pBuffer, int pNum, int pMinLen) {
        String s = Integer.toString(pNum);
        for (int i = s.length(); i < pMinLen; ++i) {
            pBuffer.append('0');
        }
        pBuffer.append(s);
    }

    public StringBuffer format(Object pCalendar, StringBuffer pBuffer, FieldPosition pPos) {
        if (pCalendar == null) {
            throw new NullPointerException("The Calendar argument must not be null.");
        }
        if (pBuffer == null) {
            throw new NullPointerException("The StringBuilder argument must not be null.");
        }
        if (pPos == null) {
            throw new NullPointerException("The FieldPosition argument must not be null.");
        }
        Calendar cal = (Calendar)pCalendar;
        if (this.parseDate) {
            int year = cal.get(1);
            if (year < 0) {
                pBuffer.append('-');
                year = -year;
            }
            this.append(pBuffer, year, 4);
            pBuffer.append('-');
            this.append(pBuffer, cal.get(2) + 1, 2);
            pBuffer.append('-');
            this.append(pBuffer, cal.get(5), 2);
            if (this.parseTime) {
                pBuffer.append('T');
            }
        }
        if (this.parseTime) {
            this.append(pBuffer, cal.get(11), 2);
            pBuffer.append(':');
            this.append(pBuffer, cal.get(12), 2);
            pBuffer.append(':');
            this.append(pBuffer, cal.get(13), 2);
            int millis = cal.get(14);
            if (millis > 0) {
                pBuffer.append('.');
                this.append(pBuffer, millis, 3);
            }
        }
        if (this.parseTimezone) {
            TimeZone tz = cal.getTimeZone();
            int offset = cal.get(15);
            if (tz.inDaylightTime(cal.getTime())) {
                offset += cal.get(16);
            }
            if (offset == 0) {
                pBuffer.append('Z');
            } else {
                if (offset < 0) {
                    pBuffer.append('-');
                    offset = -offset;
                } else {
                    pBuffer.append('+');
                }
                int minutes = offset / 60000;
                int hours = minutes / 60;
                this.append(pBuffer, hours, 2);
                pBuffer.append(':');
                this.append(pBuffer, minutes -= hours * 60, 2);
            }
        }
        return pBuffer;
    }
}

