/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.List;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.CriteriaExpression;
import org.apache.openjpa.persistence.criteria.CriteriaExpressionVisitor;
import org.apache.openjpa.persistence.criteria.Expressions;
import org.apache.openjpa.persistence.util.ReservedWords;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SelectionImpl<X>
implements Selection<X>,
CriteriaExpression {
    private final Class<X> _cls;
    private String _alias;
    private Boolean _autoAliased;

    public SelectionImpl(Class<X> cls) {
        this._cls = cls;
    }

    public Class<X> getJavaType() {
        return this._cls;
    }

    public String getAlias() {
        return this._alias;
    }

    public Selection<X> alias(String alias) {
        this.assertValidName(alias);
        if (this.isAliased()) {
            throw new IllegalStateException(this + " has been aliased to [" + this._alias + ". Can not alias again to " + alias);
        }
        this._alias = alias;
        this._autoAliased = false;
        return this;
    }

    void setAutoAlias(String alias) {
        if (this.isAliased()) {
            throw new IllegalStateException(this + " has been aliased. Can not set alias internally");
        }
        this._alias = alias;
        this._autoAliased = true;
    }

    boolean isAutoAliased() {
        return this._autoAliased == null ? true : this._autoAliased;
    }

    boolean isAliased() {
        return Boolean.FALSE.equals(this._autoAliased);
    }

    public List<Selection<?>> getCompoundSelectionItems() {
        throw new IllegalStateException(this + " is not a compound selection");
    }

    public boolean isCompoundSelection() {
        return false;
    }

    void assertValidName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("empty name is invalid");
        }
        if (ReservedWords.isKeyword(name)) {
            throw new IllegalArgumentException("reserved word " + name + " is not valid");
        }
        Character ch = ReservedWords.hasSpecialCharacter(name);
        if (ch != null) {
            throw new IllegalArgumentException(name + " contains reserved symbol " + ch);
        }
    }

    @Override
    public StringBuilder asValue(AliasContext q) {
        throw new IllegalStateException(this.getClass().getSimpleName() + " can not be rendered as value");
    }

    @Override
    public StringBuilder asVariable(AliasContext q) {
        throw new IllegalStateException(this.getClass().getSimpleName() + " can not be rendered as variable");
    }

    @Override
    public StringBuilder asProjection(AliasContext q) {
        String as = this.isAutoAliased() ? "" : " AS " + this.getAlias();
        return this.asValue(q).append(as);
    }

    @Override
    public void acceptVisit(CriteriaExpressionVisitor visitor) {
        Expressions.acceptVisit(visitor, this, null);
    }
}

