/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.datasource.api.DataStore;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.lib.ExpressionPrinter;
import org.objectweb.medor.lib.Log;
import org.objectweb.medor.optim.api.RewriteRule;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.NestQueryNode;
import org.objectweb.medor.query.api.NestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.Nest;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class BasicRule
implements RewriteRule {
    protected Logger log = null;
    protected boolean debug = false;

    public BasicRule() {
        this.log = Log.loggerFactory.getLogger("org.objectweb.medor.optim.rule");
        this.debug = this.log != null && this.log.isLoggable(BasicLevel.DEBUG);
    }

    public BasicRule(String suffix) {
        this.log = Log.loggerFactory.getLogger("org.objectweb.medor.optim.rule." + suffix);
        this.debug = this.log != null && this.log.isLoggable(BasicLevel.DEBUG);
    }

    public QueryTree rewrite(QueryTree qt) throws MedorException {
        return this.rewrite(qt, null);
    }

    private boolean replace(Expression e, Map old2neo) {
        FieldOperand fo;
        Field f;
        this.log.log(BasicLevel.DEBUG, (Object)("ReplaceUsage: Replacing expression " + ExpressionPrinter.e2str(e)));
        if (e instanceof Operator) {
            int size = ((Operator)e).getOperandNumber();
            boolean res = false;
            for (int i = 0; i < size; ++i) {
                res |= this.replace(((Operator)e).getExpression(i), old2neo);
            }
            return res;
        }
        if (e instanceof FieldOperand && (f = (Field)old2neo.get((fo = (FieldOperand)e).getField())) != null) {
            this.log.log(BasicLevel.DEBUG, (Object)("ReplaceUsage: Found new Field " + f));
            fo.setField(f);
            return true;
        }
        return false;
    }

    protected void replaceUsage(QueryNode qn, Map old2neo) throws MedorException {
        if (qn == null) {
            return;
        }
        Field[] fs = qn.getTupleStructure().getFields();
        for (int i = 0; i < fs.length; ++i) {
            if (fs[i] instanceof PropagatedField) {
                PropagatedField pf = (PropagatedField)fs[i];
                QueryTreeField parent = (QueryTreeField)pf.getPreviousFields()[0];
                this.log.log(BasicLevel.DEBUG, (Object)("ReplaceUsage: Replacing PropagatedField " + pf + " (" + parent + ")"));
                QueryTreeField neo = (QueryTreeField)old2neo.get(parent);
                if (neo == null) continue;
                this.log.log(BasicLevel.DEBUG, (Object)("ReplaceUsage: with " + neo));
                qn.updatePropagatedField(fs[i].getName(), new QueryTreeField[]{neo});
                continue;
            }
            if (fs[i] instanceof CalculatedField) {
                CalculatedField cf = (CalculatedField)fs[i];
                if (!this.replace(cf.getExpression(), old2neo)) continue;
                qn.updateCalculatedField(cf.getName(), cf.getExpression());
                continue;
            }
            if (fs[i] instanceof NestedField) {
                NestedField nf = (NestedField)fs[i];
                ArrayList<Field> newFields = new ArrayList<Field>();
                boolean changedNested = false;
                for (int j = 0; j < nf.getSize(); ++j) {
                    this.log.log(BasicLevel.DEBUG, (Object)("ReplaceUsage: Replacing NestedField field " + nf.getField(j + 1) + " " + nf.getField(j + 1).getName()));
                    QueryTreeField neo = (QueryTreeField)old2neo.get(nf.getField(j + 1));
                    if (neo != null) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Found as " + neo + " " + neo.getName() + " of node " + neo.getQueryTree()));
                        changedNested = true;
                        if (newFields.contains(neo)) continue;
                        newFields.add(neo);
                        continue;
                    }
                    this.log.log(BasicLevel.DEBUG, (Object)"Keeping old field");
                    if (newFields.contains(nf.getField(j + 1))) continue;
                    newFields.add(nf.getField(j + 1));
                }
                if (!changedNested) continue;
                this.log.log(BasicLevel.DEBUG, (Object)"Something changed");
                ((NestQueryNode)qn).replaceNestedField(fs[i].getName(), newFields.toArray(new Field[0]));
                continue;
            }
            throw new MedorException("Unmanaged field: " + fs[i].getName());
        }
        if (qn instanceof Nest) {
            this.log.log(BasicLevel.DEBUG, (Object)"Replacing GROUP BY fields:");
            QueryTreeField[] qfs = ((Nest)qn).getNestingFields();
            for (int i = 0; i < qfs.length; ++i) {
                QueryTreeField neo = (QueryTreeField)old2neo.get(qfs[i]);
                if (neo != null) {
                    this.log.log(BasicLevel.DEBUG, (Object)("Replacing " + qfs[i] + " with " + neo));
                    ((Nest)qn).replaceNestingField(qfs[i], neo);
                    continue;
                }
                this.log.log(BasicLevel.DEBUG, (Object)"Keeping old GROUP BY field");
            }
        }
    }

    protected List getLeavesWithDataStore(DataStore ds, QueryNode qn) {
        ArrayList<QueryLeaf> lList = new ArrayList<QueryLeaf>();
        QueryTree[] children = qn.getChildren();
        for (int i = 0; i < children.length; ++i) {
            QueryLeaf leaf;
            QueryTree child = children[i];
            if (!(child instanceof QueryLeaf) || !(leaf = (QueryLeaf)child).getDataStore().equals(ds)) continue;
            lList.add(leaf);
        }
        return lList;
    }

    public class ModifiedExpression {
        public boolean isModified;
        public Expression e;

        public ModifiedExpression() {
        }

        public ModifiedExpression(Expression ex, boolean ism) {
            this.e = ex;
            this.isModified = ism;
        }
    }
}

