/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc.util;

import org.hibernate.jdbc.util.BasicFormatterImpl;
import org.hibernate.jdbc.util.DDLFormatterImpl;
import org.hibernate.jdbc.util.Formatter;

public class FormatStyle {
    public static final FormatStyle BASIC = new FormatStyle("basic", new BasicFormatterImpl());
    public static final FormatStyle DDL = new FormatStyle("ddl", new DDLFormatterImpl());
    public static final FormatStyle NONE = new FormatStyle("none", new NoFormatImpl());
    private final String name;
    private final Formatter formatter;

    private FormatStyle(String name, Formatter formatter) {
        this.name = name;
        this.formatter = formatter;
    }

    public String getName() {
        return this.name;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormatStyle that = (FormatStyle)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private static class NoFormatImpl
    implements Formatter {
        private NoFormatImpl() {
        }

        public String format(String source) {
            return source;
        }
    }
}

