/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.IClassMetadata;
import org.ow2.util.scan.api.metadata.IMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class InheritanceMethodResolver {
    private static final String JAVA_LANG_OBJECT = Type.getInternalName(Object.class);
    private static Log logger = LogFactory.getLog(InheritanceMethodResolver.class);

    private InheritanceMethodResolver() {
    }

    public static void resolve(EasyBeansEjbJarClassMetadata classAnnotationMetadata) throws ResolverException {
        InheritanceMethodResolver.addMethodMetadata(classAnnotationMetadata, classAnnotationMetadata);
    }

    private static void addMethodMetadata(EasyBeansEjbJarClassMetadata beanclassAnnotationMetadata, EasyBeansEjbJarClassMetadata visitingClassAnnotationMetadata) throws ResolverException {
        String superClass = visitingClassAnnotationMetadata.getSuperName();
        if (superClass != null) {
            if (superClass.equals(JAVA_LANG_OBJECT)) {
                return;
            }
            EasyBeansEjbJarClassMetadata superClassMetadata = (EasyBeansEjbJarClassMetadata)beanclassAnnotationMetadata.getLinkedClassMetadata(superClass);
            if (superClassMetadata == null) {
                throw new ResolverException("The class " + (Object)((Object)beanclassAnnotationMetadata) + " extends the class " + superClass + "but this class seems to be outside of the ejb-jar");
            }
            for (EasyBeansEjbJarMethodMetadata methodAnnotationMetadata : superClassMetadata.getMethodMetadataCollection()) {
                JMethod method = methodAnnotationMetadata.getJMethod();
                EasyBeansEjbJarMethodMetadata beanMethod = (EasyBeansEjbJarMethodMetadata)beanclassAnnotationMetadata.getMethodMetadata(method);
                boolean overrided = true;
                boolean bl = overrided = (method.getAccess() & 2) != 2;
                if (beanMethod != null && (overrided || beanMethod == null || beanMethod.isInherited())) continue;
                EasyBeansEjbJarMethodMetadata clonedMethodAnnotationMetadata = (EasyBeansEjbJarMethodMetadata)methodAnnotationMetadata.clone();
                clonedMethodAnnotationMetadata.setClassMetadata((IClassMetadata)beanclassAnnotationMetadata);
                clonedMethodAnnotationMetadata.setInherited(true, superClassMetadata);
                if ((method.getAccess() & 0x10) == 16) {
                    logger.warn((Object)"Ignoring final method ''{0}'' from the class ''{1}''", new Object[]{method.getName(), beanclassAnnotationMetadata.getClassName()});
                    clonedMethodAnnotationMetadata.setIgnored(true);
                }
                beanclassAnnotationMetadata.addStandardMethodMetadata((IMethodMetadata)clonedMethodAnnotationMetadata);
                if (clonedMethodAnnotationMetadata.isPostConstruct()) {
                    beanclassAnnotationMetadata.addPostConstructMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPreDestroy()) {
                    beanclassAnnotationMetadata.addPreDestroyMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPostActivate()) {
                    beanclassAnnotationMetadata.addPostActivateMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPrePassivate()) {
                    beanclassAnnotationMetadata.addPrePassivateMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (!clonedMethodAnnotationMetadata.isAroundInvoke()) continue;
                beanclassAnnotationMetadata.addAroundInvokeMethodMetadata(clonedMethodAnnotationMetadata);
            }
            InheritanceMethodResolver.addMethodMetadata(beanclassAnnotationMetadata, superClassMetadata);
        }
    }
}

