/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import javassist.util.proxy.MethodHandler;
import org.jboss.weld.exceptions.NullInstanceException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.util.reflection.SecureReflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallableMethodHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = -1348302663981663427L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private final Callable<?> callable;

    public CallableMethodHandler(Callable<?> callable) {
        this.callable = callable;
    }

    public Object invoke(Object self, Method proxiedMethod, Method proceed, Object[] args) throws Throwable {
        if ("finalize".equals(proxiedMethod.getName())) {
            return null;
        }
        Object instance = this.callable.call();
        if (instance == null) {
            throw new NullInstanceException(BeanMessage.NULL_INSTANCE, this.callable);
        }
        try {
            Object returnValue = SecureReflections.invoke(instance, proxiedMethod, args);
            log.trace(BeanMessage.CALL_PROXIED_METHOD, proxiedMethod, instance, args, returnValue == null ? null : returnValue);
            return returnValue;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }
}

