/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.bootstrap.events.ExternalAnnotatedType;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.AbstractWeldAnnotated;
import org.jboss.weld.introspector.jlr.WeldConstructorImpl;
import org.jboss.weld.introspector.jlr.WeldFieldImpl;
import org.jboss.weld.introspector.jlr.WeldMethodImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Names;
import org.jboss.weld.util.collections.HashSetSupplier;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldClassImpl<T>
extends AbstractWeldAnnotated<T, Class<T>>
implements WeldClass<T> {
    private final WeldClass<?> superclass;
    private final Set<WeldField<?, ?>> fields;
    private final SetMultimap<Class<? extends Annotation>, WeldField<?, ?>> annotatedFields;
    private final Set<WeldField<?, ?>> declaredFields;
    private final Map<String, WeldField<?, ?>> declaredFieldsByName;
    private final SetMultimap<Class<? extends Annotation>, WeldField<?, ? super T>> declaredAnnotatedFields;
    private final SetMultimap<Class<? extends Annotation>, WeldField<?, ?>> declaredMetaAnnotatedFields;
    private final Set<WeldMethod<?, ?>> methods;
    private final Map<MethodSignature, WeldMethod<?, ?>> declaredMethodsBySignature;
    private final Map<MethodSignature, WeldMethod<?, ?>> methodsBySignature;
    private final SetMultimap<Class<? extends Annotation>, WeldMethod<?, ?>> annotatedMethods;
    private final Set<WeldMethod<?, ?>> declaredMethods;
    private final SetMultimap<Class<? extends Annotation>, WeldMethod<?, ? super T>> declaredAnnotatedMethods;
    private final SetMultimap<Class<? extends Annotation>, WeldMethod<?, ? super T>> declaredMethodsByAnnotatedParameters;
    private final Set<AnnotatedConstructor<T>> constructors;
    private final Map<ConstructorSignature, WeldConstructor<?>> declaredConstructorsBySignature;
    private final SetMultimap<Class<? extends Annotation>, WeldConstructor<T>> annotatedConstructors;
    private final Map<List<Class<?>>, WeldConstructor<T>> constructorsByArgumentMap;
    private final SetMultimap<Class<? extends Annotation>, Annotation> declaredMetaAnnotationMap;
    private final boolean discovered;

    private static <T> void mapConstructorAnnotations(SetMultimap<Class<? extends Annotation>, WeldConstructor<T>> annotatedConstructors, WeldConstructor<T> annotatedConstructor) {
        for (Annotation annotation : annotatedConstructor.getAnnotations()) {
            if (!annotatedConstructors.containsKey(annotation.annotationType())) {
                annotatedConstructors.putAll(annotation.annotationType(), new HashSet());
            }
            annotatedConstructors.get(annotation.annotationType()).add(annotatedConstructor);
        }
    }

    public static <T> WeldClass<T> of(Class<T> clazz, ClassTransformer classTransformer) {
        return new WeldClassImpl<T>(clazz, clazz, null, new HierarchyDiscovery(clazz).getTypeClosure(), WeldClassImpl.buildAnnotationMap(clazz.getAnnotations()), WeldClassImpl.buildAnnotationMap(clazz.getDeclaredAnnotations()), classTransformer);
    }

    public static <T> WeldClass<T> of(AnnotatedType<T> annotatedType, ClassTransformer classTransformer) {
        return new WeldClassImpl<T>(annotatedType.getJavaClass(), annotatedType.getBaseType(), annotatedType, annotatedType.getTypeClosure(), WeldClassImpl.buildAnnotationMap(annotatedType.getAnnotations()), WeldClassImpl.buildAnnotationMap(annotatedType.getAnnotations()), classTransformer);
    }

    public static <T> WeldClass<T> of(Class<T> rawType, Type type, ClassTransformer classTransformer) {
        return new WeldClassImpl<T>(rawType, type, null, new HierarchyDiscovery(type).getTypeClosure(), WeldClassImpl.buildAnnotationMap(rawType.getAnnotations()), WeldClassImpl.buildAnnotationMap(rawType.getDeclaredAnnotations()), classTransformer);
    }

    protected WeldClassImpl(Class<T> rawType, Type type, AnnotatedType<T> annotatedType, Set<Type> typeClosure, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, ClassTransformer classTransformer) {
        super(annotationMap, declaredAnnotationMap, classTransformer, rawType, type, typeClosure);
        Class<T> c;
        this.discovered = !(annotatedType instanceof ExternalAnnotatedType);
        this.superclass = rawType.getSuperclass() != null ? classTransformer.loadClass(rawType.getSuperclass()) : null;
        this.fields = new HashSet();
        this.annotatedFields = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        this.declaredFields = new HashSet();
        this.declaredFieldsByName = new HashMap();
        this.declaredAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        this.declaredMetaAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        if (annotatedType == null) {
            for (c = rawType; c != Object.class && c != null; c = c.getSuperclass()) {
                for (Field field : SecureReflections.getDeclaredFields(c)) {
                    WeldFieldImpl annotatedField = WeldFieldImpl.of(field, this.getDeclaringWeldClass(field, classTransformer), classTransformer);
                    this.fields.add(annotatedField);
                    if (c == rawType) {
                        this.declaredFields.add(annotatedField);
                        this.declaredFieldsByName.put(annotatedField.getName(), annotatedField);
                    }
                    for (Annotation annotation : annotatedField.getAnnotations()) {
                        this.annotatedFields.put(annotation.annotationType(), annotatedField);
                        if (c == rawType) {
                            this.declaredAnnotatedFields.put(annotation.annotationType(), annotatedField);
                        }
                        for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                            if (c != rawType) continue;
                            this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                        }
                    }
                }
            }
        } else {
            for (AnnotatedField<T> annotatedField : annotatedType.getFields()) {
                WeldFieldImpl<?, T> weldField = WeldFieldImpl.of(annotatedField, this, classTransformer);
                this.fields.add(weldField);
                if (annotatedField.getDeclaringType().getJavaClass() == rawType) {
                    this.declaredFields.add(weldField);
                    this.declaredFieldsByName.put(weldField.getName(), weldField);
                }
                for (Annotation annotation : weldField.getAnnotations()) {
                    this.annotatedFields.put(annotation.annotationType(), weldField);
                    if (annotatedField.getDeclaringType().getJavaClass() != rawType) continue;
                    this.declaredAnnotatedFields.put(annotation.annotationType(), weldField);
                    for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                        this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), weldField);
                    }
                }
            }
        }
        this.constructors = new HashSet<AnnotatedConstructor<T>>();
        this.constructorsByArgumentMap = new HashMap();
        this.annotatedConstructors = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        this.declaredConstructorsBySignature = new HashMap();
        if (annotatedType == null) {
            Constructor<?>[] arr$ = SecureReflections.getDeclaredConstructors(rawType);
            int n = arr$.length;
            for (int i$ = 0; i$ < n; ++i$) {
                Constructor<?> constructor;
                Constructor<?> c2 = constructor = arr$[i$];
                WeldConstructor<?> annotatedConstructor = WeldConstructorImpl.of(c2, this.getDeclaringWeldClass(c2, classTransformer), classTransformer);
                this.constructors.add(annotatedConstructor);
                this.constructorsByArgumentMap.put(Arrays.asList(constructor.getParameterTypes()), annotatedConstructor);
                this.declaredConstructorsBySignature.put(annotatedConstructor.getSignature(), annotatedConstructor);
                WeldClassImpl.mapConstructorAnnotations(this.annotatedConstructors, annotatedConstructor);
            }
        } else {
            for (AnnotatedConstructor annotatedConstructor : annotatedType.getConstructors()) {
                WeldConstructor weldConstructor = WeldConstructorImpl.of(annotatedConstructor, this, classTransformer);
                this.constructors.add(weldConstructor);
                ArrayList parameterTypes = new ArrayList();
                for (AnnotatedParameter parameter : annotatedConstructor.getParameters()) {
                    parameterTypes.add(Reflections.getRawType(parameter.getBaseType()));
                }
                this.constructorsByArgumentMap.put(parameterTypes, weldConstructor);
                this.declaredConstructorsBySignature.put(weldConstructor.getSignature(), weldConstructor);
                WeldClassImpl.mapConstructorAnnotations(this.annotatedConstructors, weldConstructor);
            }
        }
        this.methods = new HashSet();
        this.annotatedMethods = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        this.declaredMethods = new HashSet();
        this.declaredAnnotatedMethods = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        this.declaredMethodsByAnnotatedParameters = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        this.declaredMethodsBySignature = new HashMap();
        this.methodsBySignature = new HashMap();
        if (annotatedType == null) {
            for (c = rawType; c != Object.class && c != null; c = c.getSuperclass()) {
                for (Method method : SecureReflections.getDeclaredMethods(c)) {
                    WeldMethodImpl weldMethod = WeldMethodImpl.of(method, this.getDeclaringWeldClass(method, classTransformer), classTransformer);
                    this.methods.add(weldMethod);
                    this.methodsBySignature.put(weldMethod.getSignature(), weldMethod);
                    if (c == rawType) {
                        this.declaredMethods.add(weldMethod);
                        this.declaredMethodsBySignature.put(weldMethod.getSignature(), weldMethod);
                    }
                    for (Annotation annotation : weldMethod.getAnnotations()) {
                        this.annotatedMethods.put(annotation.annotationType(), weldMethod);
                        if (c != rawType) continue;
                        this.declaredAnnotatedMethods.put(annotation.annotationType(), weldMethod);
                    }
                    for (Class annotationType : WeldMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                        if (weldMethod.getWeldParameters(annotationType).size() <= 0 || c != rawType) continue;
                        this.declaredMethodsByAnnotatedParameters.put(annotationType, weldMethod);
                    }
                }
            }
        } else {
            for (AnnotatedMethod annotatedMethod : annotatedType.getMethods()) {
                WeldMethodImpl weldMethod = WeldMethodImpl.of(annotatedMethod, this, classTransformer);
                this.methods.add(weldMethod);
                this.methodsBySignature.put(weldMethod.getSignature(), weldMethod);
                if (annotatedMethod.getDeclaringType().getJavaClass() == rawType) {
                    this.declaredMethods.add(weldMethod);
                    this.declaredMethodsBySignature.put(weldMethod.getSignature(), weldMethod);
                }
                for (Annotation annotation : weldMethod.getAnnotations()) {
                    this.annotatedMethods.put(annotation.annotationType(), weldMethod);
                    if (annotatedMethod.getDeclaringType().getJavaClass() != rawType) continue;
                    this.declaredAnnotatedMethods.put(annotation.annotationType(), weldMethod);
                }
                for (Class annotationType : WeldMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                    if (weldMethod.getWeldParameters(annotationType).size() <= 0 || annotatedMethod.getDeclaringType().getJavaClass() != rawType) continue;
                    this.declaredMethodsByAnnotatedParameters.put(annotationType, weldMethod);
                }
            }
        }
        this.declaredMetaAnnotationMap = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        for (Annotation annotation : declaredAnnotationMap.values()) {
            WeldClassImpl.addMetaAnnotations(this.declaredMetaAnnotationMap, annotation, annotation.annotationType().getAnnotations(), true);
            WeldClassImpl.addMetaAnnotations(this.declaredMetaAnnotationMap, annotation, classTransformer.getTypeStore().get(annotation.annotationType()), true);
            this.declaredMetaAnnotationMap.put(annotation.annotationType(), annotation);
        }
    }

    private <X> WeldClass<X> getDeclaringWeldClass(Member member, ClassTransformer transformer) {
        if (member.getDeclaringClass().equals(this.getJavaClass())) {
            return this;
        }
        return transformer.loadClass(member.getDeclaringClass());
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.getJavaClass();
    }

    @Override
    public Class<T> getDelegate() {
        return this.getJavaClass();
    }

    @Override
    public Set<WeldField<?, ?>> getWeldFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<WeldField<?, ?>> getDeclaredFields() {
        return Collections.unmodifiableSet(this.declaredFields);
    }

    @Override
    public <F> WeldField<F, ?> getDeclaredWeldField(String fieldName) {
        return this.declaredFieldsByName.get(fieldName);
    }

    @Override
    public Set<WeldField<?, ? super T>> getDeclaredWeldFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredAnnotatedFields.get(annotationType));
    }

    @Override
    public WeldConstructor<T> getDeclaredWeldConstructor(ConstructorSignature signature) {
        return this.declaredConstructorsBySignature.get(signature);
    }

    @Override
    public Set<WeldField<?, ?>> getWeldFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedFields.get(annotationType));
    }

    @Override
    public boolean isLocalClass() {
        return this.getJavaClass().isLocalClass();
    }

    @Override
    public boolean isAnonymousClass() {
        return this.getJavaClass().isAnonymousClass();
    }

    @Override
    public boolean isMemberClass() {
        return this.getJavaClass().isMemberClass();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isEnum() {
        return this.getJavaClass().isEnum();
    }

    @Override
    public boolean isSerializable() {
        return Reflections.isSerializable(this.getJavaClass());
    }

    @Override
    public Set<WeldMethod<?, ?>> getWeldMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMethods.get(annotationType));
    }

    @Override
    public Set<WeldMethod<?, ? super T>> getDeclaredWeldMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredAnnotatedMethods.get(annotationType));
    }

    @Override
    public Set<WeldConstructor<T>> getWeldConstructors(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedConstructors.get(annotationType));
    }

    @Override
    public WeldConstructor<T> getNoArgsWeldConstructor() {
        return this.constructorsByArgumentMap.get(Collections.emptyList());
    }

    @Override
    public Set<WeldMethod<?, ? super T>> getDeclaredWeldMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredMethodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public WeldMethod<?, ?> getWeldMethod(Method methodDescriptor) {
        for (WeldMethod<?, ?> annotatedMethod : this.methods) {
            if (!annotatedMethod.getName().equals(methodDescriptor.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), methodDescriptor.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Set<WeldMethod<?, ?>> getWeldMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    @Override
    public WeldMethod<?, ?> getDeclaredWeldMethod(Method method) {
        for (WeldMethod<?, ?> annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), method.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Set<WeldMethod<?, ?>> getDeclaredWeldMethods() {
        return this.declaredMethods;
    }

    @Override
    public <M> WeldMethod<M, ?> getDeclaredWeldMethod(MethodSignature signature) {
        return this.declaredMethodsBySignature.get(signature);
    }

    @Override
    public <M> WeldMethod<M, ?> getWeldMethod(MethodSignature signature) {
        return this.methodsBySignature.get(signature);
    }

    public String toString() {
        return Names.toString(this.getJavaClass(), this.getAnnotations(), this.getActualTypeArguments());
    }

    @Override
    public String getSimpleName() {
        return this.getJavaClass().getSimpleName();
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic(this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal(this.getDelegate());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isFinal(this.getJavaClass().getModifiers());
    }

    @Override
    public String getName() {
        return this.getJavaClass().getName();
    }

    @Override
    public WeldClass<?> getWeldSuperclass() {
        return this.superclass;
    }

    @Override
    public boolean isEquivalent(Class<?> clazz) {
        return this.getDelegate().equals(clazz);
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isPackagePrivate() {
        return Reflections.isPackagePrivate(this.getJavaClass().getModifiers());
    }

    @Override
    public Package getPackage() {
        return this.getJavaClass().getPackage();
    }

    @Override
    public <U> WeldClass<? extends U> asWeldSubclass(WeldClass<U> clazz) {
        return this;
    }

    @Override
    public <S> S cast(Object object) {
        return (S)object;
    }

    @Override
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return this.constructors;
    }

    @Override
    public Set<AnnotatedField<? super T>> getFields() {
        return this.fields;
    }

    @Override
    public Set<AnnotatedMethod<? super T>> getMethods() {
        return this.methods;
    }

    @Override
    public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.declaredMetaAnnotationMap.get(metaAnnotationType));
    }

    @Override
    public boolean isDiscovered() {
        return this.discovered;
    }
}

