/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.felix.framework.resolver.Content;

public class ContentDirectoryContent
implements Content {
    private final Content m_content;
    private final String m_rootPath;

    public ContentDirectoryContent(Content content, String path) {
        this.m_content = content;
        this.m_rootPath = path.length() > 0 && path.charAt(path.length() - 1) != '/' ? path + "/" : path;
    }

    public void close() {
    }

    public boolean hasEntry(String name) throws IllegalStateException {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return this.m_content.hasEntry(this.m_rootPath + name);
    }

    public Enumeration getEntries() {
        return new EntriesEnumeration(this.m_content.getEntries(), this.m_rootPath);
    }

    public byte[] getEntryAsBytes(String name) throws IllegalStateException {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return this.m_content.getEntryAsBytes(this.m_rootPath + name);
    }

    public InputStream getEntryAsStream(String name) throws IllegalStateException, IOException {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return this.m_content.getEntryAsStream(this.m_rootPath + name);
    }

    public Content getEntryAsContent(String name) {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return this.m_content.getEntryAsContent(this.m_rootPath + name);
    }

    public String getEntryAsNativeLibrary(String name) {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return this.m_content.getEntryAsNativeLibrary(this.m_rootPath + name);
    }

    public String toString() {
        return "CONTENT DIR " + this.m_rootPath + " (" + this.m_content + ")";
    }

    private static class EntriesEnumeration
    implements Enumeration {
        private final Enumeration m_enumeration;
        private final String m_rootPath;
        private String m_nextEntry = null;

        public EntriesEnumeration(Enumeration enumeration, String rootPath) {
            this.m_enumeration = enumeration;
            this.m_rootPath = rootPath;
            this.m_nextEntry = this.findNextEntry();
        }

        public synchronized boolean hasMoreElements() {
            return this.m_nextEntry != null;
        }

        public synchronized Object nextElement() {
            if (this.m_nextEntry == null) {
                throw new NoSuchElementException("No more elements.");
            }
            String currentEntry = this.m_nextEntry;
            this.m_nextEntry = this.findNextEntry();
            return currentEntry;
        }

        private String findNextEntry() {
            while (this.m_enumeration.hasMoreElements()) {
                String next = (String)this.m_enumeration.nextElement();
                if (!next.startsWith(this.m_rootPath) || next.equals(this.m_rootPath)) continue;
                return next.substring(this.m_rootPath.length());
            }
            return null;
        }
    }
}

