/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;
import java.util.Properties;
import org.objectweb.joram.mom.dest.ClusterAck;
import org.objectweb.joram.mom.dest.ClusterNot;
import org.objectweb.joram.mom.dest.ClusterTest;
import org.objectweb.joram.mom.dest.Destination;
import org.objectweb.joram.mom.dest.DestinationImpl;
import org.objectweb.joram.mom.dest.TopicForwardNot;
import org.objectweb.joram.mom.dest.TopicImpl;
import org.objectweb.joram.mom.notifications.AbstractRequestNot;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.SubscribeRequest;
import org.objectweb.joram.mom.notifications.UnsubscribeRequest;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.util.monolog.api.BasicLevel;

public class Topic
extends Destination {
    private static final long serialVersionUID = 1L;

    public final byte getType() {
        return 1;
    }

    public Topic() {
    }

    protected Topic(String name, boolean fixed, int stamp) {
        super(name, fixed, stamp);
    }

    public DestinationImpl createsImpl(AgentId adminId, Properties prop) throws RequestException {
        return new TopicImpl(adminId, prop);
    }

    public void react(AgentId from, Notification not) throws Exception {
        ((TopicImpl)this.destImpl).setAlreadySentLocally(false);
        int reqId = -1;
        if (not instanceof AbstractRequestNot) {
            reqId = ((AbstractRequestNot)not).getRequestId();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": got " + not.getClass().getName() + " with id: " + reqId + " from: " + from.toString()));
        }
        try {
            if (not instanceof ClusterTest) {
                ((TopicImpl)this.destImpl).clusterTest(from, (ClusterTest)not);
            } else if (not instanceof ClusterAck) {
                ((TopicImpl)this.destImpl).clusterAck(from, (ClusterAck)not);
            } else if (not instanceof ClusterNot) {
                ((TopicImpl)this.destImpl).clusterNot(from, (ClusterNot)not);
            } else if (not instanceof SubscribeRequest) {
                ((TopicImpl)this.destImpl).subscribeRequest(from, (SubscribeRequest)not);
            } else if (not instanceof UnsubscribeRequest) {
                ((TopicImpl)this.destImpl).unsubscribeRequest(from);
            } else if (not instanceof TopicForwardNot) {
                ((TopicImpl)this.destImpl).topicForwardNot((TopicForwardNot)not);
            } else {
                super.react(from, not);
            }
        }
        catch (MomException exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)exc);
            }
            AbstractRequestNot req = (AbstractRequestNot)not;
            Channel.sendTo((AgentId)from, (Notification)new ExceptionReply(req, exc));
        }
    }
}

