/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.BagSerializer;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownNotificationException;
import fr.dyade.aaa.agent.WakeUpTask;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimerTask;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.proxies.ClientContext;
import org.objectweb.joram.mom.proxies.CloseConnectionNot;
import org.objectweb.joram.mom.proxies.ConnectionContext;
import org.objectweb.joram.mom.proxies.GetConnectionNot;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.ProxyAgentItf;
import org.objectweb.joram.mom.proxies.ProxyImpl;
import org.objectweb.joram.mom.proxies.ProxyRequestGroupNot;
import org.objectweb.joram.mom.proxies.ReliableConnectionContext;
import org.objectweb.joram.mom.proxies.RequestBuffer;
import org.objectweb.joram.mom.proxies.RequestNot;
import org.objectweb.joram.mom.proxies.ResetCollocatedConnectionsNot;
import org.objectweb.joram.mom.proxies.ReturnConnectionNot;
import org.objectweb.joram.mom.proxies.SendRepliesNot;
import org.objectweb.joram.mom.proxies.SendReplyNot;
import org.objectweb.joram.mom.proxies.StandardConnectionContext;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CnxCloseRequest;
import org.objectweb.joram.shared.client.JmsRequestGroup;
import org.objectweb.joram.shared.client.ProducerMessages;
import org.objectweb.joram.shared.client.ServerReply;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class UserAgent
extends Agent
implements BagSerializer,
ProxyAgentItf {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)UserAgent.class.getName());
    private ProxyImpl proxyImpl;
    private transient Hashtable connections;
    private transient Hashtable heartBeatTasks;
    private int keyCounter;
    private transient WakeUpTask cleaningTask;

    public UserAgent() {
        super(true);
        this.init();
    }

    public UserAgent(String name, int stamp) {
        super(name, true, stamp);
        this.init();
    }

    private void init() {
        this.proxyImpl = new ProxyImpl(this);
        this.keyCounter = 0;
    }

    public void agentInitialize(boolean firstTime) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.agentInitialize(" + firstTime + ')'));
        }
        super.agentInitialize(firstTime);
        this.proxyImpl.initialize(firstTime);
        if (this.proxyImpl.getPeriod() > 0L) {
            this.cleaningTask = new WakeUpTask(this.getId(), WakeUpNot.class, this.proxyImpl.getPeriod());
        }
        try {
            MXWrapper.registerMBean((Object)this.proxyImpl, (String)this.getMBeanName());
        }
        catch (Exception exc) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " jmx failed"), (Throwable)exc);
        }
    }

    public void agentFinalize(boolean lastTime) {
        if (this.cleaningTask != null) {
            this.cleaningTask.cancel();
        }
        try {
            MXWrapper.unregisterMBean((String)this.getMBeanName());
        }
        catch (Exception exc) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " jmx failed"), (Throwable)exc);
        }
        super.agentFinalize(lastTime);
    }

    public String getMBeanName() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Joram#").append(AgentServer.getServerId());
        strbuf.append(':');
        strbuf.append("type=User,name=").append(this.getName());
        return strbuf.toString();
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.react(" + from + ',' + not + ')'));
        }
        this.setNoSave();
        if (not instanceof OpenConnectionNot) {
            this.doReact((OpenConnectionNot)not);
        } else if (not instanceof GetConnectionNot) {
            this.doReact((GetConnectionNot)not);
        } else if (not instanceof CloseConnectionNot) {
            this.doReact((CloseConnectionNot)not);
        } else if (not instanceof ResetCollocatedConnectionsNot) {
            this.doReact((ResetCollocatedConnectionsNot)not);
        } else if (not instanceof SendReplyNot) {
            this.doReact((SendReplyNot)not);
        } else if (not instanceof RequestNot) {
            this.doReact((RequestNot)not);
        } else if (not instanceof ReturnConnectionNot) {
            this.doReact((ReturnConnectionNot)not);
        } else if (not instanceof SendRepliesNot) {
            this.doReact((SendRepliesNot)not);
        } else if (not instanceof ProxyRequestGroupNot) {
            this.doReact((ProxyRequestGroupNot)not);
        } else if (not instanceof WakeUpNot) {
            if (this.cleaningTask == null || ((WakeUpNot)not).update) {
                this.setPeriod(this.proxyImpl.getPeriod());
            }
            if (this.proxyImpl.getPeriod() > 0L) {
                this.proxyImpl.cleanPendingMessages(System.currentTimeMillis());
            }
        } else {
            try {
                this.proxyImpl.react(from, not);
            }
            catch (UnknownNotificationException exc) {
                super.react(from, not);
            }
        }
    }

    private void setPeriod(long period) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": setPeriod(" + period + ")." + " -> task " + this.cleaningTask));
        }
        if (this.cleaningTask == null) {
            this.cleaningTask = new WakeUpTask(this.getId(), WakeUpNot.class, period);
        } else {
            this.cleaningTask.cancel();
            if (period > 0L) {
                this.cleaningTask = new WakeUpTask(this.getId(), WakeUpNot.class, period);
            }
        }
    }

    private void doReact(OpenConnectionNot not) {
        ConnectionContext ctx;
        this.setSave();
        if (this.connections == null) {
            this.connections = new Hashtable();
            this.heartBeatTasks = new Hashtable();
        }
        Integer objKey = new Integer(this.keyCounter);
        if (not.getReliable()) {
            ctx = new ReliableConnectionContext(this.proxyImpl, this.keyCounter, not.getHeartBeat());
            this.connections.put(objKey, ctx);
        } else {
            ctx = new StandardConnectionContext(this.proxyImpl, this.keyCounter);
            this.connections.put(objKey, ctx);
        }
        if (not.getHeartBeat() > 0) {
            HeartBeatTask heartBeatTask = new HeartBeatTask(2 * not.getHeartBeat(), objKey);
            this.heartBeatTasks.put(objKey, heartBeatTask);
            try {
                heartBeatTask.start();
            }
            catch (IOException exc) {
                this.heartBeatTasks.remove(objKey);
            }
        }
        this.sendTo(this.getId(), new ReturnConnectionNot(not, ctx));
        ++this.keyCounter;
    }

    private void doReact(ReturnConnectionNot not) {
        not.Return();
    }

    private void doReact(GetConnectionNot not) {
        int key = not.getKey();
        if (this.connections == null) {
            not.Throw(new Exception("Connection " + key + " not found"));
        } else {
            Integer objKey = new Integer(key);
            ReliableConnectionContext ctx = (ReliableConnectionContext)this.connections.get(objKey);
            if (ctx == null) {
                not.Throw(new Exception("Connection " + key + " not found"));
            } else {
                not.Return(ctx);
            }
        }
    }

    private void doReact(RequestNot not) {
        ConnectionContext ctx;
        Integer key = new Integer(not.getConnectionKey());
        if (this.connections != null && (ctx = (ConnectionContext)this.connections.get(key)) != null) {
            HeartBeatTask heartBeatTask = (HeartBeatTask)this.heartBeatTasks.get(key);
            if (heartBeatTask != null) {
                heartBeatTask.touch();
            }
            AbstractJmsRequest request = ctx.getRequest(not.getMessage());
            this.proxyImpl.reactToClientRequest((int)key, request);
            if (ctx.isClosed()) {
                this.connections.remove(key);
                HeartBeatTask hbt = (HeartBeatTask)this.heartBeatTasks.remove(key);
                if (hbt != null) {
                    hbt.cancel();
                }
            }
        }
    }

    private void doReact(ProxyRequestGroupNot not) {
        RequestNot[] requests = not.getRequests();
        RequestBuffer rm = new RequestBuffer(this);
        for (int i = 0; i < requests.length; ++i) {
            ConnectionContext ctx;
            RequestNot req = requests[i];
            Integer key = new Integer(req.getConnectionKey());
            HeartBeatTask heartBeatTask = (HeartBeatTask)this.heartBeatTasks.get(key);
            if (heartBeatTask != null) {
                heartBeatTask.touch();
            }
            if ((ctx = (ConnectionContext)this.connections.get(key)) == null) continue;
            AbstractJmsRequest request = ctx.getRequest(req.getMessage());
            if (request instanceof ProducerMessages) {
                ProducerMessages pm = (ProducerMessages)request;
                rm.put(req.getConnectionKey(), pm);
                continue;
            }
            if (request instanceof JmsRequestGroup) {
                JmsRequestGroup jrg = (JmsRequestGroup)request;
                AbstractJmsRequest[] groupedRequests = jrg.getRequests();
                for (int j = 0; j < groupedRequests.length; ++j) {
                    if (groupedRequests[i] instanceof ProducerMessages) {
                        ProducerMessages pm = (ProducerMessages)groupedRequests[i];
                        rm.put(req.getConnectionKey(), pm);
                        continue;
                    }
                    this.proxyImpl.reactToClientRequest((int)key, groupedRequests[i]);
                }
                continue;
            }
            this.proxyImpl.reactToClientRequest((int)key, request);
        }
        rm.flush();
    }

    private void doReact(CloseConnectionNot not) {
        Integer key;
        if (this.connections != null && this.connections.remove(key = new Integer(not.getKey())) != null) {
            this.proxyImpl.reactToClientRequest(not.getKey(), (AbstractJmsRequest)new CnxCloseRequest());
            this.heartBeatTasks.remove(key);
        }
    }

    private void doReact(ResetCollocatedConnectionsNot not) {
        if (this.connections != null) {
            Collection values = this.connections.values();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof StandardConnectionContext)) continue;
                ConnectionContext cc = (ConnectionContext)obj;
                this.proxyImpl.reactToClientRequest(cc.getKey(), (AbstractJmsRequest)new CnxCloseRequest());
                iterator.remove();
            }
        }
    }

    private void doReact(SendRepliesNot not) {
        Enumeration en = not.getReplies();
        while (en.hasMoreElements()) {
            SendReplyNot sr = (SendReplyNot)((Object)en.nextElement());
            this.doReact(sr);
        }
    }

    private void doReact(SendReplyNot not) {
        ClientContext cc;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.doReact(" + (Object)((Object)not) + ')'));
        }
        if ((cc = this.proxyImpl.getClientContext(not.getKey())) != null) {
            if (cc.setReply(not.getRequestId()) == 0) {
                this.sendToClient(not.getKey(), (AbstractJmsReply)new ServerReply(not.getRequestId()));
            }
        } else if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent: unknown client context for " + (Object)((Object)not)));
        }
    }

    public void sendNot(AgentId to, Notification not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.sendNot(" + to + ',' + not + ')'));
        }
        this.sendTo(to, not);
    }

    public void sendToClient(int key, AbstractJmsReply reply) {
        ConnectionContext ctx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("UserAgent.sendToClient(" + key + ',' + reply + ')'));
        }
        Integer objKey = new Integer(key);
        if (this.connections != null && (ctx = (ConnectionContext)this.connections.get(objKey)) != null) {
            ctx.pushReply(reply);
        }
    }

    public void setNoSave() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"setNoSave()");
        }
        super.setNoSave();
    }

    public void setSave() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"UserAgent.setSave()");
        }
        super.setSave();
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.connections = (Hashtable)in.readObject();
        this.heartBeatTasks = (Hashtable)in.readObject();
        if (this.heartBeatTasks != null && this.heartBeatTasks.size() > 0) {
            Enumeration tasks = this.heartBeatTasks.elements();
            while (tasks.hasMoreElements()) {
                ((HeartBeatTask)tasks.nextElement()).start();
            }
        }
        this.proxyImpl.readBag(in);
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        out.writeObject(this.connections);
        out.writeObject(this.heartBeatTasks);
        this.proxyImpl.writeBag(out);
    }

    class HeartBeatTask
    extends TimerTask
    implements Externalizable {
        private transient int timeout;
        private transient Integer key;
        private transient long lastRequestDate;

        HeartBeatTask(int timeout, Integer key) {
            this.timeout = timeout;
            this.key = key;
        }

        public void run() {
            long date = System.currentTimeMillis();
            if (date - this.lastRequestDate > (long)this.timeout) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"HeartBeatTask: close connection");
                }
                ConnectionContext ctx = (ConnectionContext)UserAgent.this.connections.remove(this.key);
                UserAgent.this.heartBeatTasks.remove(this.key);
                UserAgent.this.proxyImpl.reactToClientRequest((int)this.key, (AbstractJmsRequest)new CnxCloseRequest());
                if (ctx != null) {
                    MomException exc = new MomException(99999, "Connection " + UserAgent.this.getId() + ':' + this.key + " closed");
                    ctx.pushError(exc);
                }
            }
        }

        public void start() throws IOException {
            this.lastRequestDate = System.currentTimeMillis();
            try {
                AgentServer.getTimer().schedule((TimerTask)this, this.timeout, (long)this.timeout);
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)("HeartBeatTask: cannot schedule task " + this.key), (Throwable)exc);
                }
                throw new IOException(exc.getMessage());
            }
        }

        public void touch() {
            this.lastRequestDate = System.currentTimeMillis();
        }

        public HeartBeatTask() {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.timeout = in.readInt();
            this.key = new Integer(in.readInt());
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.timeout);
            out.writeInt(this.key);
        }
    }
}

