/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.TransactionError;
import fr.dyade.aaa.agent.UnknownServerException;
import java.io.IOException;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Channel {
    static Channel channel = null;
    protected Logger logmon = null;
    static Vector consumers = null;

    static Channel newInstance() throws Exception {
        String cname = AgentServer.getProperty("Channel", "fr.dyade.aaa.agent.Channel");
        Class<?> cclass = Class.forName(cname);
        channel = (Channel)cclass.newInstance();
        return channel;
    }

    protected Channel() {
        consumers = new Vector();
        this.logmon = Debug.getLogger((String)("fr.dyade.aaa.agent.Engine.#" + AgentServer.getServerId()));
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.toString() + " created."));
    }

    public static final void sendTo(AgentId to, Notification not) {
        if (Thread.currentThread() == AgentServer.engine.thread) {
            AgentServer.engine.push(AgentServer.engine.agent.getId(), to, not);
        } else {
            channel.directSendTo(AgentId.localId, to, not);
        }
    }

    static final void post(Message msg) throws Exception {
        try {
            MessageConsumer cons = AgentServer.getConsumer(msg.to.getTo());
            if (!consumers.contains(cons)) {
                consumers.add(cons);
            }
            cons.post(msg);
        }
        catch (UnknownServerException exc) {
            Channel.channel.logmon.log(BasicLevel.WARN, (Object)(channel.toString() + ", can't post message: " + msg), (Throwable)exc);
        }
    }

    static final void save() throws IOException {
        for (int i = 0; i < consumers.size(); ++i) {
            ((MessageConsumer)consumers.elementAt(i)).save();
        }
    }

    static final void validate() {
        for (int i = 0; i < consumers.size(); ++i) {
            ((MessageConsumer)consumers.elementAt(i)).validate();
        }
        consumers.clear();
    }

    void directSendTo(AgentId from, AgentId to, Notification not) {
        MessageConsumer consumer = null;
        Message msg = null;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.toString() + ".directSendTo(" + from + ", " + to + ", " + not + ")"));
        }
        if (to == null || to.isNullId()) {
            return;
        }
        msg = Message.alloc(from, to, not);
        try {
            consumer = AgentServer.getConsumer(to.to);
        }
        catch (UnknownServerException exc) {
            Channel.channel.logmon.log(BasicLevel.ERROR, (Object)(this.toString() + ", can't post message: " + msg), (Throwable)exc);
            return;
        }
        try {
            AgentServer.getTransaction().begin();
            consumer.post(msg);
            consumer.save();
            AgentServer.getTransaction().commit(false);
            consumer.validate();
            AgentServer.getTransaction().release();
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.FATAL, (Object)(this.toString() + ", Transaction problem."), (Throwable)exc);
            throw new TransactionError(this.toString() + ", " + exc.getMessage());
        }
    }

    public final String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Channel#").append(AgentServer.getServerId());
        return strbuf.toString();
    }
}

