/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.annotation.processor.handler;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.util.annotation.processor.ProcessorException;
import org.ow2.util.annotation.processor.handler.AbstractInjectionHandler;

public abstract class AbstractJNDIInjectionHandler
extends AbstractInjectionHandler {
    private Context envContext;

    public AbstractJNDIInjectionHandler(Context envContext) {
        this.envContext = envContext;
    }

    protected Object doRegistryLookup(String name) throws ProcessorException {
        try {
            InitialContext ictx = new InitialContext();
            return ictx.lookup(name);
        }
        catch (NamingException e) {
            throw new ProcessorException("Cannot lookup '" + name + "'", e);
        }
    }

    protected Object doContextLookup(String name) throws ProcessorException {
        try {
            return this.envContext.lookup(name);
        }
        catch (NamingException e) {
            throw new ProcessorException("Cannot lookup 'java:comp/env/" + name + "'", e);
        }
    }

    protected String getStandardBindingName(Field field) {
        Class<?> support = field.getDeclaringClass();
        String jndiName = support.getName();
        jndiName = jndiName.concat("/").concat(field.getName());
        return jndiName;
    }

    protected String getStandardBindingName(Method method) throws ProcessorException {
        Class<?> support = method.getDeclaringClass();
        String jndiName = support.getName();
        jndiName = jndiName.concat("/").concat(this.getAttributeName(method));
        return jndiName;
    }
}

