/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.event.LifecycleCallbacks;
import org.apache.openjpa.event.MethodLifecycleCallbacks;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.MetaDataTag;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetaDataParsers {
    private static final Localizer _loc = Localizer.forPackage(MetaDataParsers.class);

    MetaDataParsers() {
    }

    public static int[] getEventTypes(MetaDataTag tag, OpenJPAConfiguration conf) {
        switch (tag) {
            case PRE_PERSIST: {
                return new int[]{0};
            }
            case POST_PERSIST: {
                boolean immediate = conf.getCallbackOptionsInstance().getPostPersistCallbackImmediate();
                return new int[]{immediate ? 1 : 18};
            }
            case PRE_REMOVE: {
                return new int[]{7};
            }
            case POST_REMOVE: {
                return new int[]{19};
            }
            case PRE_UPDATE: {
                return new int[]{20};
            }
            case POST_UPDATE: {
                return new int[]{21};
            }
            case POST_LOAD: {
                return new int[]{2};
            }
        }
        return null;
    }

    public static void validateMethodsForSameCallback(Class cls, Collection<LifecycleCallbacks> callbacks, Method method, MetaDataTag tag, OpenJPAConfiguration conf, Log log) {
        if (callbacks == null || callbacks.isEmpty()) {
            return;
        }
        for (LifecycleCallbacks lc : callbacks) {
            Method exists;
            if (!(lc instanceof MethodLifecycleCallbacks) || !(exists = ((MethodLifecycleCallbacks)lc).getCallbackMethod()).getDeclaringClass().equals(method.getDeclaringClass()) || exists.equals(method)) continue;
            Localizer.Message msg = _loc.get("multiple-methods-on-callback", new Object[]{method.getDeclaringClass().getName(), method.getName(), exists.getName(), tag.toString()});
            if (conf.getCallbackOptionsInstance().getAllowsMultipleMethodsForSameCallback()) {
                log.warn(msg);
                continue;
            }
            throw new UserException(msg);
        }
    }
}

