/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.MessageDrivenContext;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.xml.ws.WebServiceContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.easybeans.resolver.api.EZBJNDIBeanData;
import org.ow2.easybeans.resolver.api.EZBJNDIData;
import org.ow2.easybeans.resolver.api.EZBRemoteJNDIResolver;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbLocalRefDesc;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.common.digester.JDigester;
import org.ow2.jonas.deployment.common.lib.AbsDeploymentDescManager;
import org.ow2.jonas.deployment.common.xml.EjbRef;
import org.ow2.jonas.deployment.common.xml.JonasEjbRef;
import org.ow2.jonas.deployment.common.xml.JonasMessageDestination;
import org.ow2.jonas.deployment.common.xml.JonasResource;
import org.ow2.jonas.deployment.common.xml.JonasServiceRef;
import org.ow2.jonas.deployment.common.xml.MessageDestinationRef;
import org.ow2.jonas.deployment.common.xml.ResourceRef;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager;
import org.ow2.jonas.deployment.web.JonasWebAppDTDs;
import org.ow2.jonas.deployment.web.JonasWebAppSchemas;
import org.ow2.jonas.deployment.web.WebAppDTDs;
import org.ow2.jonas.deployment.web.WebAppSchemas;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDescException;
import org.ow2.jonas.deployment.web.lib.WarDeployableMetadataFactoryHolder;
import org.ow2.jonas.deployment.web.rules.JonasWebAppRuleSet;
import org.ow2.jonas.deployment.web.rules.WebAppRuleSet;
import org.ow2.jonas.deployment.web.xml.JonasWebApp;
import org.ow2.jonas.deployment.web.xml.WebApp;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.PortComponentRefDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.deployment.ws.lib.WSDeploymentDescManager;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.ee.metadata.common.api.enc.IENCBinding;
import org.ow2.util.ee.metadata.common.api.enc.IENCBindingHolder;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBindingException;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBindingHolder;
import org.ow2.util.ee.metadata.war.api.IWarClassMetadata;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadata;
import org.ow2.util.ee.metadata.war.impl.enc.ENCBindingBuilder;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDeploymentDescManager
extends AbsDeploymentDescManager {
    public static final String WEB_FILE_NAME = "WEB-INF/web.xml";
    public static final String JONAS_WEB_FILE_NAME = "WEB-INF/jonas-web.xml";
    private static boolean parsingWithValidation = true;
    private static JDigester webAppDigester = null;
    private static JDigester jonasWebAppDigester = null;
    private static WebAppRuleSet webAppRuleSet = new WebAppRuleSet();
    private static JonasWebAppRuleSet jonasWebAppRuleSet = new JonasWebAppRuleSet();
    private static WebDeploymentDescManager unique;
    private EjbDeploymentDescManager ejbDDManager = EjbDeploymentDescManager.getInstance();
    private WSDeploymentDescManager wsDDManager = null;
    private static Logger logger;
    private static Hashtable<String, WebContainerDeploymentDesc> staticCache;
    private Hashtable<ClassLoader, Hashtable<URL, URL>> earCLAltDDBindings = new Hashtable();

    private WebDeploymentDescManager() {
    }

    public static WebDeploymentDescManager getInstance() {
        if (unique == null) {
            unique = new WebDeploymentDescManager();
        }
        return unique;
    }

    public WebContainerDeploymentDesc getDeploymentDesc(URL originalWarURL, ClassLoader loaderForCls, ClassLoader earLoader) throws DeploymentDescException {
        return this.getDeploymentDesc(null, originalWarURL, loaderForCls, earLoader);
    }

    public WebContainerDeploymentDesc getDeploymentDesc(URL unpackedWarURL, URL originalWarURL, ClassLoader loaderForCls, ClassLoader earLoader) throws DeploymentDescException {
        MessageDestinationRefDesc[] mdRef;
        IServiceRefDesc[] serviceRef;
        EjbLocalRefDesc[] ejbLocalRef;
        EjbRefDesc[] ejbRef;
        File warFile;
        if (this.wsDDManager == null) {
            this.wsDDManager = WSDeploymentDescManager.getInstance();
        }
        URL warURL = unpackedWarURL;
        if (unpackedWarURL == null) {
            warURL = originalWarURL;
        }
        if (!(warFile = URLUtils.urlToFile((URL)warURL)).exists()) {
            throw new WebContainerDeploymentDescException("Cannot get the deployment descriptor for '" + warFile + "'. The file doesn't exist.");
        }
        URL altDDUrl = null;
        Hashtable<URL, URL> urlAltddBindings = null;
        if (earLoader != null) {
            urlAltddBindings = this.earCLAltDDBindings.get(earLoader);
            if (urlAltddBindings == null) {
                throw new WebContainerDeploymentDescException("Cannot find if there is alt-dd for '" + warFile + "', the setAltDD function was badly called");
            }
            altDDUrl = urlAltddBindings.get(warURL);
        }
        WebContainerDeploymentDesc webDD = null;
        try {
            webDD = altDDUrl != null ? WebDeploymentDescManager.getInstance(warFile.getPath(), loaderForCls, altDDUrl.getFile()) : WebDeploymentDescManager.getInstance(warFile.getPath(), loaderForCls);
        }
        catch (DeploymentDescException dde) {
            throw new WebContainerDeploymentDescException(dde);
        }
        for (EjbRefDesc element : ejbRef = webDD.getEjbRefDesc()) {
            if (element.getJndiName() != null) continue;
            String ejbLink = element.getEjbLink();
            String ejbRefType = element.getEjbRefType();
            String remote = element.getRemote();
            if (ejbLink == null) continue;
            if (earLoader == null) {
                throw new WebContainerDeploymentDescException("Ejb-link is not authorized from a single war. The war must be in an ear.");
            }
            String jndiName = this.getJndiName(originalWarURL, ejbLink, earLoader, ejbRefType, remote, true);
            element.setJndiName(jndiName);
        }
        for (EjbLocalRefDesc element : ejbLocalRef = webDD.getEjbLocalRefDesc()) {
            String ejblink = element.getEjbLink();
            if (earLoader == null) {
                throw new WebContainerDeploymentDescException("Ejb-link is not authorized from a single war. The war must be in an ear.");
            }
            String ejbRefType = element.getEjbRefType();
            String local = element.getLocal();
            String ejbName = this.getJndiName(originalWarURL, ejblink, earLoader, ejbRefType, local, false);
            element.setJndiLocalName(ejbName);
        }
        for (IServiceRefDesc element : serviceRef = webDD.getServiceRefDesc()) {
            List pcRefs = element.getPortComponentRefs();
            for (int j = 0; j < pcRefs.size(); ++j) {
                PortComponentRefDesc pcr = (PortComponentRefDesc)pcRefs.get(j);
                String pclink = pcr.getPortComponentLink();
                if (pclink == null) continue;
                PortComponentDesc pcDesc = this.getPCDesc(originalWarURL, pclink, loaderForCls, earLoader);
                pcr.setPortComponentDesc(pcDesc);
            }
        }
        for (MessageDestinationRefDesc element : mdRef = webDD.getMessageDestinationRefDesc()) {
            if (element.getJndiName() != null) continue;
            String mdLink = element.getMessageDestinationLink();
            String mdType = element.getMessageDestinationType();
            String mdUsage = element.getMessageDestinationUsage();
            if (mdLink == null) continue;
            if (earLoader == null) {
                throw new WebContainerDeploymentDescException("Message-destination-link is not authorized from a single client jar. The client jar must be in an ear.");
            }
            String mdName = this.getMDJndiName(originalWarURL, mdLink, mdType, mdUsage, earLoader);
            element.setJndiName(mdName);
        }
        return webDD;
    }

    private PortComponentDesc getPCDesc(URL warURL, String pcLink, ClassLoader moduleLoader, ClassLoader earLoader) throws WSDeploymentDescException {
        return this.wsDDManager.getPortComponentDesc(warURL, pcLink, moduleLoader, earLoader);
    }

    private String getJndiName(URL warURL, String ejbLink, ClassLoader earLoader, String ejbType, String itf, boolean isEjbRef) throws DeploymentDescException {
        String jndiName;
        block9: {
            jndiName = null;
            try {
                jndiName = this.ejbDDManager.getJndiName(warURL, ejbLink, earLoader, ejbType, null, isEjbRef);
            }
            catch (DeploymentDescException e) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Unable to get JNDI name with the EJB DD manager", (Throwable)e);
                }
                EZBRemoteJNDIResolver jndiResolver = null;
                Object o = null;
                try {
                    o = new InitialContext().lookup("EZB_Remote_JNDIResolver");
                }
                catch (NamingException ne) {
                    logger.log(BasicLevel.DEBUG, (Object)"No Remote EJB3 JNDI Resolver found");
                    throw e;
                }
                jndiResolver = (EZBRemoteJNDIResolver)PortableRemoteObject.narrow((Object)o, EZBRemoteJNDIResolver.class);
                String interfaceName = itf;
                String beanName = ejbLink;
                List jndiDataList = null;
                try {
                    jndiDataList = jndiResolver.getEJBJNDINames(interfaceName, beanName);
                }
                catch (RemoteException re) {
                    throw new DeploymentDescException("Unable to get EJB-LINK for interface'" + interfaceName + "' and beanName'" + beanName + "'", re);
                }
                if (jndiDataList.size() == 0) {
                    throw new DeploymentDescException("Unable to get EJB-LINK for interface'" + interfaceName + "' and beanName'" + beanName + "', no data was found on the remote side.");
                }
                if (jndiDataList.size() > 1) {
                    throw new DeploymentDescException("Unable to get EJB-LINK for interface'" + interfaceName + "' and beanName'" + beanName + "', too many answers : '" + jndiDataList + "'.");
                }
                EZBJNDIBeanData jndiData = (EZBJNDIBeanData)jndiDataList.get(0);
                jndiName = jndiData.getName();
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block9;
                logger.log(BasicLevel.DEBUG, (Object)("Found JNDI Name '" + jndiName + "' for interface'" + interfaceName + "' and beanName'" + beanName + "', too many answers : '" + jndiDataList + "'."));
            }
        }
        return jndiName;
    }

    private String getMDJndiName(URL warURL, String mdLink, String mdType, String mdUsage, ClassLoader earLoader) throws WebContainerDeploymentDescException {
        String ejbJarLink = null;
        String destNameLink = null;
        DeploymentDesc dd = null;
        JonasMessageDestination md = null;
        if (mdLink.indexOf("#") > 0) {
            ejbJarLink = mdLink.split("#")[0];
            destNameLink = mdLink.split("#")[1];
        } else {
            destNameLink = mdLink;
        }
        if (ejbJarLink != null) {
            if (!ejbJarLink.endsWith(".jar")) {
                String err = "Ejbjar filename " + ejbJarLink + " from the message-destination-link " + mdLink + " has a bad format. Correct format :  filename.jar";
                throw new WebContainerDeploymentDescException(err);
            }
            URL ejbJarLinkUrl = null;
            try {
                ejbJarLinkUrl = new File(new File(warURL.getFile()).getParent() + File.separator + ejbJarLink).getCanonicalFile().toURL();
            }
            catch (MalformedURLException mue) {
                String err = "Error when creating an url for the ejb jar filename. Error :" + mue.getMessage();
                throw new WebContainerDeploymentDescException(err);
            }
            catch (IOException ioe) {
                String err = "Error when creating/accessing a file. Error :" + ioe.getMessage();
                throw new WebContainerDeploymentDescException(err);
            }
            if (!new File(ejbJarLinkUrl.getFile()).exists()) {
                String err = "Cannot get the deployment descriptor for '" + ejbJarLinkUrl.getFile() + "'. The file doesn't exist.";
                throw new WebContainerDeploymentDescException(err);
            }
            URL[] ddURL = new URL[]{ejbJarLinkUrl};
            URLClassLoader loaderForClsEjb = new URLClassLoader(ddURL, earLoader);
            try {
                dd = this.ejbDDManager.getDeploymentDesc(ejbJarLinkUrl, loaderForClsEjb, earLoader);
            }
            catch (DeploymentDescException e) {
                String err = "Cannot get the deployment descriptor for '" + ejbJarLinkUrl.getFile() + "'.";
                throw new WebContainerDeploymentDescException(err, e);
            }
            md = dd.getJonasMessageDestination(mdLink);
        }
        if (md == null) {
            String err = "No message-destination-link was found for '" + mdLink + "' in the file " + warURL.getFile() + " specified.";
            WebContainerDeploymentDescException e = new WebContainerDeploymentDescException(err);
            EZBRemoteJNDIResolver jndiResolver = null;
            Object o = null;
            try {
                o = new InitialContext().lookup("EZB_Remote_JNDIResolver");
            }
            catch (NamingException ne) {
                logger.log(BasicLevel.DEBUG, (Object)"No Remote EJB3 JNDI Resolver found");
                throw e;
            }
            jndiResolver = (EZBRemoteJNDIResolver)PortableRemoteObject.narrow((Object)o, EZBRemoteJNDIResolver.class);
            List jndiDataList = null;
            try {
                jndiDataList = jndiResolver.getMessageDestinationJNDINames(destNameLink);
            }
            catch (RemoteException re) {
                throw new WebContainerDeploymentDescException("Unable to get EJB-LINK for destination '" + destNameLink + "'", re);
            }
            if (jndiDataList.size() == 0) {
                throw new WebContainerDeploymentDescException("Unable to get EJB-LINK for destination '" + destNameLink + "'");
            }
            if (jndiDataList.size() > 1) {
                throw new WebContainerDeploymentDescException("Unable to get EJB-LINK for destination '" + destNameLink + "', too many answers : '" + jndiDataList + "'.");
            }
            EZBJNDIData jndiData = (EZBJNDIData)jndiDataList.get(0);
            return jndiData.getName();
        }
        return md.getJndiName();
    }

    public void removeCache(ClassLoader earClassLoader) {
        this.earCLAltDDBindings.remove(earClassLoader);
        this.ejbDDManager.removeCache(earClassLoader);
    }

    public void setAltDD(ClassLoader earClassLoader, URL[] urls, URL[] altDDs) {
        Hashtable<URL, URL> urlAltddBindings = new Hashtable<URL, URL>();
        for (int i = 0; i < urls.length; ++i) {
            if (altDDs[i] == null) continue;
            urlAltddBindings.put(urls[i], altDDs[i]);
        }
        this.earCLAltDDBindings.put(earClassLoader, urlAltddBindings);
    }

    public int getCacheSize() {
        int bufferSize = 0;
        for (ClassLoader loader : this.earCLAltDDBindings.keySet()) {
            bufferSize += this.earCLAltDDBindings.get(loader).size();
        }
        return bufferSize;
    }

    public static WebContainerDeploymentDesc getDeploymentDesc(String filename, ClassLoader loader) throws WebContainerDeploymentDescException {
        WebContainerDeploymentDesc wcdd = null;
        if (staticCache.containsKey(filename)) {
            wcdd = staticCache.get(filename);
        } else {
            if (!new File(filename).exists()) {
                String err = "Cannot get the deployment descriptor for ";
                err = err + "'" + filename + "'. The file doesn't exist.";
                throw new WebContainerDeploymentDescException(err);
            }
            try {
                wcdd = WebDeploymentDescManager.getInstance(filename, loader);
            }
            catch (DeploymentDescException dde) {
                throw new WebContainerDeploymentDescException(dde);
            }
            staticCache.put(filename, wcdd);
        }
        return wcdd;
    }

    public static WebContainerDeploymentDesc getInstance(String warFileName, ClassLoader classLoaderForCls, String altWebXmlFilename) throws DeploymentDescException {
        JonasWebApp jonasWebApp;
        String xmlContent = "";
        String jonasXmlContent = "";
        ZipFile warFile = null;
        InputStream webInputStream = null;
        InputStream jonasWebInputStream = null;
        ZipEntry webZipEntry = null;
        ZipEntry jonasWebZipEntry = null;
        File fWar = new File(warFileName);
        if (!fWar.exists()) {
            String err = "' " + warFileName + "' was not found.";
            throw new WebContainerDeploymentDescException(err);
        }
        if (altWebXmlFilename != null && !new File(altWebXmlFilename).exists()) {
            String err = "The file for the altdd tag for the EAR case '" + altWebXmlFilename + "' was not found.";
            throw new WebContainerDeploymentDescException(err);
        }
        try {
            if (altWebXmlFilename == null) {
                if (fWar.isDirectory()) {
                    File webXmlF = new File(warFileName, WEB_FILE_NAME);
                    if (!webXmlF.exists()) {
                        String err = "You have choose to deploy a war directory but there is no WEB-INF/web.xml file in the directory " + warFileName;
                        throw new WebContainerDeploymentDescException(err);
                    }
                    webInputStream = new FileInputStream(webXmlF);
                    xmlContent = WebDeploymentDescManager.xmlContent(webInputStream);
                    webInputStream = new FileInputStream(webXmlF);
                } else {
                    warFile = new JarFile(warFileName);
                    webZipEntry = ((JarFile)warFile).getEntry(WEB_FILE_NAME);
                    if (webZipEntry == null) {
                        throw new WebContainerDeploymentDescException("The entry 'WEB-INF/web.xml' was not found in the file '" + warFileName + "'.");
                    }
                    webInputStream = ((JarFile)warFile).getInputStream(webZipEntry);
                    xmlContent = WebDeploymentDescManager.xmlContent(webInputStream);
                    webInputStream = ((JarFile)warFile).getInputStream(webZipEntry);
                }
            } else {
                webInputStream = new FileInputStream(altWebXmlFilename);
                xmlContent = WebDeploymentDescManager.xmlContent(webInputStream);
                webInputStream = new FileInputStream(altWebXmlFilename);
            }
            if (fWar.isDirectory()) {
                File webJXmlF = new File(warFileName, JONAS_WEB_FILE_NAME);
                if (webJXmlF.exists()) {
                    jonasWebInputStream = new FileInputStream(webJXmlF);
                    jonasXmlContent = WebDeploymentDescManager.xmlContent(jonasWebInputStream);
                    jonasWebInputStream = new FileInputStream(webJXmlF);
                }
            } else {
                if (warFile == null) {
                    warFile = new JarFile(warFileName);
                }
                if ((jonasWebZipEntry = ((JarFile)warFile).getEntry(JONAS_WEB_FILE_NAME)) != null) {
                    jonasWebInputStream = ((JarFile)warFile).getInputStream(jonasWebZipEntry);
                    jonasXmlContent = WebDeploymentDescManager.xmlContent(jonasWebInputStream);
                    jonasWebInputStream = ((JarFile)warFile).getInputStream(jonasWebZipEntry);
                }
            }
        }
        catch (Exception e) {
            if (warFile != null) {
                try {
                    warFile.close();
                }
                catch (IOException ioe) {
                    logger.log(BasicLevel.WARN, (Object)("Can't close file '" + warFileName + "'"));
                }
            }
            throw new WebContainerDeploymentDescException("Cannot read the XML deployment descriptors of the war file '" + warFileName + "'.", e);
        }
        WebApp webApp = WebDeploymentDescManager.loadWebApp(new InputStreamReader(webInputStream), WEB_FILE_NAME);
        try {
            webInputStream.close();
        }
        catch (IOException e) {
            logger.log(BasicLevel.WARN, (Object)("Can't close InputStream of web.xml from '" + warFileName + "'"));
        }
        if (jonasWebInputStream != null) {
            jonasWebApp = WebDeploymentDescManager.loadJonasWebApp(new InputStreamReader(jonasWebInputStream), JONAS_WEB_FILE_NAME);
            try {
                jonasWebInputStream.close();
            }
            catch (IOException e) {
                logger.log(BasicLevel.WARN, (Object)("Can't close InputStream of jonas-web.xml from '" + warFileName + "'"));
            }
        } else {
            jonasWebApp = new JonasWebApp();
        }
        if (warFile != null) {
            try {
                warFile.close();
            }
            catch (IOException ioe) {
                logger.log(BasicLevel.WARN, (Object)("Can't close file '" + warFileName + "'"));
            }
        }
        IWarDeployableMetadata warDeployableMetadata = WebDeploymentDescManager.getWarMetadata(fWar);
        ENCBindingHolder holder = WebDeploymentDescManager.completeWebApp(warDeployableMetadata, webApp, jonasWebApp, classLoaderForCls);
        Map<String, IWarClassMetadata> pojos = WebDeploymentDescManager.findPOJOWebService(warDeployableMetadata);
        WebContainerDeploymentDesc webDD = new WebContainerDeploymentDesc(warFileName, classLoaderForCls, webApp, jonasWebApp, warDeployableMetadata);
        webDD.setXmlContent(xmlContent);
        webDD.setJOnASXmlContent(jonasXmlContent);
        webDD.setENCBindingHolder((IENCBindingHolder)holder);
        webDD.setWebServices(pojos);
        return webDD;
    }

    private static Map<String, IWarClassMetadata> findPOJOWebService(IWarDeployableMetadata warDeployableMetadata) {
        Hashtable<String, IWarClassMetadata> services = new Hashtable<String, IWarClassMetadata>();
        Collection classes = warDeployableMetadata.getWarClassMetadataCollection();
        for (IWarClassMetadata clazz : classes) {
            boolean isAnnotated;
            boolean isInterface = (clazz.getJClass().getAccess() & 0x200) != 0;
            boolean isAbstract = (clazz.getJClass().getAccess() & 0x400) != 0;
            boolean bl = isAnnotated = clazz.getWebServiceMarker() != null;
            if (isInterface || isAbstract || !isAnnotated) continue;
            String classname = clazz.getJClass().getName().replace('/', '.');
            services.put(classname, clazz);
        }
        return services;
    }

    public static ENCBindingHolder completeWebApp(IWarDeployableMetadata warDeployableMetadata, WebApp webApp, JonasWebApp jonasWebApp, ClassLoader classLoader) throws WebContainerDeploymentDescException {
        ENCBindingHolder encBindingHolder = null;
        try {
            encBindingHolder = ENCBindingBuilder.analyze((IWarDeployableMetadata)warDeployableMetadata);
        }
        catch (ENCBindingException e) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to analyze metadata of '" + ((WARDeployable)warDeployableMetadata.getDeployable()).getArchive().getName() + "'"), (Throwable)e);
        }
        List resourcesBindings = encBindingHolder.getResourceBindings();
        for (IENCBinding resourceBinding : resourcesBindings) {
            IJAnnotationResource annotationResource = (IJAnnotationResource)resourceBinding.getValue();
            String resourceName = resourceBinding.getName();
            if (WebDeploymentDescManager.containsResource(resourceName, webApp)) continue;
            String type = annotationResource.getType();
            String messageDestinationLink = annotationResource.getMessageDestinationLink();
            if (messageDestinationLink == null) {
                if (type.equals(SessionContext.class.getName()) || type.equals(EJBContext.class.getName()) || type.equals(MessageDrivenContext.class.getName()) || type.equals(WebServiceContext.class.getName())) continue;
                ResourceRef resourceRef = new ResourceRef();
                webApp.addResourceRef(resourceRef);
                resourceRef.setResRefName(resourceBinding.getName());
                Resource.AuthenticationType authType = annotationResource.getAuthenticationType();
                if (authType.equals((Object)Resource.AuthenticationType.CONTAINER)) {
                    resourceRef.setResAuth("Container");
                } else {
                    resourceRef.setResAuth("Application");
                }
                resourceRef.setResType(type);
                String mappedName = annotationResource.getMappedName();
                if (mappedName == null) continue;
                JonasResource jonasResource = new JonasResource();
                jonasResource.setResRefName(annotationResource.getName());
                jonasResource.setJndiName(mappedName);
                jonasWebApp.addJonasResource(jonasResource);
                continue;
            }
            MessageDestinationRef messageDestinationRef = new MessageDestinationRef();
            webApp.addMessageDestinationRef(messageDestinationRef);
            messageDestinationRef.setMessageDestinationRefName(resourceBinding.getName());
            messageDestinationRef.setMessageDestinationLink(messageDestinationLink);
            messageDestinationRef.setMessageDestinationType(annotationResource.getType());
            String mappedName = annotationResource.getMappedName();
            if (mappedName == null) continue;
            JonasMessageDestination jonasMessageDestination = new JonasMessageDestination();
            jonasMessageDestination.setMessageDestinationName(annotationResource.getName());
            jonasMessageDestination.setJndiName(mappedName);
            jonasWebApp.addJonasMessageDestination(jonasMessageDestination);
        }
        List webServicesBindings = encBindingHolder.getWebServicesBindings();
        for (IENCBinding binding : webServicesBindings) {
            IJaxwsWebServiceRef wsr = (IJaxwsWebServiceRef)binding.getValue();
            JonasServiceRef jsr = WebDeploymentDescManager.findJonasServiceRef(jonasWebApp.getJonasServiceRefList(), wsr.getName());
            if (jsr == null) continue;
            WebDeploymentDescManager.mergeWebServiceRef(jsr, wsr);
        }
        List ejbsBindings = encBindingHolder.getEJBBindings();
        for (IENCBinding ejbBinding : ejbsBindings) {
            String beanInterface;
            EjbRef ejbRef = new EjbRef();
            webApp.addEjbRef(ejbRef);
            ejbRef.setEjbRefName(ejbBinding.getName());
            IJEjbEJB jEJB = (IJEjbEJB)ejbBinding.getValue();
            String mappedName = jEJB.getMappedName();
            if (mappedName != null) {
                JonasEjbRef jonasEjbRef = new JonasEjbRef();
                jonasEjbRef.setEjbRefName(ejbBinding.getName());
                jonasEjbRef.setJndiName(mappedName);
                jonasWebApp.addJonasEjbRef(jonasEjbRef);
                continue;
            }
            String beanName = ((IJEjbEJB)ejbBinding.getValue()).getBeanName();
            if (beanName != null && !"".equals(beanName)) {
                ejbRef.setEjbLink(beanName);
            }
            if ((beanInterface = ((IJEjbEJB)ejbBinding.getValue()).getBeanInterface()) == null || "".equals(beanInterface)) continue;
            ejbRef.setRemote(beanInterface);
        }
        return encBindingHolder;
    }

    public static IWarDeployableMetadata getWarMetadata(File fWar) throws WebContainerDeploymentDescException {
        IWarDeployableMetadata warDeployableMetadata;
        IArchive webArchive = ArchiveManager.getInstance().getArchive((Object)fWar);
        try {
            WARDeployable warDeployable = (WARDeployable)WARDeployable.class.cast(DeployableHelper.getDeployable((IArchive)webArchive));
            if (!fWar.isDirectory()) {
                warDeployable = (WARDeployable)UnpackDeployableHelper.unpack((IDeployable)warDeployable);
                logger.log(BasicLevel.DEBUG, (Object)"Unpack a war to create metadata");
            }
            warDeployableMetadata = (IWarDeployableMetadata)WarDeployableMetadataFactoryHolder.getWarDeployableMetadataFactory().createDeployableMetadata((IDeployable)warDeployable);
        }
        catch (Exception e) {
            throw new WebContainerDeploymentDescException(e);
        }
        return warDeployableMetadata;
    }

    public static WebContainerDeploymentDesc getInstance(String warFileName, ClassLoader classLoaderForCls) throws DeploymentDescException {
        return WebDeploymentDescManager.getInstance(warFileName, classLoaderForCls, null);
    }

    public static WebApp loadWebApp(Reader reader, String fileName) throws DeploymentDescException {
        WebApp webApp = new WebApp();
        if (webAppDigester == null) {
            webAppDigester = new JDigester(webAppRuleSet, WebDeploymentDescManager.getParsingWithValidation(), true, new WebAppDTDs(), new WebAppSchemas());
            webAppDigester.setUseContextClassLoader(false);
        }
        try {
            webAppDigester.parse(reader, fileName, webApp);
        }
        catch (DeploymentDescException e) {
            throw e;
        }
        finally {
            webAppDigester.push(null);
        }
        return webApp;
    }

    public static JonasWebApp loadJonasWebApp(Reader reader, String fileName) throws DeploymentDescException {
        JonasWebApp jonasWebApp = new JonasWebApp();
        if (jonasWebAppDigester == null) {
            jonasWebAppDigester = new JDigester(jonasWebAppRuleSet, WebDeploymentDescManager.getParsingWithValidation(), true, new JonasWebAppDTDs(), new JonasWebAppSchemas());
        }
        try {
            jonasWebAppDigester.parse(reader, fileName, jonasWebApp);
        }
        catch (DeploymentDescException e) {
            throw e;
        }
        finally {
            jonasWebAppDigester.push(null);
        }
        return jonasWebApp;
    }

    public static boolean getParsingWithValidation() {
        return parsingWithValidation;
    }

    public static void setParsingWithValidation(boolean validation) {
        parsingWithValidation = validation;
    }

    static {
        logger = Log.getLogger((String)"org.ow2.jonas.web");
        staticCache = new Hashtable();
    }
}

