/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class QueryBasedValueHolder
extends DatabaseValueHolder {
    protected transient ReadQuery query;

    public QueryBasedValueHolder(ReadQuery query, AbstractRecord row, AbstractSession session) {
        this.row = row;
        this.session = session;
        if (!session.isUnitOfWork()) {
            this.session = session.getRootSession(query);
        }
        this.query = query;
    }

    public ReadQuery getQuery() {
        return this.query;
    }

    protected Object instantiate() throws DatabaseException {
        return this.instantiate(this.session);
    }

    protected Object instantiate(AbstractSession session) throws DatabaseException {
        if (session == null) {
            throw ValidationException.instantiatingValueholderWithNullSession();
        }
        return session.executeQuery((DatabaseQuery)this.getQuery(), this.getRow());
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate(unitOfWorkValueHolder.getUnitOfWork());
    }

    public void releaseWrappedValueHolder() {
        AbstractSession session = this.getSession();
        if (session != null && session.isUnitOfWork()) {
            this.setSession(session.getRootSession(this.query));
        }
    }

    protected void resetFields() {
        super.resetFields();
        this.query = null;
    }

    protected void setQuery(ReadQuery theQuery) {
        this.query = theQuery;
    }

    public boolean isPessimisticLockingValueHolder() {
        if (this.query == null || !this.query.isObjectLevelReadQuery()) {
            return false;
        }
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.query;
        return query.isLockQuery(this.session);
    }
}

