/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public abstract class ObjectBuildingQuery
extends ReadQuery {
    protected Class referenceClass;
    protected String referenceClassName;
    protected boolean shouldRefreshIdentityMapResult = false;
    protected boolean shouldRefreshRemoteIdentityMapResult;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected ForUpdateClause lockingClause;
    public static final short NO_LOCK = 0;
    public static final short LOCK = 1;
    public static final short LOCK_NOWAIT = 2;
    public static final short DEFAULT_LOCK_MODE = -1;
    protected long executionTime = 0L;
    protected boolean shouldUseExclusiveConnection = false;
    public static final String LOCK_RESULT_PROPERTY = "LOCK_RESULT";
    protected boolean wasDefaultLockMode = false;
    protected boolean shouldBuildNullForNullPk;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class referenceClass;
        block5: {
            super.convertClassNamesToClasses(classLoader);
            referenceClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exception.getException());
                    }
                }
                referenceClass = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
            }
            catch (ClassNotFoundException exc) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exc);
            }
        }
        this.setReferenceClass(referenceClass);
    }

    protected boolean wasDefaultLockMode() {
        return this.wasDefaultLockMode;
    }

    protected void setWasDefaultLockMode(boolean wasDefaultLockMode) {
        this.wasDefaultLockMode = wasDefaultLockMode;
    }

    public Object deepClone() {
        return this.clone();
    }

    public void copyFromQuery(DatabaseQuery query) {
        super.copyFromQuery(query);
        if (query.isObjectBuildingQuery()) {
            ObjectBuildingQuery readQuery = (ObjectBuildingQuery)query;
            this.shouldBuildNullForNullPk = readQuery.shouldBuildNullForNullPk;
            this.shouldRefreshIdentityMapResult = readQuery.shouldRefreshIdentityMapResult;
            this.shouldRefreshRemoteIdentityMapResult = readQuery.shouldRefreshRemoteIdentityMapResult;
            this.shouldRegisterResultsInUnitOfWork = readQuery.shouldRegisterResultsInUnitOfWork;
            this.shouldUseExclusiveConnection = readQuery.shouldUseExclusiveConnection;
        }
    }

    public void prepareFromQuery(DatabaseQuery query) {
        super.prepareFromQuery(query);
        if (query.isObjectBuildingQuery()) {
            ObjectBuildingQuery objectQuery = (ObjectBuildingQuery)query;
            this.referenceClass = objectQuery.referenceClass;
            this.referenceClassName = objectQuery.referenceClassName;
            this.lockingClause = objectQuery.lockingClause;
            this.wasDefaultLockMode = objectQuery.wasDefaultLockMode;
        }
    }

    public void dontRefreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(false);
    }

    public void dontRefreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(false);
    }

    public boolean hasExecutionFetchGroup() {
        return false;
    }

    public FetchGroup getExecutionFetchGroup() {
        return null;
    }

    public EntityFetchGroup getEntityFetchGroup() {
        return null;
    }

    public short getLockMode() {
        if (this.lockingClause == null) {
            return -1;
        }
        return this.lockingClause.getLockMode();
    }

    public List getDataResults() {
        return null;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public boolean hasPartialAttributeExpressions() {
        return false;
    }

    public boolean isLockQuery() {
        return this.getLockMode() > 0;
    }

    public boolean isObjectBuildingQuery() {
        return true;
    }

    public boolean isRegisteringResults() {
        return this.shouldRegisterResultsInUnitOfWork() && this.descriptor.shouldRegisterResultsInUnitOfWork() || this.isLockQuery();
    }

    public void refreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(true);
    }

    public void refreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(true);
    }

    public Object registerIndividualResult(Object result, Object primaryKey, UnitOfWorkImpl unitOfWork, JoinedAttributeManager joinManager, ClassDescriptor concreteDescriptor) {
        if (concreteDescriptor == null) {
            concreteDescriptor = unitOfWork.getDescriptor(result.getClass());
        }
        if (unitOfWork.isClassReadOnly(result.getClass(), concreteDescriptor)) {
            this.recordCloneForPessimisticLocking(result, unitOfWork);
            return result;
        }
        Object clone = null;
        if (!this.isRegisteringResults()) {
            if (primaryKey == null) {
                primaryKey = concreteDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(result, this.getSession());
            }
            if ((clone = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(primaryKey, result.getClass(), concreteDescriptor)) == null) {
                clone = result;
            }
        } else {
            clone = unitOfWork.registerExistingObject(result, concreteDescriptor);
        }
        this.postRegisterIndividualResult(clone, result, primaryKey, unitOfWork, joinManager, concreteDescriptor);
        return clone;
    }

    public void postRegisterIndividualResult(Object clone, Object original, Object primaryKey, UnitOfWorkImpl unitOfWork, JoinedAttributeManager joinManager, ClassDescriptor concreteDescriptor) {
        if (this.shouldRefreshIdentityMapResult()) {
            if (primaryKey == null) {
                primaryKey = concreteDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(original, unitOfWork);
            }
            if (unitOfWork.getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(primaryKey, original.getClass(), concreteDescriptor)) {
                if (this.shouldCascadeAllParts()) {
                    unitOfWork.deepRevertObject(clone);
                } else if (this.shouldCascadePrivateParts()) {
                    unitOfWork.revertObject(clone);
                } else if (this.shouldCascadeByMapping()) {
                    unitOfWork.revertObject(clone, 4);
                } else if (!this.shouldCascadeParts()) {
                    unitOfWork.shallowRevertObject(clone);
                }
            } else if (this.shouldCascadeAllParts()) {
                unitOfWork.deepMergeClone(original);
            } else if (this.shouldCascadePrivateParts()) {
                unitOfWork.mergeClone(original);
            } else if (this.shouldCascadeByMapping()) {
                unitOfWork.mergeClone(original, 4);
            } else if (!this.shouldCascadeParts()) {
                unitOfWork.shallowMergeClone(original);
            }
        }
        if (joinManager != null && joinManager.hasJoinedAttributeExpressions()) {
            this.triggerJoinExpressions(unitOfWork, joinManager, clone, concreteDescriptor);
        }
    }

    private void triggerJoinExpressions(UnitOfWorkImpl unitOfWork, JoinedAttributeManager joinManager, Object clone, ClassDescriptor concreteDescriptor) {
        List<Expression> joinExpressions = joinManager.getJoinedAttributeExpressions();
        int size = joinExpressions.size();
        if (size == 0 || clone == null) {
            return;
        }
        if (concreteDescriptor == null) {
            concreteDescriptor = unitOfWork.getDescriptor(clone.getClass());
        }
        for (int index = 0; index < size; ++index) {
            QueryKeyExpression queryKeyExpression;
            Object attributeValue;
            QueryKeyExpression baseExpression = (QueryKeyExpression)joinManager.getJoinedAttributes().get(index);
            DatabaseMapping mapping = joinManager.getJoinedAttributeMappings().get(index);
            if (mapping == null || (attributeValue = joinManager.getValueFromObjectForExpression(unitOfWork, clone, baseExpression)) == null || baseExpression == (queryKeyExpression = (QueryKeyExpression)joinExpressions.get(index))) continue;
            ObjectLevelReadQuery nestedQuery = null;
            if (joinManager.getJoinedMappingQueryClones() == null) {
                if (joinManager.getJoinedMappingQueries_() != null) {
                    nestedQuery = joinManager.getJoinedMappingQueries_().get(mapping);
                }
            } else {
                nestedQuery = joinManager.getJoinedMappingQueryClones().get(mapping);
            }
            if (nestedQuery == null || nestedQuery.getJoinedAttributeManager() == null) continue;
            if (!mapping.isCollectionMapping()) {
                this.triggerJoinExpressions(unitOfWork, nestedQuery.getJoinedAttributeManager(), attributeValue, null);
                continue;
            }
            ContainerPolicy cp = ((CollectionMapping)mapping).getContainerPolicy();
            Object iterator = cp.iteratorFor(attributeValue);
            while (cp.hasNext(iterator)) {
                this.triggerJoinExpressions(unitOfWork, nestedQuery.getJoinedAttributeManager(), cp.next(iterator, unitOfWork), null);
            }
        }
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public void setLockMode(short lockMode) {
        this.lockingClause = ForUpdateClause.newInstance(lockMode);
    }

    public void setReferenceClass(Class aClass) {
        this.referenceClass = aClass;
        this.setIsPrepared(false);
    }

    public void setReferenceClassName(String aClass) {
        this.referenceClassName = aClass;
        this.setIsPrepared(false);
    }

    public void setShouldRefreshIdentityMapResult(boolean shouldRefreshIdentityMapResult) {
        this.shouldRefreshIdentityMapResult = shouldRefreshIdentityMapResult;
        if (shouldRefreshIdentityMapResult) {
            this.setShouldRefreshRemoteIdentityMapResult(true);
        }
    }

    public void setShouldRefreshRemoteIdentityMapResult(boolean shouldRefreshIdentityMapResult) {
        this.shouldRefreshRemoteIdentityMapResult = shouldRefreshIdentityMapResult;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean shouldRegisterResultsInUnitOfWork) {
        this.shouldRegisterResultsInUnitOfWork = shouldRegisterResultsInUnitOfWork;
    }

    public void setShouldUseExclusiveConnection(boolean shouldUseExclusiveConnection) {
        this.shouldUseExclusiveConnection = shouldUseExclusiveConnection;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldUseExclusiveConnection() {
        return this.shouldUseExclusiveConnection;
    }

    public boolean shouldReadAllMappings() {
        return true;
    }

    public boolean shouldReadMapping(DatabaseMapping mapping) {
        return true;
    }

    public boolean shouldRefreshIdentityMapResult() {
        return this.shouldRefreshIdentityMapResult;
    }

    public boolean shouldRefreshRemoteIdentityMapResult() {
        return this.shouldRefreshRemoteIdentityMapResult;
    }

    public boolean isAttributeJoined(ClassDescriptor mappingDescriptor, String attributeName) {
        return false;
    }

    public boolean isClonePessimisticLocked(Object clone, UnitOfWorkImpl uow) {
        return false;
    }

    public void recordCloneForPessimisticLocking(Object clone, UnitOfWorkImpl uow) {
        if (this.isLockQuery() && this.lockingClause.isReferenceClassLocked()) {
            uow.addPessimisticLockedClone(clone);
        }
    }

    public boolean isDefaultLock() {
        return this.lockingClause == null;
    }

    public boolean shouldBuildNullForNullPk() {
        return this.shouldBuildNullForNullPk;
    }

    public void setShouldBuildNullForNullPk(boolean shouldBuildNullForNullPk) {
        this.shouldBuildNullForNullPk = shouldBuildNullForNullPk;
    }
}

